/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.util;

import com.nokia.widgets.util.SystemUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.LayoutFocusTraversalPolicy;

public class FocusUtils {
    protected static final FocusFitnessPolicy fitnessPolicy = new FocusFitnessPolicy();

    public static boolean requestFocusFor(Component component) {
        if (component instanceof Container) {
            FocusTraversalPolicy policy = ((Container)component).getFocusTraversalPolicy();
            if (policy != null) {
                Component firstPolicyComp;
                Component policyComp = firstPolicyComp = policy.getDefaultComponent((Container)component);
                while (policyComp != null && !FocusUtils.isDrawnToScreen(policyComp) && policyComp.isFocusCycleRoot((Container)component)) {
                    try {
                        policyComp = policy.getComponentAfter((Container)component, policyComp);
                    }
                    catch (IllegalArgumentException ex) {
                        return false;
                    }
                    if (!firstPolicyComp.equals(policyComp)) continue;
                    return false;
                }
                if (policyComp != null) {
                    policyComp.requestFocusInWindow();
                    return true;
                }
                return false;
            }
            Component[] childComps = ((Container)component).getComponents();
            if (childComps.length > 0) {
                int counter = 0;
                while (counter < childComps.length) {
                    Component childComp = childComps[counter];
                    if (FocusUtils.requestFocusFor(childComp)) {
                        return true;
                    }
                    ++counter;
                }
            }
        }
        if (fitnessPolicy.accept(component)) {
            component.requestFocusInWindow();
            return true;
        }
        return false;
    }

    public static boolean isDrawnToScreen(Object component) {
        Rectangle visibleRect;
        return !(component instanceof JComponent) || !SystemUtils.isEqual((visibleRect = ((JComponent)component).getVisibleRect()).getWidth(), 0.0) || !SystemUtils.isEqual(visibleRect.getHeight(), 0.0);
    }

    public static boolean isKeyBoardFocusTraversable(Component component) {
        if (component instanceof JComponent) {
            return !Boolean.FALSE.equals(((JComponent)component).getClientProperty("OrangeTouch.isKeyboardFocusTraversable"));
        }
        return true;
    }

    protected static class FocusFitnessPolicy
    extends LayoutFocusTraversalPolicy {
        protected FocusFitnessPolicy() {
        }

        @Override
        protected boolean accept(Component component) {
            return super.accept(component) && FocusUtils.isDrawnToScreen(component) && FocusUtils.isKeyBoardFocusTraversable(component);
        }
    }
}

