/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.util;

import com.nokia.widgets.icons.CompoundIcon;
import com.nokia.widgets.icons.PEmptyIcon;
import com.nokia.widgets.spinner.PSpinner;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public abstract class IconDecoration
extends JLabel
implements PropertyChangeListener {
    private static final Icon PEN_ICON = new CompoundIcon(12, 16, WidgetResources.getImageIcon("Pen.Icon"));
    private static final Icon EMPTY_ICON = new PEmptyIcon(16, 12);
    private JComponent myComponent;
    private Object myUnmodifiedValue = null;

    public static IconDecoration createDecoration(JTextComponent textComponent) {
        return new TextFieldDecoration(textComponent);
    }

    public static IconDecoration createDecoration(JToggleButton toggleButton) {
        return new ToggleButtonDecoration(toggleButton);
    }

    public static IconDecoration createDecoration(JComboBox comboBox) {
        return new ComboBoxDecoration(comboBox);
    }

    public static IconDecoration createDecoration(PSpinner spinner) {
        return new SpinnerDecoration(spinner);
    }

    public IconDecoration(JComponent component) {
        this.myComponent = component;
        this.setIcon(EMPTY_ICON);
        this.setSize(this.getPreferredSize());
        this.myComponent.addPropertyChangeListener(this);
    }

    public void setUnmodifiedValue(Object unmodifiedValue) {
        this.myUnmodifiedValue = unmodifiedValue;
        this.installTo(this.myUnmodifiedValue != null ? this.myComponent.getParent() : null);
        this.updateStatus();
    }

    public abstract Object getValue();

    protected void installTo(Container container) {
        if (container != null) {
            LayoutManager manager = container.getLayout();
            if ("net.miginfocom.swing.MigLayout".equals(manager.getClass().getName())) {
                this.installListeners();
                container.add((Component)this, "external");
                this.revalidate();
                this.repaint();
            }
        } else if (this.getParent() != null) {
            this.uninstallListeners();
            this.getParent().remove(this);
            this.revalidate();
            this.repaint();
        }
    }

    protected abstract void installListeners();

    protected abstract void uninstallListeners();

    public void setModified(boolean modified) {
        this.setIcon(modified ? PEN_ICON : EMPTY_ICON);
    }

    public void updateStatus() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (ClientPropertyUtil.booleanValue(IconDecoration.this.myComponent, "requiredButMissing")) {
                    IconDecoration.this.setModified(false);
                } else {
                    IconDecoration.this.setModified(IconDecoration.this.myUnmodifiedValue == null ? false : !IconDecoration.this.myUnmodifiedValue.equals(IconDecoration.this.getValue()));
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public Icon getIcon() {
        return !this.isEnabled() ? EMPTY_ICON : super.getIcon();
    }

    @Override
    public boolean isEnabled() {
        return this.myComponent.isEnabled();
    }

    @Override
    public boolean isVisible() {
        return this.myComponent.isVisible();
    }

    @Override
    public int getX() {
        return this.myComponent.getX() - this.getWidth();
    }

    @Override
    public int getY() {
        return this.myComponent.getY() + (this.myComponent.getHeight() - this.getHeight()) / 2;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("ancestor".equals(evt.getPropertyName())) {
            this.installTo((Container)evt.getNewValue());
        }
    }

    public static class ComboBoxDecoration
    extends IconDecoration
    implements ItemListener,
    DocumentListener {
        private JComboBox myComboBox;

        public ComboBoxDecoration(JComboBox comboBox) {
            super(comboBox);
            this.myComboBox = comboBox;
        }

        @Override
        public Object getValue() {
            JTextComponent editor = this.getEditorComponentAsTextField();
            if (this.myComboBox.isEditable() && editor != null) {
                return editor.getText();
            }
            return this.myComboBox.getSelectedItem();
        }

        @Override
        protected void installListeners() {
            this.myComboBox.addItemListener(this);
            JTextComponent editor = this.getEditorComponentAsTextField();
            if (editor != null) {
                editor.getDocument().addDocumentListener(this);
            }
        }

        @Override
        protected void uninstallListeners() {
            this.myComboBox.removeItemListener(this);
            JTextComponent editor = this.getEditorComponentAsTextField();
            if (editor != null) {
                editor.getDocument().removeDocumentListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            super.propertyChange(evt);
            if ("editor".equals(evt.getPropertyName())) {
                JTextComponent newTextEditor;
                ComboBoxEditor oldEditor = (ComboBoxEditor)evt.getOldValue();
                ComboBoxEditor newEditor = (ComboBoxEditor)evt.getNewValue();
                JTextComponent oldTextEditor = this.getEditorComponentAsTextField(oldEditor);
                if (oldTextEditor != null) {
                    oldTextEditor.getDocument().removeDocumentListener(this);
                }
                if ((newTextEditor = this.getEditorComponentAsTextField(newEditor)) != null) {
                    newTextEditor.getDocument().addDocumentListener(this);
                }
            }
            if ("editable".equals(evt.getPropertyName())) {
                this.updateStatus();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.updateStatus();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateStatus();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        private JTextComponent getEditorComponentAsTextField(ComboBoxEditor editor) {
            if (editor != null && editor.getEditorComponent() instanceof JTextComponent) {
                return (JTextComponent)this.myComboBox.getEditor().getEditorComponent();
            }
            return null;
        }

        private JTextComponent getEditorComponentAsTextField() {
            if (this.myComboBox.getEditor() != null && this.myComboBox.getEditor().getEditorComponent() instanceof JTextComponent) {
                return (JTextComponent)this.myComboBox.getEditor().getEditorComponent();
            }
            return null;
        }
    }

    public static class SpinnerDecoration
    extends IconDecoration
    implements ChangeListener {
        private PSpinner mySpinner;

        public SpinnerDecoration(PSpinner spinner) {
            super(spinner);
            this.mySpinner = spinner;
        }

        @Override
        public Object getValue() {
            return this.mySpinner.getValue();
        }

        @Override
        protected void installListeners() {
            this.mySpinner.addChangeListener(this);
        }

        @Override
        protected void uninstallListeners() {
            this.mySpinner.removeChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateStatus();
        }
    }

    public static class TextFieldDecoration
    extends IconDecoration
    implements DocumentListener {
        private JTextComponent myTextComponent;

        public TextFieldDecoration(JTextComponent component) {
            super(component);
            this.myTextComponent = component;
        }

        @Override
        public Object getValue() {
            return this.myTextComponent.getText();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateStatus();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            super.propertyChange(evt);
            if ("document".equals(evt.getPropertyName())) {
                Document oldDoc;
                Document newDoc = (Document)evt.getNewValue();
                if (newDoc != null) {
                    newDoc.addDocumentListener(this);
                }
                if ((oldDoc = (Document)evt.getOldValue()) != null) {
                    oldDoc.removeDocumentListener(this);
                }
            }
        }

        @Override
        protected void installListeners() {
            if (this.myTextComponent.getDocument() != null) {
                this.myTextComponent.getDocument().addDocumentListener(this);
            }
        }

        @Override
        protected void uninstallListeners() {
            if (this.myTextComponent.getDocument() != null) {
                this.myTextComponent.getDocument().removeDocumentListener(this);
            }
        }
    }

    public static class ToggleButtonDecoration
    extends IconDecoration
    implements ChangeListener {
        private JToggleButton myToggleButton;

        public ToggleButtonDecoration(JToggleButton toggleButton) {
            super(toggleButton);
            this.myToggleButton = toggleButton;
        }

        @Override
        public Object getValue() {
            return this.myToggleButton.isSelected();
        }

        @Override
        protected void installListeners() {
            this.myToggleButton.addChangeListener(this);
        }

        @Override
        protected void uninstallListeners() {
            this.myToggleButton.removeChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateStatus();
        }
    }
}

