/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.util;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.painters.FocusFilter;
import com.nokia.laf.painters.SolidColorFilter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ImageUtils {
    private static final Color ICON_SHADOW_COLOR = new Color(230, 230, 230);
    private static ImageObserver EMPTY_OBSERVER = new ImageObserver(){

        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            return true;
        }
    };
    private static BufferedImage theEmptyImage = null;

    public static BufferedImage readImage(String name) {
        try {
            return ImageIO.read(NetLookAndFeel.class.getResource("icons/" + name));
        }
        catch (Exception e) {
            System.out.println("ImageUtils.readImage: " + e.getMessage());
            return ImageUtils.createEmptyImage(6, 6);
        }
    }

    public static BufferedImage readImageFromPath(String name) {
        try {
            InputStream imageStream = ImageUtils.class.getResourceAsStream(name);
            BufferedImage bfImage = ImageIO.read(imageStream);
            imageStream.close();
            return bfImage;
        }
        catch (IOException e) {
            e.printStackTrace();
            return ImageUtils.createEmptyImage(6, 6);
        }
    }

    public static boolean compareImages(BufferedImage img1, BufferedImage img2, BufferedImage diff) {
        if (img1.getWidth() != img2.getWidth()) {
            return false;
        }
        if (img1.getHeight() != img2.getHeight()) {
            return false;
        }
        int width = img1.getWidth();
        int height = img1.getHeight();
        boolean equal = true;
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                if (img1.getRGB(j, i) != img2.getRGB(j, i)) {
                    equal = false;
                    if (diff != null) {
                        diff.setRGB(j, i, Color.RED.getRGB());
                    }
                } else if (diff != null) {
                    diff.setRGB(j, i, img1.getRGB(j, i));
                }
                ++j;
            }
            ++i;
        }
        return equal;
    }

    public static BufferedImage createMirrorImage(Image src) {
        int width = src.getWidth(EMPTY_OBSERVER);
        int height = src.getHeight(EMPTY_OBSERVER);
        BufferedImage image = ImageUtils.createEmptyImage(width, height);
        Graphics2D g2 = image.createGraphics();
        g2.scale(-1.0, 1.0);
        g2.translate(-width, 0);
        g2.drawImage(src, 0, 0, null);
        g2.dispose();
        return image;
    }

    public static BufferedImage createFlippedImage(Component c, Icon src) {
        int width = src.getIconWidth();
        int height = src.getIconHeight();
        BufferedImage image = ImageUtils.createEmptyImage(width, height);
        Graphics2D g2 = image.createGraphics();
        g2.scale(1.0, -1.0);
        g2.translate(0, -height);
        src.paintIcon(c, g2, 0, 0);
        g2.dispose();
        return image;
    }

    public static BufferedImage createFlippedImage(Image src) {
        int width = src.getWidth(EMPTY_OBSERVER);
        int height = src.getHeight(EMPTY_OBSERVER);
        BufferedImage image = ImageUtils.createEmptyImage(width, height);
        Graphics2D g2 = image.createGraphics();
        g2.scale(1.0, -1.0);
        g2.translate(0, -height);
        g2.drawImage(src, 0, 0, null);
        g2.dispose();
        return image;
    }

    public static BufferedImage createRotatedImage(BufferedImage src, int direction) {
        switch (direction) {
            case 1: {
                return ImageUtils.createRotatedImage((Image)src, false);
            }
            case 5: {
                return ImageUtils.createRotatedImage((Image)src, true);
            }
            case 7: {
                return ImageUtils.createMirrorImage(src);
            }
            case 3: {
                return src;
            }
        }
        return ImageUtils.createEmptyImage(src.getWidth(), src.getHeight());
    }

    public static BufferedImage createRotatedImage(Image src, boolean clockwise) {
        int width = src.getWidth(EMPTY_OBSERVER);
        int height = src.getHeight(EMPTY_OBSERVER);
        BufferedImage image = ImageUtils.createEmptyImage(height, width);
        Graphics2D g = image.createGraphics();
        g.rotate(clockwise ? 1.5707963267948966 : -1.5707963267948966);
        g.translate(clockwise ? 0 : -width, clockwise ? -height : 0);
        g.drawImage(src, 0, 0, null);
        g.dispose();
        return image;
    }

    public static BufferedImage createEmptyImage(int width, int height) {
        return ImageUtils.createEmptyImage(width, height, null);
    }

    public static BufferedImage createEmptyImage(int width, int height, Color color) {
        BufferedImage image = new BufferedImage(width, height, 2);
        if (color != null) {
            Graphics2D graphics = image.createGraphics();
            graphics.setColor(color);
            graphics.setComposite(AlphaComposite.Src);
            graphics.fillRect(0, 0, width, height);
            graphics.dispose();
        }
        return image;
    }

    public static Image createDisabledImage(Image image) {
        return ImageUtils.createFilteredImage(image, new GrayFilter(true, 60));
    }

    public static Image createFilteredImage(Image image, RGBImageFilter filter) {
        FilteredImageSource prod = new FilteredImageSource(image.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }

    public static Image createRolloverImage(Image image) {
        return ImageUtils.createSolidColorImage(image, NetTheme.getHoverColor());
    }

    public static Image createSolidColorImage(Image image, Color color) {
        SolidColorFilter filter = new SolidColorFilter(color);
        FilteredImageSource prod = new FilteredImageSource(image.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }

    public static ImageIcon createSolidColorIcon(Component component, Icon icon, Color color) {
        return ImageUtils.createSolidColorIcon(component, icon, color, true);
    }

    public static ImageIcon createSolidColorIcon(Component component, Icon icon, Color color, boolean retainWhite) {
        BufferedImage image = ImageUtils.createImage(component, icon);
        SolidColorFilter filter = new SolidColorFilter(color, retainWhite);
        FilteredImageSource prod = new FilteredImageSource(((Image)image).getSource(), filter);
        return new ImageIcon(Toolkit.getDefaultToolkit().createImage(prod));
    }

    public static ImageIcon createFocusedIcon(Component component, Icon icon) {
        BufferedImage image = ImageUtils.createImage(component, icon);
        FocusFilter filter = new FocusFilter();
        FilteredImageSource prod = new FilteredImageSource(((Image)image).getSource(), filter);
        return new ImageIcon(Toolkit.getDefaultToolkit().createImage(prod));
    }

    public static ImageIcon createRolloverIcon(Component comp, Icon icon) {
        return ImageUtils.createSolidColorIcon(comp, icon, NetTheme.getHoverColor());
    }

    public static Image createWhiteNoiseImage(int width, int height) {
        BufferedImage image = ImageUtils.createCompatibleTranslucentImage(width, height);
        Random random = new Random();
        int x = 0;
        while (x < image.getWidth()) {
            int y = 0;
            while (y < image.getHeight()) {
                int alpha = random.nextInt(5);
                image.setRGB(x, y, alpha <<= 24);
                ++y;
            }
            ++x;
        }
        return image;
    }

    public static BufferedImage createImage(Component component, Icon icon) {
        BufferedImage image = ImageUtils.createEmptyImage(icon.getIconWidth(), icon.getIconHeight());
        Graphics g = image.getGraphics();
        icon.paintIcon(component, g, 0, 0);
        g.dispose();
        return image;
    }

    public static BufferedImage createScaledInstance(BufferedImage img, double scaleFactor) {
        return ImageUtils.createScaledInstance(img, (int)((double)img.getWidth() * scaleFactor), (int)((double)img.getHeight() * scaleFactor), RenderingHints.VALUE_INTERPOLATION_BICUBIC, false);
    }

    public static BufferedImage createScaledInstance(BufferedImage img, int targetWidth, int targetHeight) {
        return ImageUtils.createScaledInstance(img, targetWidth, targetHeight, RenderingHints.VALUE_INTERPOLATION_BICUBIC, true);
    }

    public static BufferedImage createScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int h;
        int w;
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        if (higherQuality) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }

    public static void paintIconShadow(Graphics g, Component component, Icon icon, int x, int y) {
        ImageIcon solidColorIcon = ImageUtils.createSolidColorIcon(component, icon, ICON_SHADOW_COLOR);
        solidColorIcon.paintIcon(component, g, x - 1, y - 1);
        solidColorIcon.paintIcon(component, g, x + 1, y + 1);
        solidColorIcon.paintIcon(component, g, x - 1, y + 1);
        solidColorIcon.paintIcon(component, g, x + 1, y - 1);
        solidColorIcon.paintIcon(component, g, x + 1, y);
        solidColorIcon.paintIcon(component, g, x, y - 1);
        solidColorIcon.paintIcon(component, g, x - 1, y);
    }

    public static BufferedImage createCompatibleOpaqueImage(int width, int height) {
        return GraphicsEnvironment.isHeadless() ? new BufferedImage(width, height, 4) : ImageUtils.getGraphicsConfiguration().createCompatibleImage(width, height, 1);
    }

    public static BufferedImage createCompatibleTranslucentImage(int width, int height) {
        return GraphicsEnvironment.isHeadless() ? new BufferedImage(width, height, 4) : ImageUtils.getGraphicsConfiguration().createCompatibleImage(width, height, 3);
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static BufferedImage createComponentImage(List<JComponent> components) {
        return ImageUtils.createComponentImage(components.toArray(new JComponent[0]));
    }

    public static BufferedImage createComponentImage(JComponent ... components) {
        int width = 0;
        int height = 0;
        JComponent[] jComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            JComponent component = jComponentArray[n2];
            Dimension size = component.getSize();
            size = ((Component)component).getPreferredSize();
            height += size.height;
            width = Math.max(width, size.width);
            ++n2;
        }
        BufferedImage image = ImageUtils.createCompatibleOpaqueImage(width, height);
        Graphics2D g2d = image.createGraphics();
        int currentY = 0;
        JComponent[] jComponentArray2 = components;
        int n3 = components.length;
        int n4 = 0;
        while (n4 < n3) {
            JComponent component = jComponentArray2[n4];
            Dimension size = component.getSize();
            size = component.getPreferredSize();
            component.setSize(size);
            boolean oldOpaque = component.isOpaque();
            component.setOpaque(true);
            component.doLayout();
            g2d.translate(0, currentY);
            component.paint(g2d);
            component.paint(g2d);
            component.setOpaque(oldOpaque);
            currentY += size.height;
            ++n4;
        }
        g2d.dispose();
        return image;
    }

    public static void drawImageToShape(Graphics2D g, Image image, Shape clipShape, Point locationInImage) {
        Rectangle bounds = clipShape.getBounds();
        if (clipShape instanceof Rectangle2D) {
            g.drawImage(image, bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height, 0, locationInImage.y, 1, locationInImage.y + bounds.height, null);
        } else if (bounds.width > 0 && bounds.height > 0) {
            Rectangle bounds1 = clipShape.getBounds();
            BufferedImage tempImage = ImageUtils.getEmptyImage(bounds1.width, bounds1.height);
            Graphics2D g2 = tempImage.createGraphics();
            g2.clipRect(0, 0, bounds1.width, bounds1.height);
            g2.setComposite(AlphaComposite.Clear);
            g2.fillRect(0, 0, bounds1.width, bounds1.height);
            g2.setComposite(AlphaComposite.Src);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(Color.WHITE);
            g2.translate(-bounds1.x, -bounds1.y);
            g2.fill(clipShape);
            g2.translate(bounds1.x, bounds1.y);
            g2.setComposite(AlphaComposite.SrcAtop);
            g2.drawImage(image, 0, 0, bounds1.width, bounds1.height, 0, locationInImage.y, 1, locationInImage.y + bounds1.height, null);
            g2.dispose();
            Shape oldClip = g.getClip();
            g.clipRect(bounds1.x, bounds1.y, bounds1.width, bounds1.height);
            g.drawImage((Image)tempImage, bounds1.x, bounds1.y, null);
            g.setClip(oldClip);
        }
    }

    public static BufferedImage createVerticalGradientImage(int width, int height, Color ... colors) {
        BufferedImage image = ImageUtils.createCompatibleOpaqueImage(width, height);
        Graphics2D g2d = image.createGraphics();
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, colors[0], 0.0f, height, colors[1]));
        g2d.fillRect(0, 0, 1, height);
        g2d.dispose();
        return image;
    }

    private static BufferedImage getEmptyImage(int width, int height) {
        if (theEmptyImage == null) {
            theEmptyImage = ImageUtils.createCompatibleTranslucentImage(width, height);
        } else {
            int imageWidth = theEmptyImage.getWidth();
            int imageHeight = theEmptyImage.getHeight();
            if (width > imageWidth || height > imageHeight) {
                theEmptyImage.flush();
                theEmptyImage = ImageUtils.createCompatibleTranslucentImage(width + 30, height + 30);
            }
        }
        return theEmptyImage;
    }

    public static int[] getPixels(BufferedImage img, int x, int y, int w, int h, int[] pixels) {
        int[] tempPixels = pixels;
        if (w == 0 || h == 0) {
            return new int[0];
        }
        if (tempPixels == null) {
            tempPixels = new int[w * h];
        } else if (tempPixels.length < w * h) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            return (int[])raster.getDataElements(x, y, w, h, tempPixels);
        }
        return img.getRGB(x, y, w, h, tempPixels, 0, w);
    }

    public static void setPixels(BufferedImage img, int x, int y, int w, int h, int[] pixels) {
        if (pixels == null || w == 0 || h == 0) {
            return;
        }
        if (pixels.length < w * h) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            raster.setDataElements(x, y, w, h, pixels);
        } else {
            img.setRGB(x, y, w, h, pixels, 0, w);
        }
    }
}

