/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.util;

import java.awt.Point;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class MathUtils {
    private static final int DECIMAL_POINT_OFFSET = 1;

    private MathUtils() {
    }

    public static int line(Point point1, Point point2, int x) {
        double m = (point2.y - point1.y) / (point2.x - point1.x);
        return (int)(m * (double)(x - point1.x) + (double)point1.y);
    }

    public static double distance(Point point1, Point point2) {
        int dx = point2.x - point1.x;
        int dy = point2.y - point1.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static int getNormalizedSignificandExponent(double value) {
        int decimalPointIndex;
        int mostSignificantDigitIndex = MathUtils.getMostSignificantDigitIndex(value);
        if (mostSignificantDigitIndex > (decimalPointIndex = MathUtils.getDecimalPointIndex(value))) {
            return -1 * (mostSignificantDigitIndex - decimalPointIndex);
        }
        return decimalPointIndex - mostSignificantDigitIndex - 1;
    }

    public static int getMostSignificantDigitIndex(double value) {
        String valueString = new BigDecimal(Math.abs(value)).toPlainString();
        int i = 0;
        while (i < valueString.length()) {
            if (MathUtils.isNotZeroOrdPeriod(valueString.charAt(i))) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static double getLinearDifferenceMean(List series) {
        HashSet<Double> linearDifference = new HashSet<Double>();
        double sum = 0.0;
        int currIndex = 0;
        while (currIndex < series.size() - 1) {
            int nextIndex = currIndex + 1;
            double distance = MathUtils.getDistance(MathUtils.getDouble(series.get(nextIndex)), MathUtils.getDouble(series.get(currIndex)));
            if (!linearDifference.contains(distance)) {
                sum += distance;
                linearDifference.add(distance);
            }
            ++currIndex;
        }
        linearDifference.remove(0.0);
        return !linearDifference.isEmpty() ? sum / (double)linearDifference.size() : sum;
    }

    public static double getDistance(double data_1, double data_2) {
        return Math.abs(data_1 - data_2);
    }

    public static List<Double> raiseByPowerOfTen(int exponent, Number ... numbers) {
        ArrayList<Double> raisedNumbers = new ArrayList<Double>();
        Number[] numberArray = numbers;
        int n = numbers.length;
        int n2 = 0;
        while (n2 < n) {
            Number number = numberArray[n2];
            raisedNumbers.add(new BigDecimal(number.doubleValue()).scaleByPowerOfTen(exponent).doubleValue());
            ++n2;
        }
        return raisedNumbers;
    }

    private static boolean isNotZeroOrdPeriod(char digit) {
        return digit != '0' && digit != '.';
    }

    private static int getDecimalPointIndex(double number) {
        String valueString = new BigDecimal(Math.abs(number)).toPlainString();
        int decimalPointIndex = valueString.indexOf(46);
        return decimalPointIndex < 0 ? valueString.length() : decimalPointIndex;
    }

    private static double getDouble(Object number) {
        return ((Number)number).doubleValue();
    }
}

