/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.util;

import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;

public class PopupManager {
    private JComponent myOwner;
    private JComponent myTooltip;
    private Popup myPopup;
    private int myXOffset = 0;
    private int myYOffset = 4;
    private MouseListener myListener;
    private FocusListener myFocusListener;
    private JRootPane myRootPane;
    private ComponentListener myCompListener;

    public PopupManager(JComponent owner, JComponent tooltip) {
        this.myOwner = owner;
        this.myTooltip = tooltip;
        this.myListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                PopupManager.this.hideTooltip();
            }
        };
        this.myFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent event) {
                PopupManager.this.hideTooltip();
            }
        };
        this.myOwner.addFocusListener(this.myFocusListener);
        this.myCompListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                PopupManager.this.hideTooltip();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                PopupManager.this.hideTooltip();
            }
        };
    }

    public PopupManager(AbstractButton button, JComponent tooltip) {
        this((JComponent)button, tooltip);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (PopupManager.this.isShowing()) {
                    PopupManager.this.hideTooltip();
                } else {
                    PopupManager.this.showTooltip();
                }
            }
        });
    }

    public void showTooltip() {
        Window window;
        this.hideTooltip();
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        Point position = new Point(this.myOwner.getLocationOnScreen());
        position.translate(this.myXOffset, this.myOwner.getBounds().height + this.myYOffset);
        this.myPopup = popupFactory.getPopup(this.myOwner, this.myTooltip, position.x, position.y);
        this.myRootPane = this.myOwner.getRootPane();
        if (this.myRootPane != null && this.myRootPane.isShowing()) {
            this.myRootPane.getGlassPane().setVisible(true);
            this.myRootPane.getGlassPane().addMouseListener(this.myListener);
        }
        if ((window = SwingUtilities.getWindowAncestor(this.myOwner)) != null) {
            window.addComponentListener(this.myCompListener);
        }
        this.myPopup.show();
    }

    public void setTooltip(JComponent tooltip) {
        this.hideTooltip();
        this.myTooltip = tooltip;
    }

    public boolean isShowing() {
        return this.myPopup != null;
    }

    public void hideTooltip() {
        if (this.isShowing()) {
            Window window;
            this.myPopup.hide();
            this.myPopup = null;
            if (this.myRootPane != null && this.myRootPane.isShowing()) {
                this.myRootPane.getGlassPane().setVisible(false);
                this.myRootPane.getGlassPane().removeMouseListener(this.myListener);
                this.myRootPane.repaint();
            }
            if ((window = SwingUtilities.getWindowAncestor(this.myOwner)) != null) {
                window.removeComponentListener(this.myCompListener);
            }
        }
    }

    public void setXOffset(int xOffset) {
        this.myXOffset = xOffset;
    }

    public void setYOffset(int yOffset) {
        this.myYOffset = yOffset;
    }
}

