/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.util;

import com.nokia.laf.NetLookAndFeel;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.geom.RectangularShape;
import java.lang.reflect.Array;

public class ScaleUtils {
    public static double scale(double value) {
        return value * ScaleUtils.calcScaleFactor();
    }

    public static int scale(int value) {
        return (int)((double)value * ScaleUtils.calcScaleFactor());
    }

    public static int reverseScale(int value) {
        return (int)((double)value * ScaleUtils.calcReverseScaleFactor());
    }

    public static RectangularShape scaleSize(RectangularShape rect) {
        double scaleFactor = ScaleUtils.calcScaleFactor();
        rect.setFrame(rect.getX(), rect.getY(), rect.getWidth() * scaleFactor, rect.getHeight() * scaleFactor);
        return rect;
    }

    public static RectangularShape scale(RectangularShape rect) {
        double scaleFactor = ScaleUtils.calcScaleFactor();
        rect.setFrame(rect.getX() * scaleFactor, rect.getY() * scaleFactor, rect.getWidth() * scaleFactor, rect.getHeight() * scaleFactor);
        return rect;
    }

    public static Point scale(Point point) {
        point.x = ScaleUtils.scale(point.x);
        point.y = ScaleUtils.scale(point.y);
        return point;
    }

    public static Point newScaled(Point point) {
        return ScaleUtils.scale(new Point(point));
    }

    public static Dimension scale(Dimension dim) {
        dim.width = ScaleUtils.scale(dim.width);
        dim.height = ScaleUtils.scale(dim.height);
        return dim;
    }

    public static Dimension newScaled(Dimension dim) {
        return ScaleUtils.scale(new Dimension(dim));
    }

    public static Insets scale(Insets dim) {
        dim.top = ScaleUtils.scale(dim.top);
        dim.bottom = ScaleUtils.scale(dim.bottom);
        dim.left = ScaleUtils.scale(dim.left);
        dim.right = ScaleUtils.scale(dim.right);
        return dim;
    }

    public static Insets newScaled(Insets insets) {
        return ScaleUtils.scale(new Insets(insets.top, insets.left, insets.bottom, insets.right));
    }

    public static int[] scale(int[] ints) {
        int i = 0;
        while (i < ints.length) {
            ints[i] = ScaleUtils.scale(ints[i]);
            ++i;
        }
        return ints;
    }

    public static double[] scale(double[] doubles) {
        int i = 0;
        while (i < doubles.length) {
            doubles[i] = ScaleUtils.scale(doubles[i]);
            ++i;
        }
        return doubles;
    }

    public static int[][] scale(int[][] ints) {
        return ints;
    }

    public static double[][] scale(double[][] doubles) {
        return doubles;
    }

    public static Point[] scale(Point[] points) {
        int i = 0;
        while (i < points.length) {
            points[i] = ScaleUtils.scale(points[i]);
            ++i;
        }
        return points;
    }

    public static Dimension[] scale(Dimension[] dims) {
        int i = 0;
        while (i < dims.length) {
            dims[i] = ScaleUtils.scale(dims[i]);
            ++i;
        }
        return dims;
    }

    public static RectangularShape[] scale(RectangularShape[] rects) {
        int i = 0;
        while (i < rects.length) {
            rects[i] = ScaleUtils.scale(rects[i]);
            ++i;
        }
        return rects;
    }

    public static int[] newScaled(int[] ints) {
        return ScaleUtils.scale(ScaleUtils.copyOf(ints, ints.length));
    }

    public static double[] newScaled(double[] doubles) {
        return ScaleUtils.scale(ScaleUtils.copyOf(doubles, doubles.length));
    }

    public static int[][] newScaled(int[][] ints) {
        int[][] result = new int[ints.length][];
        int i = 0;
        while (i < ints.length) {
            result[i] = ScaleUtils.newScaled(ints[i]);
            ++i;
        }
        return result;
    }

    public static double[][] newScaled(double[][] doubles) {
        double[][] result = new double[doubles.length][];
        int i = 0;
        while (i < doubles.length) {
            result[i] = ScaleUtils.newScaled(doubles[i]);
            ++i;
        }
        return result;
    }

    public static Point[] newScaled(Point[] points) {
        Point[] result = new Point[points.length];
        int i = 0;
        while (i < points.length) {
            result[i] = ScaleUtils.newScaled(points[i]);
            ++i;
        }
        return result;
    }

    public static Dimension[] newScaled(Dimension[] dims) {
        Dimension[] result = new Dimension[dims.length];
        int i = 0;
        while (i < dims.length) {
            result[i] = ScaleUtils.newScaled(result[i]);
            ++i;
        }
        return result;
    }

    public static int[] copyOf(int[] original, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static double[] copyOf(double[] original, int newLength) {
        double[] copy = new double[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static Object[] copyOf(Object[] original, int newLength, Class<?> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static Object[] copyOf(Object[] original, int newLength) {
        return ScaleUtils.copyOf(original, newLength, original.getClass());
    }

    public static double calcScaleFactor() {
        int fontSizeIncrement = NetLookAndFeel.getFontSizeIncrement();
        if (fontSizeIncrement == 0) {
            return 1.0;
        }
        int currentSize = NetLookAndFeel.getFontSize();
        int origSize = currentSize - fontSizeIncrement;
        return (double)currentSize / (double)origSize;
    }

    public static double calcReverseScaleFactor() {
        int normalFontSize = NetLookAndFeel.getFontSize() - NetLookAndFeel.getFontSizeIncrement();
        int currentFontSize = NetLookAndFeel.getFontSize();
        return (double)normalFontSize / (double)currentFontSize;
    }
}

