/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.util;

import java.awt.EventQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class SwingWorker<V>
implements Future<V>,
Runnable {
    private Executor executor;
    private boolean started;
    private final FutureTask<V> task = new FutureTask<V>(new Callable<V>(){

        @Override
        public V call() throws Exception {
            return SwingWorker.this.construct();
        }
    }){

        @Override
        protected void done() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingWorker.this.finished();
                }
            });
        }
    };

    public SwingWorker() {
        this(Executors.newCachedThreadPool());
    }

    protected SwingWorker(Executor e) {
        this.setExecutor(e);
    }

    public synchronized void setExecutor(Executor e) {
        this.executor = e;
    }

    public synchronized Executor getExecutor() {
        return this.executor;
    }

    public synchronized void start() {
        if (!this.started) {
            this.executor.execute(this);
            this.started = true;
        }
    }

    protected abstract V construct() throws Exception;

    protected void finished() {
    }

    @Override
    public void run() {
        this.task.run();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.task.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.task.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.task.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.task.get(timeout, unit);
    }
}

