/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.util;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;

public class SystemUtils {
    private static boolean IS_AFTER_JAVA_14 = true;
    private static boolean IS_AFTER_JAVA_15 = true;
    private static boolean IS_AFTER_JAVA_16 = true;
    public static final double DEFAULT_FLOAT_POINTER_COMPARISON_NUM = 1.0E-5;

    static {
        String javaVersion = System.getProperty("java.version");
        String majorVersion = javaVersion.substring(0, 3);
        float majorFloat = 0.0f;
        try {
            majorFloat = Float.valueOf(majorVersion).floatValue();
            IS_AFTER_JAVA_14 = majorFloat > 1.45f;
            IS_AFTER_JAVA_15 = majorFloat > 1.55f;
            IS_AFTER_JAVA_16 = majorFloat > 1.65f;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public static boolean isCondensedTheme() {
        String property = System.getProperty("OrangeTouch.condensedTheme");
        if (property == null) {
            return true;
        }
        return "true".equalsIgnoreCase(property);
    }

    public static boolean isWindows() {
        try {
            String osName = System.getProperty("os.name");
            return osName == null || osName.toUpperCase().startsWith("WINDOWS");
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean isAfterJava14() {
        return IS_AFTER_JAVA_14;
    }

    public static boolean isAfterJava15() {
        return IS_AFTER_JAVA_15;
    }

    public static boolean isAfterJava16() {
        return IS_AFTER_JAVA_16;
    }

    public static int getIntSystemProperty(String propertyName, int defaultValue) {
        try {
            return Integer.valueOf(System.getProperty(propertyName, String.valueOf(defaultValue)));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static boolean canRenderText(String fontFamilyName, Locale locale) {
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        if (!Arrays.asList(fonts).contains(fontFamilyName)) {
            return false;
        }
        String displayLanguage = locale.getDisplayLanguage();
        String englishDisplayLanguage = locale.getDisplayLanguage(Locale.ENGLISH);
        if ("".equals(displayLanguage) || displayLanguage.equals(locale.getISO3Language())) {
            return false;
        }
        if (!locale.getLanguage().equals(Locale.ENGLISH.getLanguage()) && displayLanguage.equals(englishDisplayLanguage)) {
            return false;
        }
        Font testFont = new Font(fontFamilyName, 0, 12);
        return testFont.canDisplayUpTo(displayLanguage) == -1;
    }

    public static void edtCheck(String message) {
        if (!EventQueue.isDispatchThread()) {
            throw new RuntimeException(String.valueOf(message) + " not in EDT");
        }
    }

    public static boolean isEqual(double d1, double d2) {
        BigDecimal bd1 = new BigDecimal(d1);
        return bd1.equals(new BigDecimal(d2));
    }

    public static boolean isEqual(double d1, double d2, double comparisionNum) {
        return Math.abs(d1 - d2) < comparisionNum;
    }

    public static boolean openInBrowser(URL myURL) {
        boolean flag = false;
        flag = SystemUtils.openBrowserWithDesktop(myURL);
        if (!flag && !(flag = SystemUtils.openBrowserWithServiceManager(myURL))) {
            String os = System.getProperty("os.name");
            flag = os.startsWith("Windows") ? SystemUtils.openBrowserForWindows(myURL.toExternalForm()) : (os.startsWith("Mac") ? SystemUtils.openBrowserForMacOS(myURL.toExternalForm()) : SystemUtils.openBrowserForUnix(myURL.toExternalForm()));
        }
        return flag;
    }

    private static boolean openBrowserWithDesktop(URL myURL) {
        try {
            Class<?> desktop = Class.forName("java.awt.Desktop");
            desktop.getDeclaredMethod("browse", URI.class).invoke(desktop.getDeclaredMethod("getDesktop", new Class[0]).invoke(null, new Object[0]), URI.create(myURL.toString()));
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean openBrowserWithServiceManager(URL url) {
        try {
            Class<?> clazz = Class.forName("javax.jnlp.ServiceManager");
            Class[] stringClass = new Class[]{String.class};
            Method method = clazz.getMethod("lookup", stringClass);
            Object[] basicServiceClass = new Object[]{"javax.jnlp.BasicService"};
            Object obj = method.invoke(null, basicServiceClass);
            Class[] urlClass = new Class[]{URL.class};
            method = obj.getClass().getMethod("showDocument", urlClass);
            Object[] userURLClass = new Object[]{url};
            method.invoke(obj, userURLClass);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean openBrowserForUnix(String url) {
        String[] browserCmd = new String[]{"mozilla -remote openURL(" + url + ")", "mozilla " + url, "netscape -remote openURL(" + url + ")", "netscape " + url};
        boolean flag = false;
        int i = 0;
        while (i < browserCmd.length) {
            block6: {
                try {
                    Process process = Runtime.getRuntime().exec(browserCmd[i]);
                    if (process.waitFor() != 0) {
                        process = Runtime.getRuntime().exec(browserCmd[++i]);
                        process.exitValue();
                        break block6;
                    }
                    flag = true;
                    break;
                }
                catch (IOException e) {
                }
                catch (InterruptedException e) {
                }
                catch (IllegalThreadStateException e) {
                    flag = true;
                    break;
                }
            }
            i += 2;
        }
        return flag;
    }

    private static boolean openBrowserForMacOS(String url) {
        try {
            Class<?> clazz = Class.forName("com.apple.mrj.MRJFileUtils");
            Method method = clazz.getMethod("openURL", Class.forName("java.lang.String"));
            method.invoke(null, url);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static boolean openBrowserForWindows(String url) {
        String[] cmd = new String[]{"rundll32.exe", "url.dll", "FileProtocolHandler", url};
        try {
            Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean isOrangeTouch() {
        return "false".equalsIgnoreCase(System.getProperty("uitheme.OceanTouch"));
    }

    public static boolean isFocusedIconAutoCreated() {
        return "true".equalsIgnoreCase(System.getProperty("OceanTouch.autoCreateFocusedIcon", "true"));
    }

    public static boolean isDimmingSupported() {
        String property = System.getProperty("OT.dimBackgroundOfModalDialogs");
        if (property == null) {
            return true;
        }
        return "true".equalsIgnoreCase(property);
    }
}

