/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.util;

import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class WidgetResources {
    protected static final Properties theStringBundle = new Properties();
    protected static final Properties theIconBundle = new Properties();
    protected static Properties theAdditionaIconBundle;
    private static Properties theAdditionalLanguageBundle;

    static {
        try {
            InputStream sbStream = WidgetResources.class.getResourceAsStream("/com/nokia/widgets/WidgetStringBundle.properties");
            InputStream iconStream = WidgetResources.class.getResourceAsStream("/com/nokia/widgets/WidgetIconBundle.properties");
            theStringBundle.load(sbStream);
            theIconBundle.load(iconStream);
            sbStream.close();
            iconStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getString(String key) {
        if (theAdditionalLanguageBundle != null && theAdditionalLanguageBundle.getProperty(key) != null) {
            return theAdditionalLanguageBundle.getProperty(key);
        }
        String value = theStringBundle.getProperty(key);
        if (value == null) {
            value = key;
        }
        return value;
    }

    public static void setAdditionalLanguageBundle(Properties additionalLanguageBundle) {
        theAdditionalLanguageBundle = additionalLanguageBundle;
    }

    public static int getMnemonic(String key) {
        if (theAdditionalLanguageBundle != null && theAdditionalLanguageBundle.getProperty(key) != null) {
            return Character.toUpperCase(theAdditionalLanguageBundle.getProperty(key).charAt(0));
        }
        String value = theStringBundle.getProperty(key);
        if (value == null) {
            value = key;
        }
        return Character.toUpperCase(value.charAt(0));
    }

    public static ImageIcon getImageIcon(String key) {
        URL imageURL;
        String value = null;
        value = theAdditionaIconBundle != null && theAdditionaIconBundle.getProperty(key) != null ? theAdditionaIconBundle.getProperty(key) : theIconBundle.getProperty(key);
        ImageIcon resultImage = null;
        if (value != null && (imageURL = WidgetResources.class.getResource(value)) != null) {
            resultImage = new ImageIcon(imageURL);
        }
        return resultImage;
    }

    public static void setAdditionalIconBundle(Properties iconBundle) {
        theAdditionaIconBundle = iconBundle;
    }

    public static void localize(Component comp) {
        String compName = comp.getName();
        Method[] methods = comp.getClass().getMethods();
        int counter = 0;
        while (counter < methods.length) {
            Method m = methods[counter];
            if (m.getName().startsWith("set") && m.getParameterTypes().length == 1) {
                try {
                    Object value;
                    String property = m.getName().substring(3);
                    String key = String.valueOf(compName) + "_" + property;
                    if (property.endsWith("Icon")) {
                        value = WidgetResources.getImageIcon(key);
                        if (value != null) {
                            m.invoke((Object)comp, (Icon)value);
                        }
                    } else {
                        value = WidgetResources.getString(key);
                        if (!value.equals(key)) {
                            Class<?> paramType = m.getParameterTypes()[0];
                            if (paramType == String.class) {
                                m.invoke((Object)comp, value);
                            } else if (paramType == Integer.TYPE) {
                                m.invoke((Object)comp, Integer.valueOf((String)value));
                            }
                        }
                    }
                }
                catch (Exception property) {
                    // empty catch block
                }
            }
            ++counter;
        }
        if (comp instanceof Container) {
            Component[] components = ((Container)comp).getComponents();
            int counter2 = 0;
            while (counter2 < components.length) {
                Component c = components[counter2];
                WidgetResources.localize(c);
                ++counter2;
            }
        }
    }
}

