/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.validation;

public class ValidationResult {
    private int myErrorCount;
    private int myMissingValueCount;

    public static ValidationResult createDefaultErrorResult() {
        return new ValidationResult(0, 1);
    }

    public static ValidationResult createDefaultMissingValueResult() {
        return new ValidationResult(1, 0);
    }

    public static ValidationResult createOkResult() {
        return new ValidationResult(0, 0);
    }

    public ValidationResult() {
        this(0, 0);
    }

    public ValidationResult(int missingValueCount, int errorCount) {
        this.myMissingValueCount = missingValueCount;
        this.myErrorCount = errorCount;
    }

    public ValidationResult add(ValidationResult result) {
        this.addErrors(result.getErrorCount());
        this.addMissingValues(result.getMissingValueCount());
        return this;
    }

    public void addErrors(int errorCount) {
        this.myErrorCount += errorCount;
    }

    public void addMissingValues(int missingCount) {
        this.myMissingValueCount += missingCount;
    }

    public int getErrorCount() {
        return this.myErrorCount;
    }

    public int getMissingValueCount() {
        return this.myMissingValueCount;
    }

    public boolean hasErrors() {
        return this.getErrorCount() > 0;
    }

    public boolean hasMissingValues() {
        return this.getMissingValueCount() > 0;
    }

    public boolean isOk() {
        return !this.hasErrors() && !this.hasMissingValues();
    }

    public void setErrorCount(int errorCount) {
        this.myErrorCount = errorCount;
    }

    public void setMissingValueCount(int missingValueCount) {
        this.myMissingValueCount = missingValueCount;
    }
}

