/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.viewselection;

import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.PVerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class ViewSelectionBase
extends JPanel {
    public static final String SELECTION_CHANGED = "ViewSelectionList.selectionChanged";
    protected Object myCurrentSelection = null;
    protected JScrollPane myItemListScroll;
    protected JComponent myViewSelectionComponent;
    private JComponent myButtonPanel;
    private JLabel myListTitle;
    private JPanel myViewPanel = new JPanel(new BorderLayout());
    private JComponent myViewTitle;

    public ViewSelectionBase() {
        this("", "");
    }

    public ViewSelectionBase(String listTitle, String viewTitle) {
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setLayout(new GridBagLayout());
        this.myListTitle = PLabel.createTitle(listTitle);
        this.myViewTitle = this.createViewTitle();
        this.setViewTitle(viewTitle);
        this.myViewSelectionComponent = this.createSelectionList();
        this.myItemListScroll = new JScrollPane(this.myViewSelectionComponent);
        this.buildUI();
    }

    public void setViewTitleVisible(boolean visible) {
        boolean oldValue = this.getViewTitle().isVisible();
        this.getViewTitle().setVisible(visible);
        if (oldValue != visible) {
            this.revalidate();
            this.repaint();
        }
    }

    public JLabel getListTitle() {
        return this.myListTitle;
    }

    public JComponent getViewTitle() {
        return this.myViewTitle;
    }

    public JScrollPane getScrollPane() {
        return this.myItemListScroll;
    }

    public void setButtonPanel(JComponent buttonPanel) {
        this.myButtonPanel = buttonPanel;
        this.buildUI();
    }

    public void setListTitle(String listTitle) {
        this.myListTitle.setText(listTitle);
    }

    public void setListTitleDisplayedMnemonic(int mnemonic) {
        this.myListTitle.setDisplayedMnemonic(mnemonic);
        this.myListTitle.setLabelFor(this.myViewSelectionComponent);
    }

    public void setListTitleDisplayedMnemonicIndex(int index) {
        this.myListTitle.setDisplayedMnemonicIndex(index);
        this.myListTitle.setLabelFor(this.myViewSelectionComponent);
    }

    public void setListTitleVisible(boolean visible) {
        if (this.myListTitle.isVisible() == visible) {
            return;
        }
        this.myListTitle.setVisible(visible);
        this.buildUI();
    }

    public void setViewComponent(Component component) {
        if (this.myViewPanel.getComponentCount() > 0 && this.myViewPanel.getComponent(0) == component) {
            return;
        }
        this.myViewPanel.removeAll();
        this.myViewPanel.add(component);
        this.revalidate();
        this.repaint();
    }

    public void setViewTitle(String viewTitle) {
        if (this.myViewTitle instanceof JLabel) {
            ((JLabel)this.myViewTitle).setText(viewTitle);
        }
    }

    protected void buildUI() {
        this.removeAll();
        boolean listTitleVisible = this.myListTitle.isVisible();
        this.myViewTitle.setBorder(listTitleVisible ? BorderFactory.createEmptyBorder() : BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.setLayout(new BorderLayout());
        JPanel leftPanel = new JPanel(new PVerticalLayout(0));
        if (listTitleVisible) {
            leftPanel.add(this.myListTitle);
        }
        leftPanel.add(this.myItemListScroll);
        if (this.myButtonPanel != null) {
            leftPanel.add(this.myButtonPanel);
        }
        this.add((Component)leftPanel, "West");
        JPanel viewPanel = new JPanel(new PVerticalLayout(0));
        viewPanel.add(this.myViewTitle);
        viewPanel.add(this.myViewPanel);
        this.add(viewPanel);
        this.revalidate();
        this.repaint();
    }

    protected JComponent createViewTitle() {
        return PLabel.createTitle();
    }

    protected abstract JComponent createSelectionList();

    protected abstract void selectionChanged(Object var1, Object var2);
}

