/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.viewselection;

import com.nokia.widgets.viewselection.ViewItem;
import com.nokia.widgets.viewselection.ViewSelectionBase;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ViewSelectionList
extends ViewSelectionBase
implements ListSelectionListener {
    private JList myList;

    public ViewSelectionList() {
    }

    public ViewSelectionList(String listTitle, ListModel listModel) {
        this(listTitle, "", listModel, null);
    }

    public ViewSelectionList(String listTitle, String viewTitle, ListModel listModel, JComponent viewComponent) {
        super(listTitle, viewTitle);
        this.setListModel(listModel);
        if (listModel.getSize() > 0) {
            this.myList.setSelectedIndex(0);
        }
        if (viewComponent != null) {
            this.setViewComponent(viewComponent);
        }
    }

    public JList getList() {
        return this.myList;
    }

    public void setListModel(ListModel listModel) {
        this.myList.setModel(listModel);
    }

    public void setSelectedIndex(int index) {
        this.myList.setSelectedIndex(index);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            Object oldValue = this.myCurrentSelection;
            this.myCurrentSelection = this.myList.getSelectedValue();
            this.firePropertyChange("ViewSelectionList.selectionChanged", oldValue, this.myCurrentSelection);
            this.selectionChanged(oldValue, this.myCurrentSelection);
        }
    }

    @Override
    protected JComponent createSelectionList() {
        if (this.myList != null) {
            this.myList.removeListSelectionListener(this);
        }
        this.myList = new JList(new DefaultListModel());
        this.myList.setSelectionMode(0);
        this.myList.addListSelectionListener(this);
        return this.myList;
    }

    @Override
    protected void selectionChanged(Object oldselectedListItem, Object newSelectedListItem) {
        if (newSelectedListItem instanceof ViewItem) {
            ViewItem item = (ViewItem)newSelectedListItem;
            this.setViewComponent(item.getViewComponent());
            this.setViewTitle(item.getViewTitle());
        }
    }
}

