/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master;

import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.connection.BTSConnectionImpl;
import com.nokia.em.bts.rp.master.connection.SnapshotBTSConnectionImpl;
import com.nokia.em.bts.rp.master.snapshot.SnapshotManager;
import com.nokia.em.bts.rp.master.snapshot.SnapshotSaver;
import com.nokia.em.bts.rp.master.time.TimeManager;
import com.nokia.em.bts.rp.master.time.TimeManagerImpl;
import com.nokia.em.bts.rp.master.time.TimeZoneChangeListener;
import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.comm.ftp.PortRange;
import com.nokia.em.poseidon.plugin.service.Service;
import com.nokia.em.poseidon.services.certificate.CertificateService;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class RPMaster {
    public static final int SMALL = 10;
    public static final int MEDIUM = 20;
    public static final int LARGE = 50;
    public static final int UNKNOWN_INT = -1;
    public static final String UNKNOWN_STRING = "Coreasset_Unknown";
    public static final String UNAUTHORIZED_STRING = "Unauthorized";
    public static final float UNKNOWN_FLOAT = -1.0f;
    public static final long UNKNOWN_LONG = -1L;
    public static final String IF_MAJOR_VERSION = "1";
    public static final String IF_MINOR_VERSION = "0";
    public static final String AP_SITEEM_PORT = "6011";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static boolean myNeedsQueryFileTransferProtocol = true;
    private static TimeManagerImpl myTimeManager;
    private static SnapshotManager mySnapshotManager;
    private static Map<String, SnapshotSaver> mySavers;
    private static final Logger myLogger;
    private static PortRange myPortRange;

    static {
        mySavers = new HashMap<String, SnapshotSaver>();
        myLogger = Logger.getLogger(RPMaster.class);
    }

    private RPMaster() {
    }

    public static void setNeedsQueryFileTransferProtocol(boolean needs) {
        myNeedsQueryFileTransferProtocol = needs;
    }

    public static boolean getNeedsQueryFileTransferProtocol() {
        return myNeedsQueryFileTransferProtocol;
    }

    public static void initSnapshotManager(SnapshotManager manager) {
        myLogger.debug((Object)"Initting snapshotmanager.");
        mySnapshotManager = manager;
    }

    public static BTSConnection startBTSConnection() {
        return RPMaster.startBTSConnection(false);
    }

    public static BTSConnection startBTSConnection(boolean randomSeqnum) {
        if (RPMaster.isSnapshotOpening()) {
            myLogger.debug((Object)"Starting BTS Connection in snapshot open mode.");
            SnapshotBTSConnectionImpl snapshotConnection = new SnapshotBTSConnectionImpl();
            snapshotConnection.start();
            return snapshotConnection;
        }
        myLogger.debug((Object)"Starting BTS connection.");
        BTSConnectionImpl connection = (BTSConnectionImpl)PoseidonRuntime.getRuntime().getService(BTSConnectionImpl.class);
        if (connection == null) {
            connection = new BTSConnectionImpl(randomSeqnum);
            PoseidonRuntime.getRuntime().addService((Service)connection, "BTSConnection", false);
        }
        connection.start();
        return connection;
    }

    public static BTSConnection startBTSConnection(TimeZoneChangeListener listener) {
        return RPMaster.startBTSConnection(listener, false);
    }

    public static BTSConnection startBTSConnection(TimeZoneChangeListener listener, boolean randomSeqnum) {
        if (RPMaster.isSnapshotOpening()) {
            myLogger.debug((Object)"Starting BTS connection in snapshot open mode with timezone listener.");
            SnapshotBTSConnectionImpl snapshotConnection = new SnapshotBTSConnectionImpl(listener);
            snapshotConnection.start();
            return snapshotConnection;
        }
        myLogger.debug((Object)"Starting BTS connection with timezone listener.");
        BTSConnectionImpl connection = (BTSConnectionImpl)PoseidonRuntime.getRuntime().getService(BTSConnectionImpl.class);
        if (connection == null) {
            connection = new BTSConnectionImpl(listener, randomSeqnum);
            PoseidonRuntime.getRuntime().addService((Service)connection, "BTSConnection", false);
        }
        connection.addTimeZoneChangeListener(listener);
        connection.start();
        return connection;
    }

    public static TimeManager startTimeManager() {
        myLogger.debug((Object)"Starting time manager.");
        myTimeManager = new TimeManagerImpl();
        return myTimeManager;
    }

    public static TimeManager getTimeManager() {
        return myTimeManager;
    }

    public static String getVersion() {
        try {
            Package pckg = RPMaster.class.getPackage();
            String version = pckg.getImplementationVersion();
            if (version != null) {
                return version;
            }
        }
        catch (Exception e) {
            myLogger.error((Object)"Cannot get version, ", (Throwable)e);
        }
        return UNKNOWN_STRING;
    }

    public static PortRange getFTPServerPortRange() {
        return myPortRange;
    }

    public static void setFTPServerPortRange(PortRange portRange) {
        myPortRange = portRange;
    }

    public static CertificateService getPoseidonCertificateService() {
        if (PoseidonRuntime.getRuntime().getParameters().isDefined("acceptAllCerts") || PoseidonRuntime.getRuntime().getParameters().isDefined("certs")) {
            return null;
        }
        return (CertificateService)PoseidonRuntime.getRuntime().getService(CertificateService.class);
    }

    public static void addSnapshotSaver(SnapshotSaver saver) {
        if (saver != null) {
            String key = RPMaster.generateKey(saver);
            if (mySnapshotManager != null) {
                if (key.length() > 0) {
                    if (mySavers.containsKey(key)) {
                        mySnapshotManager.removeSnapshotSaver(mySavers.get(key));
                        mySavers.remove(key);
                    }
                    mySnapshotManager.addSnapshotSaver(saver);
                    mySavers.put(key, saver);
                    myLogger.debug((Object)("Added snapshot saver (" + key + ")"));
                } else {
                    myLogger.error((Object)"Cannot add snapshot saver without tasks");
                }
            } else {
                myLogger.error((Object)("Cannot add snapshot saver (" + key + ") because snapshot manager has not been set"));
            }
        } else {
            myLogger.error((Object)"Cannot add null snapshot saver");
        }
    }

    public static void removeSnapshotSaver(SnapshotSaver saver) {
        if (saver != null) {
            String key = RPMaster.generateKey(saver);
            if (mySnapshotManager != null) {
                mySnapshotManager.removeSnapshotSaver(saver);
                mySavers.remove(key);
                myLogger.debug((Object)("Removed snapshot saver (" + key + ")"));
            } else {
                myLogger.error((Object)("Cannot remove snapshot saver (" + key + ") because snapshot manager has not been set"));
            }
        } else {
            myLogger.error((Object)"Cannot remove null snapshot saver");
        }
    }

    public static void removeAllSnapshotSavers() {
        Collection<SnapshotSaver> snapshotSavers = mySavers.values();
        for (SnapshotSaver o : snapshotSavers) {
            try {
                mySnapshotManager.removeSnapshotSaver(o);
            }
            catch (Exception e) {
                myLogger.error((Object)"Error when deleting snapshot saver.", (Throwable)e);
            }
        }
        mySavers.clear();
    }

    public static boolean isSnapshotOpening() {
        if (mySnapshotManager != null) {
            return mySnapshotManager.isSnapshotOpening();
        }
        return false;
    }

    public static URL getSnapshotOpenLocation() {
        if (mySnapshotManager != null) {
            return mySnapshotManager.getSnapshotOpenLocation();
        }
        return null;
    }

    private static String generateKey(SnapshotSaver saver) {
        try {
            Collection tasks = saver.getSavingTasks(PSnapshotConst.SNAPSHOT_LEVEL.ALL_DATA);
            Iterator i = tasks.iterator();
            StringBuilder key = new StringBuilder();
            while (i.hasNext()) {
                key.append(String.valueOf(i.next().toString()) + ", ");
            }
            return key.substring(0, key.length() - 2);
        }
        catch (Exception e) {
            myLogger.error((Object)"Cannot generate key.", (Throwable)e);
            return "";
        }
    }
}

