/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.alarm;

import com.nokia.em.bts.rp.master.alarm.AlarmAdditionalInformation;
import com.nokia.em.bts.rp.master.alarm.AlarmCellularInformation;
import com.nokia.em.bts.rp.master.message.AlarmObservation;
import com.nokia.em.bts.rp.master.tool.Tools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Alarm {
    public static final int CANCEL = 1;
    public static final int SET = 2;
    public static final int TRANSIENT = 3;
    public static final int BS = 7;
    public static final int ANTMOD = 135;
    public static final int APMOD = 134;
    public static final int APANTMOD = 136;
    public static final int CELL = 8;
    public static final int CHANNEL = 9;
    public static final int ADJ = 101;
    public static final int LNADJ = 1011;
    public static final int LNADJG = 1012;
    public static final int LNADJW = 1013;
    public static final int MME = 102;
    public static final int LNMME = 1021;
    public static final int SCTP = 111;
    public static final int GTPU = 112;
    public static final int LNM3 = 133;
    public static final int A1 = 16;
    public static final int A2 = 17;
    public static final int A3 = 18;
    public static final int NOTICE = 19;
    public static final int COMMUNICATION_FAILURE = 22;
    public static final int QUALITY_OF_SERVICE = 23;
    public static final int PROCESSING_FAILURE = 24;
    public static final int EQUIPMENT_FAILURE = 25;
    public static final int ENVIRONMENT_FAILURE = 26;
    private static final String ATTACHED_DETAILS = "_attachedDetails";
    private static final int OBSERVATION_TIME_LENGTH = 19;
    private int myAlarmNumber;
    private int myAlarmActivity;
    private int myUnitIndex;
    private int mySubUnitNumber;
    private int mySeverity;
    private String myAlarmDetail;
    private AlarmAdditionalInformation myAdditionalInfo = new AlarmAdditionalInformation();
    private String myObservationTime;
    private Map<String, String> myAlarmAttributes;
    private Map<String, String> myAlarmAdditionalAttributes;
    private String myTypeOfPlugInUnit;
    private int myRackOfUnit;
    private int myShelfOfUnit;
    private int mySlotOfUnit;
    private int myEventType;
    private int myAlarmDetailNbr;
    private int myProbableCause;
    private String myObject;
    private int myReportedNumber;
    private String myArgumentInfo;
    private int myNotificationId;
    private List<AlarmCellularInformation> myCellularInformation;
    private int myUnitInformationId;
    private static final int HASHCODE_SEED = 29;
    private String myCodedMessage;
    private Map<String, String> myAttachedDetails;

    public Alarm() {
        this(-1, -1, -1, -1, -1, "Coreasset_Unknown", new AlarmAdditionalInformation(), "Coreasset_Unknown", new HashMap(), new HashMap(), "Coreasset_Unknown", -1, -1, -1, -1, -1, -1, "Coreasset_Unknown", -1, "Coreasset_Unknown", -1, new ArrayList<AlarmCellularInformation>(), -1);
    }

    public Alarm(int intSeverity, int intAlarmNumber, int intAlarmActivity, int intUnitIndex, int intSubUnitNumber, String strAlarmDetail, AlarmAdditionalInformation additionalInfos, String strObservationTime, Map alarmAttributes, Map myAlarmAdditionalAttributes, String strTypeOfPlugInUnit, int intRackOfUnit, int intShelfOfUnit, int intSlotOfUnit, int intEventType, int intAlarmDetailNbr, int probableCause, String object, int reportedNumber, String argumentInfo, int notificationId, List<AlarmCellularInformation> cellularInformation, int unitInformationId) {
        this.mySeverity = intSeverity;
        this.myAlarmNumber = intAlarmNumber;
        this.myAlarmActivity = intAlarmActivity;
        this.myUnitIndex = intUnitIndex;
        this.mySubUnitNumber = intSubUnitNumber;
        this.myAlarmDetail = strAlarmDetail;
        this.myAdditionalInfo = additionalInfos;
        this.myObservationTime = strObservationTime;
        this.myAlarmAttributes = alarmAttributes;
        this.myAlarmAdditionalAttributes = myAlarmAdditionalAttributes;
        this.myTypeOfPlugInUnit = strTypeOfPlugInUnit;
        this.myRackOfUnit = intRackOfUnit;
        this.myShelfOfUnit = intShelfOfUnit;
        this.mySlotOfUnit = intSlotOfUnit;
        this.myEventType = intEventType;
        this.myAlarmDetailNbr = intAlarmDetailNbr;
        this.myProbableCause = probableCause;
        this.myObject = object;
        this.myReportedNumber = reportedNumber;
        this.myArgumentInfo = argumentInfo;
        this.myNotificationId = notificationId;
        this.myCellularInformation = cellularInformation;
        this.myUnitInformationId = unitInformationId;
        this.myAttachedDetails = new HashMap<String, String>();
    }

    public Alarm(AlarmObservation alarmObservation) {
        this(alarmObservation.getSeverity(), alarmObservation.getAlarmNumber(), alarmObservation.getAlarmActivity(), alarmObservation.getUnitIndex(), alarmObservation.getSubUnitNumber(), alarmObservation.getAlarmDetail(), alarmObservation.getAdditionalInfo(), alarmObservation.getObservationTime(), alarmObservation.getAlarmAttributes(), alarmObservation.getAlarmAdditionalAttributes(), alarmObservation.getTypeOfPlugInUnit(), alarmObservation.getRackOfUnit(), alarmObservation.getShelfOfUnit(), alarmObservation.getSlotOfUnit(), alarmObservation.getEventType(), alarmObservation.getAlarmDetailNbr(), alarmObservation.getProbableCause(), alarmObservation.getObject(), alarmObservation.getReportedNumber(), alarmObservation.getArgumentInfo(), alarmObservation.getNotificationId(), alarmObservation.getCellularInformation(), alarmObservation.getUnitInformationId());
        this.myCodedMessage = alarmObservation.getCodedMessage();
        this.createAlarmAttachedDetails(this.myCodedMessage);
    }

    public final void setProbableCause(int cause) {
        this.myProbableCause = cause;
    }

    public final void setObject(String object) {
        this.myObject = object;
    }

    public final void setReportedNumber(int reportedNumber) {
        this.myReportedNumber = reportedNumber;
    }

    public final void setNotificationId(int notificationId) {
        this.myNotificationId = notificationId;
    }

    public final void setArgumentInfo(String argumentInfo) {
        this.myArgumentInfo = argumentInfo;
    }

    public final void setCellInformation(List<AlarmCellularInformation> cellInformation) {
        this.myCellularInformation = cellInformation;
    }

    public final void setSeverity(int intSeverity) {
        this.mySeverity = intSeverity;
    }

    public final void setAlarmNumber(int intAlarmNumber) {
        this.myAlarmNumber = intAlarmNumber;
    }

    public final void setAlarmActivity(int intAlarmActivity) {
        this.myAlarmActivity = intAlarmActivity;
    }

    public final void setUnitIndex(int intUnitIndex) {
        this.myUnitIndex = intUnitIndex;
    }

    public final void setSubUnitNumber(int intSubUnitNumber) {
        this.mySubUnitNumber = intSubUnitNumber;
    }

    public final void setAlarmDetail(String strAlarmDetail) {
        this.myAlarmDetail = strAlarmDetail;
    }

    public final void setObservationTime(String strObservationTime) {
        this.myObservationTime = strObservationTime;
    }

    public final void setAlarmAttribute(String attributeName, String attributeValue) {
        this.myAlarmAttributes.put(attributeName, attributeValue);
    }

    public final void setAlarmAdditionalAttribute(String attributeName, String attributeValue) {
        this.myAlarmAdditionalAttributes.put(attributeName, attributeValue);
    }

    public final void setTypeOfPlugInUnit(String strTypeOfPlugInUnit) {
        this.myTypeOfPlugInUnit = strTypeOfPlugInUnit;
    }

    public final void setRackOfUnit(int intRackOfUnit) {
        this.myRackOfUnit = intRackOfUnit;
    }

    public final void setShelfOfUnit(int intShelfOfUnit) {
        this.myShelfOfUnit = intShelfOfUnit;
    }

    public final void setSlotOfUnit(int intSlotOfUnit) {
        this.mySlotOfUnit = intSlotOfUnit;
    }

    public final void setUnitInformationId(int unitInformationId) {
        this.myUnitInformationId = unitInformationId;
    }

    public final void setEventType(int intEventType) {
        this.myEventType = intEventType;
    }

    public final void setAlarmDetailNbr(int intAlarmDetailNbr) {
        this.myAlarmDetailNbr = intAlarmDetailNbr;
    }

    public final int getProbableCause() {
        return this.myProbableCause;
    }

    public final String getObject() {
        return this.myObject;
    }

    public final int getReportedNumber() {
        return this.myReportedNumber;
    }

    public final String getArgumentInfo() {
        return this.myArgumentInfo;
    }

    public final int getNotificationId() {
        return this.myNotificationId;
    }

    public final List<AlarmCellularInformation> getCellularInformation() {
        return this.myCellularInformation;
    }

    public final int getSeverity() {
        return this.mySeverity;
    }

    public final int getAlarmNumber() {
        return this.myAlarmNumber;
    }

    public final int getAlarmActivity() {
        return this.myAlarmActivity;
    }

    public final int getUnitIndex() {
        return this.myUnitIndex;
    }

    public final int getSubUnitNumber() {
        return this.mySubUnitNumber;
    }

    public final String getAlarmDetail() {
        return this.myAlarmDetail;
    }

    public final AlarmAdditionalInformation getAdditionalInfo() {
        return this.myAdditionalInfo;
    }

    public final String getObservationTime() {
        return this.myObservationTime;
    }

    public boolean isObservationTimeExtended() {
        return this.myObservationTime != null && this.myObservationTime.length() > 19;
    }

    public final String getAlarmAttribute(String attributeName) {
        return this.myAlarmAttributes.get(attributeName);
    }

    public final String getAlarmAdditionalAttribute(String attributeName) {
        return this.myAlarmAdditionalAttributes.get(attributeName);
    }

    public final Map<String, String> getAllAdditionalAttributes() {
        return this.myAlarmAdditionalAttributes;
    }

    public final String getTypeOfPlugInUnit() {
        return this.myTypeOfPlugInUnit;
    }

    public final int getRackOfUnit() {
        return this.myRackOfUnit;
    }

    public final int getShelfOfUnit() {
        return this.myShelfOfUnit;
    }

    public final int getSlotOfUnit() {
        return this.mySlotOfUnit;
    }

    public final int getUnitInformationId() {
        return this.myUnitInformationId;
    }

    public final int getEventType() {
        return this.myEventType;
    }

    public final int getAlarmDetailNbr() {
        return this.myAlarmDetailNbr;
    }

    public void addAttachedDetail(String key, String value) {
        this.myAttachedDetails.put(key, value);
    }

    public String getAttachedDetail(String key) {
        return this.myAttachedDetails.get(key);
    }

    public final String getCodedMessage() {
        Element alarmNode = Tools.parseElementFromString(this.myCodedMessage);
        Document alarmDoc = alarmNode.getOwnerDocument();
        NodeList detailsNodes = alarmNode.getElementsByTagName(ATTACHED_DETAILS);
        Node attachedDetailsNode = null;
        if (detailsNodes == null || detailsNodes.getLength() == 0) {
            attachedDetailsNode = alarmDoc.createElement(ATTACHED_DETAILS);
            alarmNode.appendChild(attachedDetailsNode);
        } else {
            attachedDetailsNode = detailsNodes.item(0);
        }
        for (String key : this.myAttachedDetails.keySet()) {
            String value = this.myAttachedDetails.get(key);
            NodeList elements = alarmDoc.getElementsByTagName(key);
            Node alarmDetail = null;
            alarmDetail = elements.getLength() == 0 ? alarmDoc.createElement(key) : elements.item(0);
            if (alarmDetail.hasChildNodes()) {
                alarmDetail.removeChild(alarmDetail.getFirstChild());
            }
            alarmDetail.appendChild(alarmDoc.createTextNode(value));
            attachedDetailsNode.appendChild(alarmDetail);
        }
        return Tools.xmlToString(alarmNode);
    }

    private void createAlarmAttachedDetails(String nodeString) {
        Element alarmNode = Tools.parseElementFromString(nodeString);
        NodeList detailsNodes = alarmNode.getElementsByTagName(ATTACHED_DETAILS);
        if (detailsNodes == null || detailsNodes.getLength() == 0) {
            return;
        }
        NodeList detailNodes = detailsNodes.item(0).getChildNodes();
        int i = 0;
        while (i < detailNodes.getLength()) {
            Node detailNode = detailNodes.item(i);
            String key = detailNode.getNodeName();
            String value = detailNode.getFirstChild().getNodeValue().trim();
            this.addAttachedDetail(key, value);
            ++i;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Alarm)) {
            return false;
        }
        Alarm alarm = (Alarm)o;
        if (this.myAlarmActivity != alarm.myAlarmActivity) {
            return false;
        }
        if (this.myProbableCause != alarm.myProbableCause) {
            return false;
        }
        if (this.myObject != null && !this.myObject.equals(alarm.myObject)) {
            return false;
        }
        if (this.myReportedNumber != alarm.myReportedNumber) {
            return false;
        }
        if (this.myArgumentInfo != null && !this.myArgumentInfo.equals(alarm.myArgumentInfo)) {
            return false;
        }
        if (this.myNotificationId != alarm.myNotificationId) {
            return false;
        }
        if (this.myAlarmNumber != alarm.myAlarmNumber) {
            return false;
        }
        if (this.myEventType != alarm.myEventType) {
            return false;
        }
        if (this.myRackOfUnit != alarm.myRackOfUnit) {
            return false;
        }
        if (this.mySeverity != alarm.mySeverity) {
            return false;
        }
        if (this.myShelfOfUnit != alarm.myShelfOfUnit) {
            return false;
        }
        if (this.mySlotOfUnit != alarm.mySlotOfUnit) {
            return false;
        }
        if (this.myUnitIndex != alarm.myUnitIndex) {
            return false;
        }
        if (this.myUnitInformationId != alarm.myUnitInformationId) {
            return false;
        }
        if (this.mySubUnitNumber != alarm.mySubUnitNumber) {
            return false;
        }
        if (this.myAlarmDetail != null && !this.myAlarmDetail.equals(alarm.myAlarmDetail)) {
            return false;
        }
        if (this.myAlarmDetail == null && alarm.myAlarmDetail != null) {
            return false;
        }
        if (this.myObservationTime != null && !this.myObservationTime.equals(alarm.myObservationTime)) {
            return false;
        }
        if (this.myObservationTime == null && alarm.myObservationTime != null) {
            return false;
        }
        if (this.myAlarmAttributes != null && !this.myAlarmAttributes.equals(alarm.myAlarmAttributes)) {
            return false;
        }
        if (this.myAlarmAttributes == null && alarm.myAlarmAttributes != null) {
            return false;
        }
        if (this.myAlarmAdditionalAttributes != null && !this.myAlarmAdditionalAttributes.equals(alarm.myAlarmAdditionalAttributes)) {
            return false;
        }
        if (this.myAlarmAdditionalAttributes == null && alarm.myAlarmAdditionalAttributes != null) {
            return false;
        }
        if (this.myTypeOfPlugInUnit != null && !this.myTypeOfPlugInUnit.equals(alarm.myTypeOfPlugInUnit)) {
            return false;
        }
        if (this.myTypeOfPlugInUnit == null && alarm.myTypeOfPlugInUnit != null) {
            return false;
        }
        if (this.myAlarmDetailNbr != alarm.myAlarmDetailNbr) {
            return false;
        }
        if (this.myCellularInformation != null && alarm.myCellularInformation != null) {
            if (this.myCellularInformation.size() != alarm.myCellularInformation.size()) {
                return false;
            }
            int i = 0;
            while (i < this.myCellularInformation.size()) {
                AlarmCellularInformation cell_1 = this.myCellularInformation.get(i);
                AlarmCellularInformation cell_2 = alarm.myCellularInformation.get(i);
                if (cell_1 != null && cell_2 != null) {
                    if (cell_1.getIndex() != cell_2.getIndex()) {
                        return false;
                    }
                    if (cell_1.getType() != cell_2.getType()) {
                        return false;
                    }
                    if (cell_1.getLcrId() != cell_2.getLcrId()) {
                        return false;
                    }
                } else if (cell_1 == null || cell_2 == null) {
                    return false;
                }
                ++i;
            }
        }
        if (this.myCellularInformation == null && alarm.myCellularInformation != null) {
            return false;
        }
        if (this.myCellularInformation != null && alarm.myCellularInformation == null) {
            return false;
        }
        if (!this.myAdditionalInfo.getSourceIPAddr().equals(alarm.getAdditionalInfo().getSourceIPAddr())) {
            return false;
        }
        if (!this.myAdditionalInfo.getDestinationIPAddr().equals(alarm.getAdditionalInfo().getDestinationIPAddr())) {
            return false;
        }
        return this.myAdditionalInfo.getFeatureCode().equals(alarm.getAdditionalInfo().getFeatureCode());
    }

    public int hashCode() {
        int result = this.myAlarmNumber;
        result = 29 * result + this.myAlarmActivity;
        result = 29 * result + this.myUnitIndex;
        result = 29 * result + this.mySubUnitNumber;
        result = 29 * result + this.mySeverity;
        result = 29 * result + this.myAlarmDetailNbr;
        result = 29 * result + this.myProbableCause;
        result = 29 * result + this.myReportedNumber;
        result = 29 * result + this.myNotificationId;
        result = this.myObject != null ? 29 * result + this.myObject.hashCode() : (result *= 29);
        result = this.myArgumentInfo != null ? 29 * result + this.myArgumentInfo.hashCode() : (result *= 29);
        result = this.myAlarmDetail != null ? 29 * result + this.myAlarmDetail.hashCode() : (result *= 29);
        result = this.myObservationTime != null ? 29 * result + this.myObservationTime.hashCode() : (result *= 29);
        result = this.myAlarmAttributes != null ? 29 * result + this.myAlarmAttributes.hashCode() : (result *= 29);
        result = this.myAlarmAdditionalAttributes != null ? 29 * result + this.myAlarmAdditionalAttributes.hashCode() : (result *= 29);
        if (this.myTypeOfPlugInUnit != null) {
            result = 29 * result + this.myTypeOfPlugInUnit.hashCode();
        }
        result = this.myCellularInformation != null ? 29 * result + this.myCellularInformation.hashCode() : (result *= 29);
        result = 29 * result + this.myRackOfUnit;
        result = 29 * result + this.myShelfOfUnit;
        result = 29 * result + this.mySlotOfUnit;
        result = 29 * result + this.myEventType;
        result = 29 * result + this.myUnitInformationId;
        result = 29 * result + this.myAdditionalInfo.getSourceIPAddr().hashCode();
        result = 29 * result + this.myAdditionalInfo.getDestinationIPAddr().hashCode();
        result = 29 * result + this.myAdditionalInfo.getFeatureCode().hashCode();
        return result;
    }
}

