/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.alarm;

import com.nokia.em.bts.rp.master.RPMaster;
import com.nokia.em.bts.rp.master.alarm.Alarm;
import com.nokia.em.bts.rp.master.alarm.AlarmControlListener;
import com.nokia.em.bts.rp.master.alarm.AlarmManager;
import com.nokia.em.bts.rp.master.alarm.AlarmNotifListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.connection.BTSNotificationListener;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.AlarmObservation;
import com.nokia.em.bts.rp.master.message.AlarmStatusReply;
import com.nokia.em.bts.rp.master.message.AlarmStatusRequest;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.snapshot.SaverProgressListener;
import com.nokia.em.bts.rp.master.snapshot.SnapshotSaver;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.bts.rp.master.tool.Tools;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AlarmManagerImpl
implements AlarmManager,
BTSNotificationListener,
SnapshotSaver {
    private static final String ALARM_MANAGER = "Alarm Manager";
    private Vector<Alarm> vecAlarms;
    private Vector<AlarmNotifListener> vecAlarmListeners;
    private BTSConnection myBtsConnection;
    private Logger myLogger;
    private static final String SNAPSHOT_TASK = "Alarms";
    private static final String SNAPSHOT_TASK_NAME = "CoreAsset_Snapshot_Alarms";
    private static final int SNAPSHOT_TIMEOUT = 10000;
    private static final int STATUS_REPLY_TIMEOUT = 15000;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;
    private static final int STATUS_REQUEST_TIMEOUT = 30000;

    public AlarmManagerImpl(BTSConnection btsConnection) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.vecAlarmListeners = new Vector(20);
        this.vecAlarms = new Vector(20);
        this.myBtsConnection = btsConnection;
        this.myBtsConnection.subscribeNotification(this);
        RPMaster.addSnapshotSaver(this);
    }

    public AlarmManagerImpl(BTSConnection btsConnection, BTSMessage.Type type) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.vecAlarmListeners = new Vector(20);
        this.vecAlarms = new Vector(20);
        this.myBtsConnection = btsConnection;
        this.myType = type;
        this.myBtsConnection.subscribeNotification(this);
        RPMaster.addSnapshotSaver(this);
    }

    public AlarmManagerImpl() {
        this.vecAlarmListeners = new Vector(20);
        this.vecAlarms = new Vector(20);
        RPMaster.addSnapshotSaver(this);
    }

    private Boolean doRequestActiveAlarms() {
        int seqNbr = this.myBtsConnection.createScenario();
        AlarmStatusRequest alarmStatusRequest = new AlarmStatusRequest(seqNbr, this.myType);
        this.clearSessionAlarmHistory();
        this.myBtsConnection.sendToBTS(alarmStatusRequest);
        BTSMessage response = this.myBtsConnection.receiveFromBTS(seqNbr);
        this.myBtsConnection.deleteScenario(seqNbr);
        if (response instanceof Ack) {
            Ack ackResponse = (Ack)response;
            return ackResponse.getAck();
        }
        this.myLogger.debug((Object)("Wrong reply received from BTS. Ack expected, " + (response == null ? null : response.getClass()) + " received."));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendAlarmNotif(Alarm alarm) {
        Vector vecAlarmLis;
        AlarmManagerImpl alarmManagerImpl = this;
        synchronized (alarmManagerImpl) {
            vecAlarmLis = (Vector)this.vecAlarmListeners.clone();
        }
        int size = vecAlarmLis.size();
        if (size == 0) {
            return false;
        }
        int i = 0;
        while (i < size) {
            AlarmNotifListener alarmListener = (AlarmNotifListener)vecAlarmLis.elementAt(i);
            alarmListener.alarmNotifReceived(alarm);
            ++i;
        }
        return true;
    }

    private void addAlarm(Alarm alarm) {
        this.vecAlarms.addElement(alarm);
    }

    private String getData() {
        StringBuilder sb = new StringBuilder("<Alarms>");
        Vector<Alarm> alarms = this.getAlarms();
        int i = 0;
        while (i < alarms.size()) {
            Alarm a = alarms.get(i);
            sb.append(a.getCodedMessage());
            ++i;
        }
        sb.append("</Alarms>");
        return sb.toString();
    }

    private void openSnapshotAlarms() {
        String alarmFile = String.valueOf(RPMaster.getSnapshotOpenLocation().getFile()) + RPMaster.FILE_SEPARATOR + SNAPSHOT_TASK + RPMaster.FILE_SEPARATOR + SNAPSHOT_TASK + ".xml";
        Element root = Tools.parseElement(alarmFile);
        if (root == null) {
            this.myLogger.error((Object)"Cannot parse alarm snapshot.");
            return;
        }
        NodeList dataNodeList = root.getElementsByTagName("AlarmObservation");
        int i = 0;
        while (i < dataNodeList.getLength()) {
            try {
                AlarmObservation alarmObservation = new AlarmObservation(0, dataNodeList.item(i));
                this.btsNotificationReceived(alarmObservation);
            }
            catch (Exception e) {
                this.myLogger.error((Object)"Cannot send alarm snapshot.", (Throwable)e);
            }
            ++i;
        }
    }

    @Override
    public void requestActiveAlarms(final AlarmControlListener alarmControlListener) {
        if (this.myBtsConnection == null) {
            throw new UnsupportedOperationException();
        }
        CoreAssetThread worker = new CoreAssetThread(){

            @Override
            protected Object construct() {
                if (RPMaster.isSnapshotOpening()) {
                    alarmControlListener.activeAlarmsRequested();
                    AlarmManagerImpl.this.openSnapshotAlarms();
                    return false;
                }
                int seqNbr = AlarmManagerImpl.this.myBtsConnection.createScenario();
                AlarmStatusRequest alarmStatusRequest = new AlarmStatusRequest(seqNbr, AlarmManagerImpl.this.myType);
                AlarmManagerImpl.this.clearSessionAlarmHistory();
                AlarmManagerImpl.this.myBtsConnection.sendToBTS(alarmStatusRequest);
                BTSMessage response = AlarmManagerImpl.this.myBtsConnection.receiveFromBTS(seqNbr, 30000L);
                if (response instanceof Ack) {
                    Ack ackResponse = (Ack)response;
                    if (ackResponse.getAck()) {
                        alarmControlListener.activeAlarmsRequested();
                        response = AlarmManagerImpl.this.myBtsConnection.receiveFromBTS(seqNbr, 15000L);
                        AlarmManagerImpl.this.myBtsConnection.deleteScenario(seqNbr);
                        if (response instanceof AlarmStatusReply) {
                            AlarmStatusReply reply = (AlarmStatusReply)response;
                            alarmControlListener.alarmStatusReplyReceived(reply.getFailReason());
                            return true;
                        }
                        if (response instanceof Timeout) {
                            alarmControlListener.activeAlarmsRequestFailed(68);
                            AlarmManagerImpl.this.myLogger.debug((Object)"Timeout reached for AlarmStatusReply.");
                            return false;
                        }
                        alarmControlListener.activeAlarmsRequestFailed(28);
                        AlarmManagerImpl.this.myLogger.debug((Object)("Wrong reply received from BTS. AlarmStatusReply expected, " + (response == null ? null : response.getClass()) + " received."));
                        return false;
                    }
                    alarmControlListener.activeAlarmsRequestFailed(ackResponse.getNackReason());
                    return false;
                }
                alarmControlListener.activeAlarmsRequestFailed(28);
                AlarmManagerImpl.this.myLogger.debug((Object)("Wrong reply received from BTS. Ack expected, " + (response == null ? null : response.getClass()) + " received."));
                AlarmManagerImpl.this.myBtsConnection.deleteScenario(seqNbr);
                return false;
            }
        };
        worker.start();
    }

    @Override
    public void requestActiveAlarms() {
        if (this.myBtsConnection == null) {
            throw new UnsupportedOperationException();
        }
        CoreAssetThread worker = new CoreAssetThread(){

            @Override
            protected Object construct() {
                if (RPMaster.isSnapshotOpening()) {
                    AlarmManagerImpl.this.openSnapshotAlarms();
                    return true;
                }
                return AlarmManagerImpl.this.doRequestActiveAlarms();
            }
        };
        worker.start();
    }

    @Override
    public void btsNotificationReceived(BTSMessage btsMessage) {
        if (btsMessage instanceof AlarmObservation) {
            Alarm alarm = new Alarm((AlarmObservation)btsMessage);
            this.addAlarm(alarm);
            this.sendAlarmNotif(alarm);
        }
    }

    @Override
    public void addAlarmListener(AlarmNotifListener alarmListener) {
        if (this.vecAlarmListeners.contains(alarmListener)) {
            return;
        }
        this.vecAlarmListeners.addElement(alarmListener);
    }

    @Override
    public void removeAlarmListener(AlarmNotifListener alarmListener) {
        this.vecAlarmListeners.removeElement(alarmListener);
    }

    @Override
    public Vector<Alarm> getAlarms() {
        return this.vecAlarms;
    }

    @Override
    public Vector getDiagnosticReport(int intUnitIndex) {
        return null;
    }

    @Override
    public synchronized void clearSessionAlarmHistory() {
        this.vecAlarms.clear();
    }

    @Override
    public Collection getSavingTasks(PSnapshotConst.SNAPSHOT_LEVEL level) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(SNAPSHOT_TASK_NAME);
        return l;
    }

    @Override
    public boolean isLocalisationRequired() {
        return true;
    }

    @Override
    public void save(final String url, PSnapshotConst.SNAPSHOT_LEVEL level, final SaverProgressListener sp) {
        CoreAssetThread worker = new CoreAssetThread(){

            @Override
            protected Object construct() {
                AlarmManagerImpl.this.runSave(url, sp);
                return null;
            }
        };
        worker.start();
    }

    private void runSave(String url, SaverProgressListener sp) {
        block15: {
            OutputStreamWriter out = null;
            try {
                try {
                    sp.taskStarted(SNAPSHOT_TASK_NAME, 7, 10000, this.isLocalisationRequired());
                    File dir = new File(String.valueOf(url) + RPMaster.FILE_SEPARATOR + SNAPSHOT_TASK);
                    if (!dir.mkdir()) {
                        this.myLogger.warn((Object)"Folder for Alarm Manager snapshot was not successfully created.");
                    }
                    File f = new File(String.valueOf(url) + RPMaster.FILE_SEPARATOR + SNAPSHOT_TASK + RPMaster.FILE_SEPARATOR + SNAPSHOT_TASK + ".xml");
                    out = new OutputStreamWriter(new FileOutputStream(f, false));
                    out.write(this.getData());
                }
                catch (Exception e) {
                    sp.taskUpdated(SNAPSHOT_TASK_NAME, 4, this.isLocalisationRequired());
                    this.myLogger.error((Object)"Failed to save Alarm Manager snapshot information", (Throwable)e);
                    if (out != null) {
                        try {
                            out.close();
                            sp.taskUpdated(SNAPSHOT_TASK_NAME, 8, this.isLocalisationRequired());
                            this.myLogger.debug((Object)"Alarm Manager snapshot file successfully created");
                        }
                        catch (Exception e2) {
                            sp.taskUpdated(SNAPSHOT_TASK_NAME, 4, this.isLocalisationRequired());
                            this.myLogger.error((Object)"Failed to close Alarm Manager snapshot file", (Throwable)e2);
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                        sp.taskUpdated(SNAPSHOT_TASK_NAME, 8, this.isLocalisationRequired());
                        this.myLogger.debug((Object)"Alarm Manager snapshot file successfully created");
                    }
                    catch (Exception e) {
                        sp.taskUpdated(SNAPSHOT_TASK_NAME, 4, this.isLocalisationRequired());
                        this.myLogger.error((Object)"Failed to close Alarm Manager snapshot file", (Throwable)e);
                    }
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                    sp.taskUpdated(SNAPSHOT_TASK_NAME, 8, this.isLocalisationRequired());
                    this.myLogger.debug((Object)"Alarm Manager snapshot file successfully created");
                }
                catch (Exception e) {
                    sp.taskUpdated(SNAPSHOT_TASK_NAME, 4, this.isLocalisationRequired());
                    this.myLogger.error((Object)"Failed to close Alarm Manager snapshot file", (Throwable)e);
                }
            }
        }
        sp.saveCompleted(this);
    }

    @Override
    public void cancel(SaverProgressListener sp) {
        sp.saveCancelled(this);
    }

    @Override
    public int getSavingPriority() {
        return 2;
    }

    @Override
    public void stopProcess(int process) {
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

