/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.connection;

import com.nokia.em.bts.rp.master.RPMaster;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.connection.BTSMessageCreator;
import com.nokia.em.bts.rp.master.connection.BTSNotification;
import com.nokia.em.bts.rp.master.connection.BTSNotificationListener;
import com.nokia.em.bts.rp.master.connection.BTSReceiver;
import com.nokia.em.bts.rp.master.connection.BTSScenario;
import com.nokia.em.bts.rp.master.connection.BTSScenarioManagerImpl;
import com.nokia.em.bts.rp.master.connection.BTSURLConnection;
import com.nokia.em.bts.rp.master.connection.ConnectionInfoListener;
import com.nokia.em.bts.rp.master.connection.HandShakeInformation;
import com.nokia.em.bts.rp.master.connection.HandShakeListener;
import com.nokia.em.bts.rp.master.connection.HttpContent;
import com.nokia.em.bts.rp.master.connection.HttpListener;
import com.nokia.em.bts.rp.master.connection.MessageFactory;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferFactory;
import com.nokia.em.bts.rp.master.filetransfer.TempFileStore;
import com.nokia.em.bts.rp.master.filter.BTSMessageFilter;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Disconnect;
import com.nokia.em.bts.rp.master.message.FileTransferProtocolRequest;
import com.nokia.em.bts.rp.master.message.FileTransferProtocolResponse;
import com.nokia.em.bts.rp.master.message.LoginRequest;
import com.nokia.em.bts.rp.master.message.RPMessageFactory;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.snapshot.SaverProgressListener;
import com.nokia.em.bts.rp.master.snapshot.SnapshotSaver;
import com.nokia.em.bts.rp.master.time.TimeZoneChangeListener;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.plugin.service.Service;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import com.nokia.em.poseidon.util.timer.TimerService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BTSConnectionImpl
implements BTSConnection,
SnapshotSaver,
Service {
    private static final String LINE_SEPARATOR = "line.separator";
    private Vector<HandShakeListener> myHandShakeListeners;
    private BTSNotification myBtsNotification = null;
    private BTSURLConnection myBtsURLConnection = null;
    private BTSScenarioManagerImpl myBtsScenarioManagerImpl = null;
    private BTSReceiver myBtsReceiver = null;
    private String myServerName = null;
    private int myServerPort = 0;
    private boolean myConnected = false;
    private int myBTSId = -1;
    private int mySessionId = -1;
    private final Vector<ConnectionInfoListener> myConnectionInfoListeners = new Vector();
    private static final int RECONNECTION_INTERVAL = 5000;
    public static final int PROTOCOL_TIMEOUT = 30000;
    private BTSMessageCreator myBTSMessageCreator;
    private long myTimeOffset;
    private long myTimeDiff1900Century;
    private boolean myTimeOffsetSet;
    private TimeZoneChangeListener myTimeListener;
    protected static final String SNAPSHOT_TASK = "Time";
    private static final String SNAPSHOT_TASK_NAME = "CoreAsset_Snapshot_Time";
    private static final int SNAPSHOT_TIMEOUT = 10000;
    private TimeReceiver btsOffsetlistener = new TimeReceiver();
    private Logger myLogger = Logger.getLogger(this.getClass());
    private boolean myAuthEnableBlocked = false;
    private FileTransferFactory myFileTransferFactory = new FileTransferFactory();
    private boolean reConnect = true;
    private boolean ntpTimeExpected = true;
    private List<MessageFactory> messageFactorys;
    private boolean myWriteAccess = true;
    private boolean myRandomSeqnum;
    private List<BTSMessageFilter> myFilters;

    public BTSConnectionImpl() {
        this(false);
    }

    public BTSConnectionImpl(TimeZoneChangeListener listener) {
        this(false);
        this.myTimeListener = listener;
    }

    public BTSConnectionImpl(boolean randomSeqnum) {
        this.myRandomSeqnum = randomSeqnum;
        this.messageFactorys = new ArrayList<MessageFactory>();
        this.addMessageFactory(new RPMessageFactory());
        this.myFilters = new ArrayList<BTSMessageFilter>();
        this.initFilters();
    }

    public BTSConnectionImpl(TimeZoneChangeListener listener, boolean randomSeqnum) {
        this(randomSeqnum);
        this.myTimeListener = listener;
    }

    @Override
    public int getBTSId() {
        return this.myBTSId;
    }

    @Override
    public int getSessionId() {
        return this.mySessionId;
    }

    private void checkAuthEnableBlock(BTSMessage message) {
        if (!this.myAuthEnableBlocked) {
            return;
        }
        if (message instanceof LoginRequest) {
            return;
        }
        this.myLogger.debug((Object)(String.valueOf(this.myServerName) + " Message send in hold, seq: " + message.getSeqNbr()));
        while (this.myAuthEnableBlocked) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.myLogger.debug((Object)(String.valueOf(this.myServerName) + " Sleep interrupted."));
            }
        }
        this.myLogger.debug((Object)(String.valueOf(this.myServerName) + " Message send hold released, seq: " + message.getSeqNbr()));
    }

    private void initFilters() {
        for (BTSMessageFilter filter : PoseidonRuntime.getRuntime().getObjects(BTSMessageFilter.class)) {
            this.myFilters.add(filter);
        }
    }

    private boolean isAfter2005(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1) >= 2005;
    }

    private void setBTSTimeOffset() {
        long lTimeDiff = 0L;
        boolean success = false;
        try {
            long sendTime = System.currentTimeMillis();
            long btsTime = this.btsOffsetlistener.getTime();
            lTimeDiff = btsTime - sendTime;
            success = true;
        }
        catch (Exception e) {
            this.myLogger.debug((Object)(String.valueOf(this.myServerName) + " Failed to set time offset"), (Throwable)e);
        }
        if (!success) {
            if (this.myTimeListener != null) {
                this.myTimeListener.timeOffsetResolveFailed();
            }
            return;
        }
        this.myTimeOffsetSet = true;
        this.myTimeOffset = lTimeDiff;
        if (this.myTimeListener != null) {
            this.myTimeListener.timeOffsetResolved(this.myTimeOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBTSDisconnected() {
        Vector vecListeners;
        this.myConnected = false;
        BTSConnectionImpl bTSConnectionImpl = this;
        synchronized (bTSConnectionImpl) {
            vecListeners = (Vector)this.myConnectionInfoListeners.clone();
        }
        this.myLogger.debug((Object)(String.valueOf(this.myServerName) + " BTSDisconnected, sending notify to " + vecListeners.size() + " listeners"));
        int size = vecListeners.size();
        int i = 0;
        while (i < size) {
            ConnectionInfoListener connectionListener = (ConnectionInfoListener)vecListeners.elementAt(i);
            connectionListener.btsDisconnected();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBTSConnectionRefused(String strActiveHost) {
        Vector vecListeners;
        BTSConnectionImpl bTSConnectionImpl = this;
        synchronized (bTSConnectionImpl) {
            vecListeners = (Vector)this.myConnectionInfoListeners.clone();
        }
        int size = vecListeners.size();
        int i = 0;
        while (i < size) {
            ConnectionInfoListener connectionListener = (ConnectionInfoListener)vecListeners.elementAt(i);
            connectionListener.btsConnectionRefused(strActiveHost);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btsSertificateRejected() {
        Vector vecListeners;
        BTSConnectionImpl bTSConnectionImpl = this;
        synchronized (bTSConnectionImpl) {
            vecListeners = (Vector)this.myConnectionInfoListeners.clone();
        }
        int size = vecListeners.size();
        int i = 0;
        while (i < size) {
            ConnectionInfoListener connectionListener = (ConnectionInfoListener)vecListeners.elementAt(i);
            connectionListener.btsCertificateRejected();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBTSConnected() {
        Vector vecListeners;
        BTSConnectionImpl bTSConnectionImpl = this;
        synchronized (bTSConnectionImpl) {
            vecListeners = (Vector)this.myConnectionInfoListeners.clone();
        }
        int size = vecListeners.size();
        int i = 0;
        while (i < size) {
            ConnectionInfoListener connectionListener = (ConnectionInfoListener)vecListeners.elementAt(i);
            connectionListener.btsConnected();
            ++i;
        }
    }

    private void sendHandShakeInformation(HandShakeInformation information) {
        int intOMMajorVersion = -1;
        int intEMMajorVersion = -1;
        int intOMMinorVersion = -1;
        int intEMMinorVersion = -1;
        int intReason = -1;
        try {
            intOMMajorVersion = Integer.parseInt(information.getInterfaceMajorVersion());
            intEMMajorVersion = Integer.parseInt("1");
            intOMMinorVersion = Integer.parseInt(information.getInterfaceMinorVersion());
            intEMMinorVersion = Integer.parseInt("0");
        }
        catch (NumberFormatException nfe) {
            intReason = 1;
        }
        int i = 0;
        while (i < this.myHandShakeListeners.size()) {
            HandShakeListener someListener = this.myHandShakeListeners.elementAt(i);
            if (!information.isInterfaceKnown()) {
                someListener.interfaceUnknown(2);
            } else if (intReason == 1) {
                someListener.interfaceUnknown(1);
            } else if (intOMMinorVersion != intEMMinorVersion) {
                if (intOMMajorVersion != intEMMajorVersion) {
                    someListener.interfaceMajorVersionMismatch(intOMMajorVersion, intEMMajorVersion);
                } else {
                    someListener.interfaceMinorVersionMismatch(intOMMinorVersion, intEMMinorVersion);
                }
            } else if (intOMMajorVersion != intEMMajorVersion) {
                someListener.interfaceMajorVersionMismatch(intOMMajorVersion, intEMMajorVersion);
            }
            if (!information.isAuthorisationRequired() && RPMaster.getNeedsQueryFileTransferProtocol()) {
                int seqNbr = this.createScenario();
                FileTransferProtocolRequest message = new FileTransferProtocolRequest(seqNbr);
                this.sendToBTS(message);
                BTSMessage response = this.receiveFromBTS(seqNbr, 30000L);
                if (response instanceof FileTransferProtocolResponse) {
                    this.myFileTransferFactory.setUsedProtocol(((FileTransferProtocolResponse)response).getUsedFileTransferProtocol());
                }
            }
            someListener.authorisationRequired(information.isAuthorisationRequired());
            ++i;
        }
    }

    @Override
    public void setBTSId(int intBTSId) {
        this.myBTSId = intBTSId;
    }

    @Override
    public void setSessionId(int sessionId) {
        this.mySessionId = sessionId;
    }

    @Override
    public final void addHandShakeListener(HandShakeListener listener) {
        if (listener != null && !this.myHandShakeListeners.contains(listener)) {
            this.myHandShakeListeners.addElement(listener);
        }
    }

    @Override
    public final void addMessageFactory(MessageFactory e) {
        this.messageFactorys.add(e);
    }

    @Override
    public final void removeHandShakeListener(HandShakeListener listener) {
        this.myHandShakeListeners.removeElement(listener);
    }

    @Override
    public final long getTimeOffset() {
        return this.myTimeOffset;
    }

    @Override
    public final long getTimeDiff1900Century() {
        return this.myTimeDiff1900Century;
    }

    @Override
    public final boolean isTimeOffsetSet() {
        return this.myTimeOffsetSet;
    }

    @Override
    public final boolean isNtpTimeExpected() {
        return this.ntpTimeExpected;
    }

    @Override
    public boolean sendToBTS(BTSMessage btsMessage) {
        boolean blnStatus = false;
        if (this.myBtsURLConnection == null || !this.myBtsURLConnection.isConnected()) {
            this.myLogger.error((Object)(String.valueOf(this.myServerName) + " Cannot send " + btsMessage.getClass() + ". Not connected."));
            return blnStatus;
        }
        try {
            btsMessage.setBtsId(this.getBTSId());
            btsMessage.setSessionId(this.getSessionId());
            btsMessage.construct();
            this.checkAuthEnableBlock(btsMessage);
            this.myBtsURLConnection.sendHTTP(btsMessage, true);
            blnStatus = true;
        }
        catch (IOException e) {
            this.myLogger.error((Object)(String.valueOf(this.myServerName) + " sendToBTS: "), (Throwable)e);
        }
        return blnStatus;
    }

    @Override
    public BTSMessage receiveFromBTS(int intSeqNbr) {
        return this.receiveFromBTS(intSeqNbr, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BTSMessage receiveFromBTS(int intSeqNbr, long timeout) {
        BTSScenario btsScenario = null;
        if (this.myBtsScenarioManagerImpl != null) {
            btsScenario = this.myBtsScenarioManagerImpl.getScenario(intSeqNbr);
            if (btsScenario != null) {
                try {
                    BTSScenario bTSScenario = btsScenario;
                    synchronized (bTSScenario) {
                        BTSMessage message = null;
                        if (btsScenario.hasMessage()) {
                            message = btsScenario.getMessage();
                        } else if (timeout > 0L) {
                            long startvalue = System.currentTimeMillis();
                            btsScenario.wait(timeout);
                            long endvalue = System.currentTimeMillis();
                            if (endvalue - startvalue + 50L > timeout) {
                                return new Timeout();
                            }
                            message = btsScenario.getMessage();
                        } else {
                            btsScenario.wait();
                            message = btsScenario.getMessage();
                        }
                        if (message != null && message.getSessionId() > 0) {
                            this.setSessionId(message.getSessionId());
                        }
                        for (BTSMessageFilter filter : this.myFilters) {
                            filter.filterMessage(message);
                        }
                        return message;
                    }
                }
                catch (Exception e) {
                    this.myLogger.error((Object)(String.valueOf(this.myServerName) + " Error in receiving "), (Throwable)e);
                    return null;
                }
            }
            this.myLogger.error((Object)(String.valueOf(this.myServerName) + " Cannot receive, not connected"));
            return null;
        }
        this.myLogger.error((Object)(String.valueOf(this.myServerName) + " Cannot receive, scenario with sequence number " + intSeqNbr + " not found."));
        return null;
    }

    @Override
    public int createScenario() {
        return this.myBtsScenarioManagerImpl.createScenario(false);
    }

    @Override
    public void createScenario(int intSeqNbr) {
        this.myBtsScenarioManagerImpl.createScenario(intSeqNbr, false);
    }

    @Override
    public int createScenario(boolean blnKeepAlive) {
        return this.myBtsScenarioManagerImpl.createScenario(blnKeepAlive);
    }

    @Override
    public void createScenario(int intSeqNbr, boolean blnKeepAlive) {
        this.myBtsScenarioManagerImpl.createScenario(intSeqNbr, blnKeepAlive);
    }

    @Override
    public void deleteScenario(int intSeqNbr) {
        this.myBtsScenarioManagerImpl.removeScenario(intSeqNbr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.reConnect = false;
        if (this.myConnected) {
            this.myConnected = false;
            int intSeqNumber = this.createScenario();
            Disconnect disconnect = new Disconnect(intSeqNumber);
            this.sendToBTS(disconnect);
            TimeReceiver timeReceiver = this.btsOffsetlistener;
            synchronized (timeReceiver) {
                this.btsOffsetlistener.notify();
            }
        } else {
            this.myLogger.debug((Object)"Not connected.");
        }
        this.setSessionId(-1);
        if (this.myBtsReceiver != null) {
            this.myBtsReceiver.terminate();
        }
    }

    @Override
    public void deleteTempFiles(long maximumWaitingTime) {
        if (maximumWaitingTime < 1L) {
            TempFileStore.getInstance().deleteTempFiles(4000L);
        } else {
            TempFileStore.getInstance().deleteTempFiles(maximumWaitingTime);
        }
    }

    public void setAuthEnableBlockOn() {
        this.myLogger.debug((Object)(String.valueOf(this.myServerName) + " Setting block on."));
        if (this.myAuthEnableBlocked) {
            this.myLogger.debug((Object)(String.valueOf(this.myServerName) + " Was already on, cannot set."));
            return;
        }
        this.myAuthEnableBlocked = true;
        TimerService.getInstance().startTimer(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BTSConnectionImpl.this.myLogger.debug((Object)(String.valueOf(BTSConnectionImpl.this.myServerName) + " Making sure that block is off."));
                BTSConnectionImpl.this.myAuthEnableBlocked = false;
            }
        }, 15000L, 1);
    }

    public void setAuthEnableBlockOff() {
        this.myLogger.debug((Object)(String.valueOf(this.myServerName) + " Setting block off."));
        this.myAuthEnableBlocked = false;
    }

    @Override
    public void reEstablishConnection() {
        if (this.myServerName == null || this.myServerPort == 0 || this.reConnect) {
            this.myLogger.error((Object)"Called reestablish() before connect(), or called reconnect when connection is already on");
            throw new IllegalStateException("Called reestablish() before connect(), or called reconnect when connection is already on");
        }
        this.connect(this.myServerName, this.myServerPort);
    }

    @Override
    public void subscribeNotification(BTSNotificationListener btsNotificationListener) {
        this.myBtsNotification.addBTSNotificationListener(btsNotificationListener);
    }

    @Override
    public void unsubscribeNotification(BTSNotificationListener btsNotificationListener) {
        this.myBtsNotification.removeBTSNotificationListener(btsNotificationListener);
    }

    @Override
    public final boolean isBTSConnected() {
        return this.myConnected;
    }

    @Override
    public String getLocalIPAddress() {
        if (this.myBtsURLConnection != null) {
            if (this.myBtsURLConnection.getHttpImpl() != null) {
                return this.myBtsURLConnection.getHttpImpl().getLocalIPAddress();
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interruptScenario(int seqNbr) {
        BTSScenario btsScenario = this.myBtsScenarioManagerImpl.getScenario(seqNbr);
        if (btsScenario != null) {
            if (!btsScenario.isKeepAliveSet()) {
                BTSScenario bTSScenario = btsScenario;
                synchronized (bTSScenario) {
                    btsScenario.addMessage(null);
                    btsScenario.notify();
                }
                this.myBtsScenarioManagerImpl.removeScenario(btsScenario.getSeqNbr());
            } else {
                this.myLogger.debug((Object)(String.valueOf(this.myServerName) + " Unable to interrupt, scenario with sequence number " + seqNbr + " Keepalive flag is on."));
            }
        } else {
            this.myLogger.debug((Object)(String.valueOf(this.myServerName) + " Unable to interrupt, scenario with sequence number " + seqNbr + " does not exist."));
        }
    }

    @Override
    public BTSScenario getScenario(int seqNbr) {
        return this.myBtsScenarioManagerImpl.getScenario(seqNbr);
    }

    @Override
    public void connect(final String strIPAddress, final int intPort) {
        this.myLogger.debug((Object)(String.valueOf(this.myServerName) + " connecting to BTS"));
        if (this.myConnected) {
            this.myLogger.error((Object)"Trying to connect while connection already exist.");
            return;
        }
        if (this.myBtsURLConnection == null) {
            this.myBtsURLConnection = new BTSURLConnection(this);
        }
        this.myServerPort = intPort;
        this.myServerName = strIPAddress;
        this.reConnect = true;
        CoreAssetThread receiverWorker = new CoreAssetThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Object construct() {
                while (BTSConnectionImpl.this.reConnect) {
                    2 var3_6;
                    BTSConnectionImpl.this.myLogger.info((Object)(String.valueOf(BTSConnectionImpl.this.myServerName) + "trying to connect/reconnect..."));
                    BTSConnectionImpl.this.myTimeOffsetSet = false;
                    BTSConnectionImpl.this.myTimeOffset = 0L;
                    BTSConnectionImpl.this.myTimeDiff1900Century = 0L;
                    try {
                        Object lock;
                        HandShakeInformation handShakeInformation = BTSConnectionImpl.this.myBtsURLConnection.connect(strIPAddress, intPort, BTSConnectionImpl.this.myConnectionInfoListeners);
                        if (handShakeInformation.getActiveHost() != null) {
                            BTSConnectionImpl.this.sendBTSConnectionRefused(handShakeInformation.getActiveHost());
                            BTSConnectionImpl.this.myLogger.error((Object)"Maximum connections reached, connection refused.");
                            BTSConnectionImpl.this.reConnect = false;
                            continue;
                        }
                        if (handShakeInformation.isConnected()) {
                            BTSConnectionImpl.this.myLogger.info((Object)(String.valueOf(BTSConnectionImpl.this.myServerName) + "connected, start to receive messages from BTS..."));
                            BTSConnectionImpl.this.myConnected = true;
                            BTSConnectionImpl.this.myBtsReceiver = new BTSReceiver(BTSConnectionImpl.this.myBtsURLConnection);
                            BTSConnectionImpl.this.myBtsReceiver.addHttpListener(BTSConnectionImpl.this.myBTSMessageCreator);
                            BTSConnectionImpl.this.myBtsReceiver.addHttpListener(BTSConnectionImpl.this.btsOffsetlistener);
                            BTSConnectionImpl.this.myBtsReceiver.start();
                            BTSConnectionImpl.this.sendHandShakeInformation(handShakeInformation);
                            BTSConnectionImpl.this.sendBTSConnected();
                            lock = BTSConnectionImpl.this.myBtsReceiver.getLock();
                            var3_6 = lock;
                            synchronized (var3_6) {
                                if (BTSConnectionImpl.this.myBtsReceiver.isReceiverRunning()) {
                                    BTSConnectionImpl.this.myLogger.debug((Object)"use object lock wait connection lost");
                                    lock.wait();
                                    BTSConnectionImpl.this.myLogger.debug((Object)"object lock connection lost");
                                }
                            }
                            BTSConnectionImpl.this.reConnect = false;
                            BTSConnectionImpl.this.sendBTSDisconnected();
                            continue;
                        }
                        BTSConnectionImpl.this.myLogger.debug((Object)"Handshake information is invalid.");
                        if (!BTSConnectionImpl.this.reConnect) continue;
                        lock = this;
                        synchronized (lock) {
                            try {
                                2.sleep((long)5000L);
                            }
                            catch (InterruptedException ie) {
                                BTSConnectionImpl.this.myLogger.error((Object)(String.valueOf(BTSConnectionImpl.this.myServerName) + " Exeption while waiting reconnect"), (Throwable)ie);
                            }
                        }
                    }
                    catch (InterruptedException ie) {
                        BTSConnectionImpl.this.myLogger.error((Object)"InterruptedException when myBtsURLConnection.wait(), should never happen", (Throwable)ie);
                    }
                    catch (SecurityException se) {
                        BTSConnectionImpl.this.myLogger.error((Object)"oops... SecurityException when connecting", (Throwable)se);
                        BTSConnectionImpl.this.btsSertificateRejected();
                        BTSConnectionImpl.this.reConnect = false;
                    }
                    catch (IOException e) {
                        BTSConnectionImpl.this.myLogger.error((Object)(String.valueOf(BTSConnectionImpl.this.myServerName) + " Exception in connect, can't connect, reconnecting"), (Throwable)e);
                        if (!BTSConnectionImpl.this.reConnect) continue;
                        var3_6 = this;
                        synchronized (var3_6) {
                            try {
                                2.sleep((long)5000L);
                            }
                            catch (InterruptedException ie) {
                                BTSConnectionImpl.this.myLogger.error((Object)(String.valueOf(BTSConnectionImpl.this.myServerName) + " Exeption while waiting reconnect"), (Throwable)ie);
                            }
                        }
                    }
                }
                BTSConnectionImpl.this.deleteTempFiles(4000L);
                BTSConnectionImpl.this.myLogger.debug((Object)(String.valueOf(BTSConnectionImpl.this.myServerName) + " (in finished) connection terminated."));
                return this;
            }
        };
        receiverWorker.start();
    }

    @Override
    public void addConnectionInfoListener(ConnectionInfoListener listener) {
        if (listener != null && !this.myConnectionInfoListeners.contains(listener)) {
            this.myConnectionInfoListeners.addElement(listener);
            if (this.isBTSConnected()) {
                listener.btsConnected();
            } else {
                listener.btsDisconnected();
            }
        }
    }

    @Override
    public void removeConnectionInfoListener(ConnectionInfoListener listener) {
        this.myConnectionInfoListeners.removeElement(listener);
    }

    @Override
    public Collection<String> getSavingTasks(PSnapshotConst.SNAPSHOT_LEVEL level) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(SNAPSHOT_TASK_NAME);
        return l;
    }

    @Override
    public boolean isLocalisationRequired() {
        return true;
    }

    @Override
    public void save(final String url, PSnapshotConst.SNAPSHOT_LEVEL level, final SaverProgressListener sp) {
        CoreAssetThread worker = new CoreAssetThread(){

            @Override
            protected Object construct() {
                BTSConnectionImpl.this.runSave(url, sp);
                return null;
            }
        };
        worker.start();
    }

    private void runSave(String url, SaverProgressListener sp) {
        block15: {
            OutputStreamWriter out = null;
            try {
                try {
                    sp.taskStarted(SNAPSHOT_TASK_NAME, 7, 10000, this.isLocalisationRequired());
                    File dir = new File(String.valueOf(url) + RPMaster.FILE_SEPARATOR + SNAPSHOT_TASK);
                    if (!dir.mkdir()) {
                        this.myLogger.warn((Object)(String.valueOf(this.myServerName) + " Failed to create timediff snapshot directory."));
                    }
                    File f = new File(String.valueOf(url) + RPMaster.FILE_SEPARATOR + SNAPSHOT_TASK + RPMaster.FILE_SEPARATOR + SNAPSHOT_TASK + ".txt");
                    out = new OutputStreamWriter(new FileOutputStream(f, false));
                    out.write(this.getSaveData());
                    sp.taskUpdated(SNAPSHOT_TASK_NAME, 8, this.isLocalisationRequired());
                    this.myLogger.debug((Object)(String.valueOf(this.myServerName) + " Timediff snapshot file successfully created"));
                }
                catch (Exception e) {
                    sp.taskUpdated(SNAPSHOT_TASK_NAME, 4, this.isLocalisationRequired());
                    this.myLogger.error((Object)(String.valueOf(this.myServerName) + " Failed to save timediff snapshot information"), (Throwable)e);
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block15;
                    }
                    catch (Exception e2) {
                        sp.taskUpdated(SNAPSHOT_TASK_NAME, 4, this.isLocalisationRequired());
                        this.myLogger.error((Object)(String.valueOf(this.myServerName) + " Failed to close timediff snapshot file"), (Throwable)e2);
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e) {
                    sp.taskUpdated(SNAPSHOT_TASK_NAME, 4, this.isLocalisationRequired());
                    this.myLogger.error((Object)(String.valueOf(this.myServerName) + " Failed to close timediff snapshot file"), (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                sp.taskUpdated(SNAPSHOT_TASK_NAME, 4, this.isLocalisationRequired());
                this.myLogger.error((Object)(String.valueOf(this.myServerName) + " Failed to close timediff snapshot file"), (Throwable)e);
            }
        }
        sp.saveCompleted(this);
    }

    private String getSaveData() {
        String newLine = System.getProperty(LINE_SEPARATOR);
        String data = String.valueOf(Long.toString(this.myTimeDiff1900Century)) + newLine + String.valueOf(this.myTimeOffsetSet) + newLine + RPMaster.getTimeManager().getBTSCalendar().getTimeZone().getID();
        return data;
    }

    @Override
    public void cancel(SaverProgressListener sp) {
        sp.saveCancelled(this);
    }

    @Override
    public int getSavingPriority() {
        return 2;
    }

    @Override
    public void stopProcess(int process) {
    }

    @Override
    public void destroy() {
        this.removeConnectionInfoListener(this.myBTSMessageCreator);
        this.myBtsReceiver.removeHttpListener(this.myBTSMessageCreator);
        this.myBtsReceiver.removeHttpListener(this.btsOffsetlistener);
        RPMaster.removeSnapshotSaver(this);
        this.messageFactorys.clear();
        this.myBTSMessageCreator.destroy();
        this.myBtsURLConnection = null;
        this.myTimeListener = null;
    }

    public void start() {
        BTSURLConnection connection = new BTSURLConnection(this);
        this.myBtsNotification = new BTSNotification();
        this.myBtsURLConnection = connection;
        this.myBtsScenarioManagerImpl = new BTSScenarioManagerImpl(this.myRandomSeqnum);
        this.myBTSMessageCreator = new BTSMessageCreator(this.myBtsScenarioManagerImpl, this.myBtsNotification, this.messageFactorys);
        this.addConnectionInfoListener(this.myBTSMessageCreator);
        this.myTimeOffsetSet = false;
        this.myTimeOffset = 0L;
        this.myHandShakeListeners = new Vector();
        RPMaster.addSnapshotSaver(this);
    }

    @Override
    public void addTimeZoneChangeListener(TimeZoneChangeListener listener) {
        this.myTimeListener = listener;
    }

    public void stop() {
    }

    @Override
    public FileTransferFactory getFileTransferFactory() {
        return this.myFileTransferFactory;
    }

    @Override
    public boolean isSecureConnection() {
        return this.myBtsURLConnection != null ? this.myBtsURLConnection.isSecureConnection() : false;
    }

    @Override
    public void setWriteAccess(boolean writeAccess) {
        this.myWriteAccess = writeAccess;
    }

    @Override
    public boolean hasWriteAccess() {
        return this.myWriteAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPreviousResponse(int seqNbr) {
        BTSScenario btsScenario = this.myBtsScenarioManagerImpl.getScenario(seqNbr);
        if (btsScenario != null) {
            BTSScenario bTSScenario = btsScenario;
            synchronized (bTSScenario) {
                while (btsScenario.hasMessage()) {
                    btsScenario.getMessage();
                }
            }
        }
    }

    private class TimeReceiver
    implements HttpListener {
        private long time = 0L;

        private TimeReceiver() {
        }

        @Override
        public void httpReceived(HttpContent content) {
            this.time = content.getDate();
            try {
                String strDate = BTSConnectionImpl.this.myBtsURLConnection.getLatestDate();
                if (strDate != null) {
                    SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.UK);
                    Date dateBtsTime = formatter.parse(strDate, new ParsePosition(0));
                    if (BTSConnectionImpl.this.isAfter2005(dateBtsTime)) {
                        BTSConnectionImpl.this.setBTSTimeOffset();
                        BTSConnectionImpl.this.ntpTimeExpected = true;
                    } else if (BTSConnectionImpl.this.myTimeDiff1900Century == 0L) {
                        BTSConnectionImpl.this.myTimeDiff1900Century = System.currentTimeMillis() - dateBtsTime.getTime();
                    }
                }
            }
            catch (Exception e) {
                BTSConnectionImpl.this.myLogger.error((Object)(String.valueOf(BTSConnectionImpl.this.myServerName) + " checking time:"), (Throwable)e);
            }
        }

        public long getTime() {
            return this.time;
        }
    }
}

