/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.connection;

import com.nokia.em.bts.rp.master.connection.BTSNotification;
import com.nokia.em.bts.rp.master.connection.BTSScenario;
import com.nokia.em.bts.rp.master.connection.BTSScenarioManagerImpl;
import com.nokia.em.bts.rp.master.connection.ConnectionInfoListener;
import com.nokia.em.bts.rp.master.connection.HttpContent;
import com.nokia.em.bts.rp.master.connection.HttpListener;
import com.nokia.em.bts.rp.master.connection.MessageFactory;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BTSMessageCreator
implements HttpListener,
ConnectionInfoListener {
    private BTSNotification myBTSNotification;
    private BTSScenarioManagerImpl myScenarioManager;
    private List<MessageFactory> myMessageFactorys;
    private Logger myLogger = Logger.getLogger(this.getClass());

    public BTSMessageCreator(BTSScenarioManagerImpl btsScenarioManagerImpl, BTSNotification btsNotification, List<MessageFactory> messageFactorys) {
        this.myScenarioManager = btsScenarioManagerImpl;
        this.myBTSNotification = btsNotification;
        this.myMessageFactorys = messageFactorys;
    }

    public void destroy() {
        this.myScenarioManager = null;
        this.myBTSNotification = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptAll() {
        Vector btsScenarios = (Vector)this.myScenarioManager.getScenarios().clone();
        int i = 0;
        while (i < btsScenarios.size()) {
            BTSScenario btsScenario = (BTSScenario)btsScenarios.elementAt(i);
            if (!btsScenario.isKeepAliveSet()) {
                BTSScenario bTSScenario = btsScenario;
                synchronized (bTSScenario) {
                    btsScenario.addMessage(null);
                    btsScenario.notify();
                }
                this.myScenarioManager.removeScenario(btsScenario.getSeqNbr());
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReceivedContent(HttpContent content) {
        BTSMessage btsMessage = null;
        if (content.hasContent()) {
            try {
                for (MessageFactory mf : this.myMessageFactorys) {
                    btsMessage = mf.createMessage(content);
                    if (btsMessage == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.myLogger.error((Object)"exception in message factory: ", (Throwable)e);
                return;
            }
            if (btsMessage != null) {
                BTSScenario btsScenario = this.myScenarioManager.getScenario(btsMessage.getSeqNbr());
                if (btsScenario != null) {
                    BTSScenario e = btsScenario;
                    synchronized (e) {
                        btsScenario.addMessage(btsMessage);
                        btsScenario.notify();
                    }
                } else if (btsMessage.getSeqNbr() % 2 == 0) {
                    try {
                        this.myBTSNotification.sendNotification(btsMessage);
                    }
                    catch (Exception e) {
                        this.myLogger.error((Object)"sendNotification: ", (Throwable)e);
                    }
                } else {
                    this.myLogger.debug((Object)("Ignoring message " + btsMessage.getClass() + " due the sequence number " + btsMessage.getSeqNbr() + " which has no scenario or is not a notification."));
                }
            }
        }
    }

    @Override
    public void httpReceived(HttpContent content) {
        this.processReceivedContent(content);
    }

    @Override
    public void btsDisconnected() {
        this.myLogger.debug((Object)"btsDisconnect event received");
        this.interruptAll();
    }

    @Override
    public void btsConnected() {
        this.myLogger.debug((Object)"btsConnected event received");
    }

    @Override
    public boolean btsRequestUnsecureConnection() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void btsConnectionRefused(String strActiveHost) {
    }

    @Override
    public void disconnectingFailed() {
    }

    @Override
    public void disconnectingSucceeded() {
    }

    @Override
    public void btsCertificateRejected() {
    }
}

