/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.connection;

import com.nokia.em.bts.rp.master.connection.BTSNotificationListener;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import java.util.Vector;

public class BTSNotification {
    private Vector myBTSNotificationListeners = new Vector(20);

    public synchronized void addBTSNotificationListener(BTSNotificationListener btsNotificationListener) {
        if (this.myBTSNotificationListeners.contains(btsNotificationListener)) {
            return;
        }
        this.myBTSNotificationListeners.addElement(btsNotificationListener);
    }

    public synchronized void removeBTSNotificationListener(BTSNotificationListener btsNotificationListener) {
        this.myBTSNotificationListeners.removeElement(btsNotificationListener);
    }

    public void sendNotification(BTSMessage btsMessage) throws Exception {
        this.fireNotificationReceived(btsMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNotificationReceived(BTSMessage btsMessage) throws Exception {
        Vector vecTl;
        BTSNotification bTSNotification = this;
        synchronized (bTSNotification) {
            vecTl = (Vector)this.myBTSNotificationListeners.clone();
        }
        int intSize = vecTl.size();
        if (intSize == 0) {
            return;
        }
        int i = 0;
        while (i < intSize) {
            BTSNotificationListener btsNotificationListener = (BTSNotificationListener)vecTl.elementAt(i);
            btsNotificationListener.btsNotificationReceived(btsMessage);
            ++i;
        }
    }
}

