/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.connection;

import com.nokia.em.bts.rp.master.connection.BTSURLConnection;
import com.nokia.em.bts.rp.master.connection.HttpContent;
import com.nokia.em.bts.rp.master.connection.HttpListener;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BTSReceiver
extends Thread {
    private volatile boolean blnReceiverRunning = true;
    private boolean blnRun = true;
    private BTSURLConnection myBTSURLConnection;
    private Vector myHttpListeners;
    private Logger myLogger;
    private Object myLock = new Object();
    private static final int MAX_RETRIES = 3;
    private static final int RETRY_INTERVAL = 2000;

    public BTSReceiver(BTSURLConnection btsURLConnection) {
        this.myLogger = Logger.getLogger(this.getClass());
        if (btsURLConnection == null) {
            throw new IllegalArgumentException("null argument not accepted");
        }
        this.myBTSURLConnection = btsURLConnection;
        this.myHttpListeners = new Vector(10);
    }

    public void destroy() {
        this.myBTSURLConnection = null;
    }

    public void addHttpListener(HttpListener listener) {
        if (!this.myHttpListeners.contains(listener)) {
            this.myHttpListeners.addElement(listener);
        }
    }

    public void removeHttpListener(HttpListener listener) {
        if (this.myHttpListeners.contains(listener)) {
            this.myHttpListeners.removeElement(listener);
        }
    }

    public void terminate() {
        this.myLogger.debug((Object)"terminate()");
        this.blnRun = false;
        this.blnReceiverRunning = false;
        this.myBTSURLConnection.disconnect();
        this.notifyBtsDisconnetion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBtsDisconnetion() {
        Object object = this.myLock;
        synchronized (object) {
            this.myLogger.debug((Object)"connection lost, notify");
            this.blnReceiverRunning = false;
            this.myLock.notify();
        }
    }

    @Override
    public void run() {
        this.blnRun = true;
        HttpContent content = null;
        int retryCount = 0;
        this.myLogger.debug((Object)"started.");
        while (this.blnRun) {
            try {
                content = this.myBTSURLConnection.receiveHTTP();
                this.myLogger.trace((Object)"Received Message.");
                this.informListeners(content);
                retryCount = 0;
            }
            catch (SocketTimeoutException e) {
                this.myLogger.error((Object)("Socket timeout #" + ++retryCount), (Throwable)e);
                if (retryCount <= 3) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                this.blnRun = false;
                this.blnReceiverRunning = false;
                this.myBTSURLConnection.disconnect();
            }
            catch (SocketException e) {
                this.myLogger.debug((Object)"Socket was closed:", (Throwable)e);
                this.blnRun = false;
                this.blnReceiverRunning = false;
                this.myBTSURLConnection.disconnect();
            }
            catch (IOException e) {
                this.myLogger.error((Object)"in receiving: ", (Throwable)e);
                this.blnRun = false;
                this.blnReceiverRunning = false;
                this.myBTSURLConnection.disconnect();
            }
        }
        this.notifyBtsDisconnetion();
        this.myLogger.debug((Object)"exiting.");
    }

    public Object getLock() {
        return this.myLock;
    }

    public final boolean isReceiverRunning() {
        return this.blnReceiverRunning;
    }

    private void informListeners(HttpContent content) {
        int i = 0;
        while (i < this.myHttpListeners.size()) {
            HttpListener someListener = (HttpListener)this.myHttpListeners.elementAt(i);
            try {
                someListener.httpReceived(content);
            }
            catch (Exception e) {
                this.myLogger.error((Object)"Informing listener failed", (Throwable)e);
            }
            ++i;
        }
    }
}

