/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.connection;

import com.nokia.em.bts.rp.master.connection.BTSConnectionImpl;
import com.nokia.em.bts.rp.master.connection.ConnectionInfoListener;
import com.nokia.em.bts.rp.master.connection.HandShakeInformation;
import com.nokia.em.bts.rp.master.connection.HttpContent;
import com.nokia.em.bts.rp.master.connection.HttpImpl;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.LoginRequest;
import com.nokia.em.bts.rp.master.message.RAMLRequest;
import com.nokia.em.poseidon.PoseidonRuntime;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BTSURLConnection {
    private static final String CONFIG_OPERATION_TYPE = "_configOperationType";
    private static final String SEQ_NUMBER = "_seqNumber";
    private Map<String, Map<String, String>> unitsMap;
    private DocumentBuilderFactory docBF;
    private HttpImpl myHttpImplConnection = null;
    private URL myUrl = null;
    private MyInputStream myBufferedReaderHttpIn = null;
    private PrintWriter myPrintWriterHttpOut = null;
    private String myHeader = null;
    private String myHandShakeRequest = null;
    private String myLatestDate = null;
    private static final int POLLING_INTERVAL = 15000;
    static final int KEEPALIVE_RECEIVE_TIMEOUT = 61000;
    private static final int MAX_PORT = 65535;
    private static final String CRLF = "\r\n";
    private static final String WHITE_SPACE = " ";
    private static final String REQUEST_PROTOCOL_AND_VERSION = "HTTP/1.1";
    private static final String HTTP_HEADER_IF_MAJOR_VERSION = "Major-version:";
    private static final String HTTP_HEADER_IF_MINOR_VERSION = "Minor-version:";
    private static final String HTTP_HEADER_ACTIVE_CONNECTION = "Active-Connection:";
    private static final String HTTP_HEADER_USER_AGENT = "User-Agent:";
    private static final String HTTP_HEADER_ACCEPT = "Accept:";
    private static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type:";
    private static final String HTTP_HEADER_HOST = "Host:";
    private static final String HTTP_HEADER_RANGE = "Range:";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_POST = "POST";
    private Logger myLogger = Logger.getLogger(this.getClass());
    private boolean keepaliveTimeout = true;
    private ScheduledThreadPoolExecutor timeoutTimer;
    private ScheduledFuture<?> timeoutScheduledFuture;
    private Object timeoutTimerSynhronizer = new Object();
    private BTSConnectionImpl myConnection;
    private boolean keepalivePollerStarted = false;
    private Timer myHandShakeTimer;
    private static final int HANDSHAKE_TIMEOUT = 60000;

    public BTSURLConnection(BTSConnectionImpl connection) {
        this.myLogger.debug((Object)"new BTSURLConnection");
        this.myConnection = connection;
        if (PoseidonRuntime.getRuntime().getParameters().isDefined("noKeepaliveTimeout")) {
            this.keepaliveTimeout = false;
        }
        this.timeoutTimer = new ScheduledThreadPoolExecutor(1);
        this.unitsMap = new HashMap<String, Map<String, String>>();
        this.docBF = DocumentBuilderFactory.newInstance();
    }

    public void sendHTTP(BTSMessage btsMessage, boolean blnResponse) throws IOException {
        String strToSend = btsMessage.getCodedMessage();
        if (btsMessage instanceof LoginRequest) {
            this.myLogger.trace((Object)("Sending LoginRequest with _sessionId " + btsMessage.getSessionId() + " and read-only " + ((LoginRequest)btsMessage).isReadOnly()));
        } else if (btsMessage instanceof RAMLRequest) {
            String s = ((RAMLRequest)btsMessage).getLogTrace();
            if (s != null) {
                this.myLogger.trace((Object)("Sending " + s));
            } else {
                this.myLogger.trace((Object)("Sending " + strToSend));
            }
        } else {
            this.myLogger.trace((Object)("Sending " + strToSend));
        }
        if (this.keepaliveTimeout) {
            this.startPolling();
        }
        int intLength = strToSend.getBytes("UTF-8").length;
        this.myLogger.debug((Object)("Send message content-length: " + intLength));
        try {
            StringBuffer sendBuffer = new StringBuffer();
            if (blnResponse) {
                sendBuffer.append(METHOD_POST);
            } else {
                sendBuffer.append("PUT");
            }
            sendBuffer.append(this.myHeader);
            sendBuffer.append("Content-Length: ");
            sendBuffer.append(intLength);
            sendBuffer.append(CRLF);
            sendBuffer.append(CRLF);
            String encodeStr = new String(strToSend.getBytes("UTF-8"), "UTF-8");
            sendBuffer.append(encodeStr);
            this.myPrintWriterHttpOut.print(sendBuffer.toString());
            this.myPrintWriterHttpOut.flush();
            if (btsMessage instanceof LoginRequest) {
                String readOnlyInfo = ((LoginRequest)btsMessage).isReadOnly() ? " with readOnly flag true" : "";
                int sessionId = btsMessage.getSessionId();
                String sessionIdInfo = sessionId > 0 ? " with sessionId value " + sessionId : "";
                this.myLogger.debug((Object)("Sent LoginRequest" + readOnlyInfo + sessionIdInfo + "."));
            } else if (btsMessage instanceof RAMLRequest) {
                String s = ((RAMLRequest)btsMessage).getLogTrace();
                if (s != null) {
                    this.myLogger.debug((Object)("Sent " + s));
                } else {
                    this.myLogger.debug((Object)("Sent " + strToSend));
                }
            } else {
                this.myLogger.debug((Object)("Sent " + btsMessage.getDebugMessage()));
            }
        }
        catch (Exception e) {
            throw new IOException("Send failed: (" + e + ")");
        }
    }

    public synchronized HttpContent receiveHTTP() throws IOException {
        int statusCode;
        String date;
        StringBuilder httpHeader;
        String strInputLine;
        String strResponse;
        int intLength;
        block20: {
            intLength = 0;
            strResponse = "";
            strInputLine = null;
            httpHeader = new StringBuilder();
            date = null;
            statusCode = -1;
            boolean blnContent = false;
            this.startKeepaliveReceiver();
            if (this.myBufferedReaderHttpIn != null) {
                try {
                    while ((strInputLine = this.myBufferedReaderHttpIn.readLine()) != null) {
                        if (strInputLine.length() <= 0 || !strInputLine.startsWith("HTTP")) continue;
                        httpHeader.append(String.valueOf(strInputLine) + "\n");
                        StringTokenizer httpStringTokenizer = new StringTokenizer(strInputLine, WHITE_SPACE);
                        httpStringTokenizer.nextToken();
                        String s = httpStringTokenizer.nextToken();
                        try {
                            statusCode = Integer.parseInt(s);
                        }
                        catch (Exception e) {
                            statusCode = Integer.parseInt(s.substring(s.indexOf("/") + 1));
                        }
                        while (true) {
                            if ((strInputLine = this.myBufferedReaderHttpIn.readLine()) == null) {
                                continue;
                            }
                            if (strInputLine.length() <= 0) break;
                            if (blnContent) {
                                strResponse = strInputLine;
                                break block20;
                            }
                            String strComp = strInputLine.toLowerCase();
                            if (strComp.startsWith("content-length")) {
                                StringTokenizer st = new StringTokenizer(strInputLine, ":");
                                st.nextToken();
                                String strLength = st.nextToken().trim();
                                intLength = Integer.parseInt(strLength);
                                this.myLogger.debug((Object)("receive message content-length: " + intLength));
                            } else if (strComp.startsWith("date:") && strComp.length() > 6) {
                                this.myLatestDate = date = strInputLine.substring(6);
                            }
                            httpHeader.append(String.valueOf(strInputLine) + "\n");
                        }
                        if (intLength > 0) {
                            blnContent = true;
                            byte[] byteBuf = new byte[intLength];
                            int charsReadTotal = 0;
                            int charsRead = 0;
                            while (charsReadTotal < intLength && charsRead >= 0) {
                                charsRead = this.myBufferedReaderHttpIn.read(byteBuf, charsReadTotal, intLength - charsReadTotal);
                                if (charsRead <= 0) continue;
                                charsReadTotal += charsRead;
                            }
                            strResponse = new String(byteBuf, "UTF-8");
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    this.stopPolling();
                    throw ioe;
                }
            }
        }
        if (strInputLine == null) {
            this.stopPolling();
            throw new IOException(" Connection broken. ");
        }
        if ("".equalsIgnoreCase(strResponse.trim())) {
            strResponse = "keepalive";
        }
        if (strResponse.contains("DataChangeNotif")) {
            try {
                this.receiveDataChangeNotif(strResponse);
            }
            catch (Exception e) {
                this.myLogger.error((Object)("DCN parse failed! " + strResponse), (Throwable)e);
            }
        } else {
            this.myLogger.debug((Object)("Received " + strResponse));
        }
        HttpContent content = null;
        String strHttpHeader = httpHeader.toString();
        content = intLength > 0 ? new HttpContent(strHttpHeader, strResponse, date, statusCode) : new HttpContent(strHttpHeader, "", date, statusCode);
        return content;
    }

    private void receiveDataChangeNotif(String strResponse) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder docBuilder = this.docBF.newDocumentBuilder();
        Document doc = docBuilder.parse(new ByteArrayInputStream(strResponse.getBytes()));
        NodeList objectDataNode = doc.getElementsByTagName("_objectData");
        if (objectDataNode == null || objectDataNode.getLength() == 0) {
            this.myLogger.debug((Object)("Received " + strResponse));
            this.myLogger.debug((Object)"No _objectData in the DataChangeNotif, it might be delete operation");
            return;
        }
        Node objectData = objectDataNode.item(0);
        Node objectNode = objectData.getFirstChild();
        while (objectNode != null && objectNode.getNodeType() != 1) {
            objectNode = objectNode.getNextSibling();
        }
        if (objectNode == null) {
            this.myLogger.debug((Object)("Received " + strResponse));
            return;
        }
        Map<String, String> unitParameters = this.generateUnitMap(doc, objectNode);
        String key = String.valueOf(objectNode.getNodeName()) + ":" + unitParameters.get("_id");
        if (!this.unitsMap.containsKey(key) || objectNode.getNodeType() != 1) {
            this.myLogger.debug((Object)("Received " + strResponse));
        } else {
            this.logDiff(key, unitParameters);
        }
        this.unitsMap.put(key, unitParameters);
    }

    public Map<String, String> generateUnitMap(Document doc, Node objectNode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(SEQ_NUMBER, doc.getElementsByTagName(SEQ_NUMBER).item(0).getTextContent());
        Node _configOperationType = doc.getElementsByTagName(CONFIG_OPERATION_TYPE).item(0);
        map.put(CONFIG_OPERATION_TYPE, _configOperationType.getTextContent());
        NodeList nodeList = objectNode.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            map.put(nodeList.item(i).getNodeName(), nodeList.item(i).getTextContent());
            ++i;
        }
        return map;
    }

    public void logDiff(String mapKey, Map<String, String> newMap) {
        Map<String, String> oldMap = this.unitsMap.get(mapKey);
        StringBuilder sb = new StringBuilder();
        sb.append("<DataChangeNotif>\n");
        this.addXMLNode(sb, SEQ_NUMBER, newMap.get(SEQ_NUMBER));
        this.addXMLNode(sb, CONFIG_OPERATION_TYPE, newMap.get(CONFIG_OPERATION_TYPE));
        String[] typeId = mapKey.split(":");
        sb.append("<" + typeId[0] + ">\n");
        this.addXMLNode(sb, "_id", typeId[1]);
        for (Map.Entry<String, String> oldEntry : oldMap.entrySet()) {
            String key = oldEntry.getKey();
            if (CONFIG_OPERATION_TYPE.equals(key) || SEQ_NUMBER.equals(key)) continue;
            if (!newMap.containsKey(key)) {
                sb.append("-");
                this.addXMLNode(sb, key, oldEntry.getValue());
                continue;
            }
            if (newMap.get(key).equals(oldEntry.getValue())) continue;
            this.addXMLNode(sb, key, newMap.get(key));
        }
        for (Map.Entry<String, String> newEntry : newMap.entrySet()) {
            String key = newEntry.getKey();
            if (CONFIG_OPERATION_TYPE.equals(key) || SEQ_NUMBER.equals(key) || oldMap.containsKey(key)) continue;
            sb.append("+");
            this.addXMLNode(sb, key, newEntry.getValue());
        }
        this.myLogger.debug((Object)("Received " + sb.toString()));
    }

    private StringBuilder addXMLNode(StringBuilder sb, String key, String value) {
        if ("".equals(value)) {
            sb.append("<").append(key).append("/>");
        } else {
            sb.append("<").append(key).append(">").append(value).append("</").append(key).append(">");
        }
        return sb;
    }

    public void disconnect() {
        if (this.myHttpImplConnection != null) {
            this.myHttpImplConnection.disconnect();
        } else {
            this.myLogger.debug((Object)"Unable to disconnect, not connected");
        }
        this.stopPolling();
        this.myPrintWriterHttpOut = null;
        this.unitsMap.clear();
    }

    public String getLatestDate() {
        return this.myLatestDate;
    }

    public void sendAliveRequest() {
        try {
            this.myLogger.trace((Object)"Sending keepalive");
            this.myPrintWriterHttpOut.print("GET " + this.myUrl.toString() + " HTTP/1.1" + CRLF + "Range: bytes 0-" + CRLF + CRLF);
            this.myPrintWriterHttpOut.flush();
            this.myLogger.debug((Object)"Keepalive sent");
        }
        catch (Exception e) {
            this.stopPolling();
            this.myLogger.debug((Object)"Unable to poll, not connected");
        }
    }

    protected boolean isSSLCertificateValidating() {
        return this.myHttpImplConnection.isSSLCertificateValidating();
    }

    protected boolean isSocketUnderCreation() {
        return this.myHttpImplConnection.isSocketUnderCreation();
    }

    public boolean isConnected() {
        return this.myHttpImplConnection != null ? this.myHttpImplConnection.isConnected() : false;
    }

    public HandShakeInformation connect(String strServerName, int intServerPort, Vector<ConnectionInfoListener> connectionInfoListeners) throws ConnectException, IOException, SecurityException {
        this.myLogger.debug((Object)"new connect");
        this.myLatestDate = null;
        if (intServerPort < 0 || intServerPort > 65535) {
            throw new ConnectException("port out of range: " + intServerPort);
        }
        this.myUrl = new URL("http", strServerName, intServerPort, "/");
        boolean needTLSv1Retry = false;
        if (this.myHttpImplConnection != null) {
            needTLSv1Retry = this.myHttpImplConnection.isTLSv1RetryNeeded();
        }
        this.myHttpImplConnection = new HttpImpl(this.myUrl, connectionInfoListeners);
        this.myHttpImplConnection.setTLSv1RetryNeeded(needTLSv1Retry);
        this.createHTTPHeader();
        this.createHandShakeRequest();
        this.myHttpImplConnection.connect();
        this.myPrintWriterHttpOut = new PrintWriter(this.myHttpImplConnection.getOutputStream());
        this.myBufferedReaderHttpIn = new MyInputStream(this.myHttpImplConnection.getInputStream());
        this.myHandShakeTimer = new Timer();
        this.myHandShakeTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                BTSURLConnection.this.myLogger.error((Object)"HTTP handshake times out");
                BTSURLConnection.this.myHttpImplConnection.disconnect();
            }
        }, 60000L);
        HandShakeInformation handShakeInformation = null;
        try {
            handShakeInformation = this.handShake();
        }
        finally {
            this.myHandShakeTimer.cancel();
        }
        if (!handShakeInformation.isAuthorisationRequired() && this.keepaliveTimeout && handShakeInformation.getActiveHost() == null) {
            this.startPolling();
            this.startKeepaliveReceiver();
        }
        return handShakeInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPolling() {
        if (!this.keepalivePollerStarted) {
            Object object = this.timeoutTimerSynhronizer;
            synchronized (object) {
                this.keepalivePollerStarted = true;
                new KeepaliveThread().start();
                this.myLogger.debug((Object)"Keepalive poller started.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPolling() {
        Object object = this.timeoutTimerSynhronizer;
        synchronized (object) {
            this.myLogger.debug((Object)"stopping keepalive poller.");
            if (this.keepalivePollerStarted && this.timeoutScheduledFuture != null) {
                this.timeoutScheduledFuture.cancel(true);
                this.timeoutTimer.remove((Runnable)((Object)this.timeoutScheduledFuture));
            }
            this.keepalivePollerStarted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startKeepaliveReceiver() {
        if (this.keepaliveTimeout) {
            Object object = this.timeoutTimerSynhronizer;
            synchronized (object) {
                if (this.keepaliveTimeout) {
                    this.myLogger.debug((Object)"Keepalive receiver started or reseted.");
                    if (this.timeoutScheduledFuture != null) {
                        this.timeoutScheduledFuture.cancel(true);
                        this.timeoutTimer.remove((Runnable)((Object)this.timeoutScheduledFuture));
                    }
                    this.timeoutScheduledFuture = this.timeoutTimer.schedule(new TimeoutTask(), 61000L, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    protected final HttpImpl getHttpImpl() {
        return this.myHttpImplConnection;
    }

    private void createHTTPHeader() throws ProtocolException {
        this.myHttpImplConnection.setRequestMethod(METHOD_POST);
        this.myHttpImplConnection.setRequestProperty("User-Agent", "JavaBTSManager/0.1");
        this.myHttpImplConnection.setRequestProperty("Accept", "application/text");
        this.myHttpImplConnection.setRequestProperty("Content-Type", "application/text");
        StringBuffer strHeaderBuffer = new StringBuffer(WHITE_SPACE);
        strHeaderBuffer.append(this.myUrl.toString());
        strHeaderBuffer.append(WHITE_SPACE);
        strHeaderBuffer.append(REQUEST_PROTOCOL_AND_VERSION);
        strHeaderBuffer.append(CRLF);
        strHeaderBuffer.append(HTTP_HEADER_USER_AGENT);
        strHeaderBuffer.append(WHITE_SPACE);
        strHeaderBuffer.append(this.myHttpImplConnection.getRequestProperty("User-Agent"));
        strHeaderBuffer.append(CRLF);
        strHeaderBuffer.append(HTTP_HEADER_HOST);
        strHeaderBuffer.append(WHITE_SPACE);
        strHeaderBuffer.append(this.myUrl.getHost());
        strHeaderBuffer.append(":");
        strHeaderBuffer.append(this.myUrl.getPort());
        strHeaderBuffer.append(CRLF);
        strHeaderBuffer.append(HTTP_HEADER_ACCEPT);
        strHeaderBuffer.append(WHITE_SPACE);
        strHeaderBuffer.append(this.myHttpImplConnection.getRequestProperty("Accept"));
        strHeaderBuffer.append(CRLF);
        strHeaderBuffer.append(HTTP_HEADER_CONTENT_TYPE);
        strHeaderBuffer.append(WHITE_SPACE);
        strHeaderBuffer.append(this.myHttpImplConnection.getRequestProperty("Content-Type"));
        strHeaderBuffer.append(CRLF);
        this.myHeader = strHeaderBuffer.toString();
    }

    private void createHandShakeRequest() {
        StringBuffer strHandShakeBuffer = new StringBuffer(METHOD_GET);
        strHandShakeBuffer.append(WHITE_SPACE);
        strHandShakeBuffer.append(this.myUrl.toString());
        strHandShakeBuffer.append(WHITE_SPACE);
        strHandShakeBuffer.append(REQUEST_PROTOCOL_AND_VERSION);
        strHandShakeBuffer.append(CRLF);
        strHandShakeBuffer.append(HTTP_HEADER_RANGE);
        strHandShakeBuffer.append(WHITE_SPACE);
        strHandShakeBuffer.append("bytes 0-");
        strHandShakeBuffer.append(CRLF);
        strHandShakeBuffer.append(CRLF);
        this.myHandShakeRequest = strHandShakeBuffer.toString();
    }

    private synchronized HandShakeInformation handShake() throws IOException {
        HandShakeInformation handShakeInformation = new HandShakeInformation();
        String strInputLine = null;
        int intStatusCode = -1;
        this.myPrintWriterHttpOut.print(this.myHandShakeRequest);
        this.myPrintWriterHttpOut.flush();
        this.myLogger.debug((Object)("handShake request sent to BTS: " + this.myHandShakeRequest));
        block0: while ((strInputLine = this.myBufferedReaderHttpIn.readLine()) != null) {
            if (strInputLine.length() <= 0) continue;
            handShakeInformation.setIsConnected(true);
            this.myLogger.debug((Object)("Handshake readline: '" + strInputLine + "'"));
            if (!strInputLine.startsWith("HTTP")) continue;
            StringTokenizer httpStringTokenizer = new StringTokenizer(strInputLine, WHITE_SPACE);
            httpStringTokenizer.nextToken();
            intStatusCode = Integer.parseInt(httpStringTokenizer.nextToken());
            if (intStatusCode == 401) {
                this.myLogger.debug((Object)"Authentication is on.");
                handShakeInformation.setAuthorisationRequired(true);
            } else {
                this.myLogger.debug((Object)"Authentication is off.");
                handShakeInformation.setAuthorisationRequired(false);
            }
            while (true) {
                if ((strInputLine = this.myBufferedReaderHttpIn.readLine()) == null) {
                    continue;
                }
                this.myLogger.debug((Object)("Handshake readline2: '" + strInputLine + "'"));
                if (strInputLine.length() <= 0) break;
                StringTokenizer headerTokenizer = new StringTokenizer(strInputLine, ":");
                headerTokenizer.nextToken();
                if (!headerTokenizer.hasMoreTokens()) continue;
                if (strInputLine.startsWith(HTTP_HEADER_ACTIVE_CONNECTION)) {
                    String activeConnection = headerTokenizer.nextToken().trim();
                    if (activeConnection.length() > 0) {
                        handShakeInformation.setActiveHost(activeConnection);
                        break block0;
                    }
                    if (intStatusCode == 403) {
                        this.myLogger.debug((Object)"Active-Connection was in handshake, but empty. But refuse new connection.");
                        this.myHttpImplConnection.disconnect();
                        throw new IOException("Active-Connection was in handshake, but empty. But refuse new connection.");
                    }
                    this.myLogger.debug((Object)"Active-Connection was in handshake, but empty. Intrepret as all is ok in connection.");
                    break block0;
                }
                if (strInputLine.startsWith(HTTP_HEADER_IF_MAJOR_VERSION)) {
                    handShakeInformation.setInterfaceMajorVersion(headerTokenizer.nextToken().trim());
                }
                if (!strInputLine.startsWith(HTTP_HEADER_IF_MINOR_VERSION)) continue;
                handShakeInformation.setInterfaceMinorVersion(headerTokenizer.nextToken().trim());
            }
            this.myLogger.error((Object)"handshake reponse with empty string");
            break;
        }
        return handShakeInformation;
    }

    public boolean isSecureConnection() {
        return this.myHttpImplConnection.isSecureConnection();
    }

    private class KeepaliveThread
    extends Thread {
        private KeepaliveThread() {
        }

        @Override
        public void run() {
            this.setPriority(10);
            while (BTSURLConnection.this.keepalivePollerStarted) {
                if (BTSURLConnection.this.myHttpImplConnection != null && BTSURLConnection.this.myHttpImplConnection.isConnected()) {
                    BTSURLConnection.this.sendAliveRequest();
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException e) {
                        BTSURLConnection.this.myLogger.warn((Object)("Keepalive sleep with exception :" + e));
                    }
                    continue;
                }
                BTSURLConnection.this.myLogger.debug((Object)"keepAlive requested, but not connected stopping polling");
                BTSURLConnection.this.stopPolling();
            }
            BTSURLConnection.this.myLogger.debug((Object)"Keepalive poller stopped.");
        }
    }

    class MyInputStream
    extends FilterInputStream {
        private static final int CR = 13;
        private static final int LF = 10;

        public MyInputStream(InputStream inputStream) {
            super(inputStream);
        }

        public String readLine() throws IOException {
            StringBuffer readDataBuffer = new StringBuffer("");
            int readChar = -1;
            while ((readChar = this.in.read()) != -1) {
                if (readChar == 13) continue;
                if (readChar == 10) break;
                readDataBuffer.append((char)readChar);
            }
            if (readChar == -1 && readDataBuffer.length() == 0) {
                return null;
            }
            return readDataBuffer.toString();
        }
    }

    private class TimeoutTask
    implements Runnable {
        private TimeoutTask() {
        }

        @Override
        public void run() {
            BTSURLConnection.this.myLogger.error((Object)"Keepalive timeout reached");
            BTSURLConnection.this.myConnection.disconnect();
        }
    }
}

