/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.connection;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class HttpContent {
    public static final int STATUS_100_CONTINUE = 100;
    public static final int STATUS_101_SWITCHING_PROTOCOLS = 101;
    public static final int STATUS_200_OK = 200;
    public static final int STATUS_201_CREATED = 201;
    public static final int STATUS_202_ACCEPTED = 202;
    public static final int STATUS_203_NON_AUTHORATIVE_INFORMATION = 203;
    public static final int STATUS_204_NO_CONTENT = 204;
    public static final int STATUS_205_RESET_CONTENT = 205;
    public static final int STATUS_206_PARTIAL_CONTENT = 206;
    public static final int STATUS_300_MULTIPLE_CHOICE = 300;
    public static final int STATUS_301_MOVED_PERMANENTLY = 301;
    public static final int STATUS_302_FOUND = 302;
    public static final int STATUS_303_SEE_OTHER = 303;
    public static final int STATUS_304_NOT_MODIFIED = 304;
    public static final int STATUS_305_USE_PROXY = 305;
    public static final int STATUS_307_TEMPORARY_REDIRECT = 307;
    public static final int STATUS_400_BAD_REQUEST = 400;
    public static final int STATUS_401_UNAUTHORIZED = 401;
    public static final int STATUS_402_PAYMENT_REQUIRED = 402;
    public static final int STATUS_403_FORBIDDEN = 403;
    public static final int STATUS_404_NOT_FOUND = 404;
    public static final int STATUS_405_METHOD_NOT_ALLOWED = 405;
    public static final int STATUS_406_NOT_ACCEPTABLE = 406;
    public static final int STATUS_407_PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int STATUS_408_REQUEST_TIMEOUT = 408;
    public static final int STATUS_409_CONFLICT = 409;
    public static final int STATUS_410_GONE = 410;
    public static final int STATUS_411_LENGTH_REQUIRED = 411;
    public static final int STATUS_412_PRECONDITION_FAILED = 412;
    public static final int STATUS_413_REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int STATUS_414_REQUEST_URI_TOO_LONG = 414;
    public static final int STATUS_415_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int STATUS_416_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    public static final int STATUS_417_EXPECTATION_FAILED = 417;
    public static final int STATUS_500_INTERNAL_SERVER_ERROR = 500;
    public static final int STATUS_501_NOT_IMPLEMENTED = 501;
    public static final int STATUS_502_BAD_GATEWAY = 502;
    public static final int STATUS_503_SERVICE_UNAVAILABLE = 503;
    public static final int STATUS_504_GATEWAY_TIMEOUT = 504;
    public static final int STATUS_505_HTTP_VERSION_NOT_SUPPORTED = 505;
    private final String header;
    private final String date;
    private final String content;
    private final int statusCode;

    public HttpContent(String header, String content, String date, int statusCode) {
        this.header = header;
        this.content = content;
        this.date = date;
        this.statusCode = statusCode;
    }

    public String getHeader() {
        return this.header;
    }

    public String getContent() {
        return this.content;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public long getDate() {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.UK);
            Date dateBtsTime = formatter.parse(this.date, new ParsePosition(0));
            return dateBtsTime.getTime();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)("Http message header:\n" + this.header));
            Logger.getLogger(this.getClass()).error((Object)"getDate failed", (Throwable)e);
            return 0L;
        }
    }

    public boolean isAliveMessage() {
        boolean returnValue = false;
        if (this.content == null) {
            returnValue = true;
        } else if (this.content.startsWith("connected")) {
            returnValue = true;
        }
        return returnValue;
    }

    public boolean hasContent() {
        return this.content != null && this.content.length() > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpContent)) {
            return false;
        }
        HttpContent httpContent = (HttpContent)o;
        if (this.content != null ? !this.content.equals(httpContent.content) : httpContent.content != null) {
            return false;
        }
        if (this.date != null ? !this.date.equals(httpContent.date) : httpContent.date != null) {
            return false;
        }
        return this.statusCode == httpContent.statusCode;
    }

    public int hashCode() {
        int result = this.date != null ? this.date.hashCode() : 0;
        result = 29 * result + 29 * this.statusCode + (this.content != null ? this.content.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Status: " + this.statusCode + "Date: " + this.date + System.getProperty("line.separator") + "Content: " + this.content;
    }
}

