/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.connection;

import com.nokia.em.bts.rp.master.connection.ConnectionInfoListener;
import com.nokia.em.bts.rp.master.connection.MasterSecureRandomProvider;
import com.nokia.em.bts.rp.master.connection.SSLTrustManager;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.comm.http.Tools;
import com.nokia.em.poseidon.util.debugging.DebugUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.security.SecureRandom;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.log4j.Logger;

public class HttpImpl
extends HttpURLConnection {
    private final Map<String, String> htRequestProperties = new HashMap<String, String>(10);
    private Socket socket = null;
    private String localIPAddress = "";
    private static final int HTTP_PORT = 80;
    private Logger myLogger;
    private SSLTrustManager mySSLTrustManager;
    private boolean mySocketUnderCreation = false;
    private Vector myConnectionInfoListeners;
    private static final int CREATE_SOCKET_TIMEOUT = 30000;
    private SSLSocketFactory mySocketFactory;
    private SSLSocket mySSLSocket;
    private Object myCreateSocketLock = new Object();
    private Object myCloseSocketLock = new Object();
    private boolean myTLSv1Retry = false;
    private static final int CLOSE_SOCKET_TIMEOUT = 5000;
    private static final int SSL_TIMEOUT = 30000;
    private static final int UNSECURE_CONNECTION_DELAY = 3000;
    private static final String[] SUPPORTED_CIPHER_SUITES_ARRAY = new String[]{"TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"};

    public HttpImpl(URL url, Vector connectionInfoListeners) {
        super(url);
        this.myConnectionInfoListeners = connectionInfoListeners;
        this.myLogger = Logger.getLogger(this.getClass());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void setRequestProperty(String strKey, String strValue) {
        this.htRequestProperties.put(strKey, strValue);
    }

    @Override
    public String getRequestProperty(String strKey) {
        return this.htRequestProperties.get(strKey);
    }

    protected final String getLocalIPAddress() {
        return this.localIPAddress;
    }

    protected boolean isSSLCertificateValidating() {
        return this.mySSLTrustManager.isSSLCertificateValidating();
    }

    protected boolean isSocketUnderCreation() {
        return this.mySocketUnderCreation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Socket createSocket(String host, int port) throws IOException, SecurityException {
        try {
            this.mySSLTrustManager = new SSLTrustManager();
            this.myLogger.debug((Object)"TrustManager created.");
            SSLContext sc = null;
            if (this.myTLSv1Retry) {
                sc = SSLContext.getInstance("TLSv1");
                this.myLogger.debug((Object)"Prepare TLSv1 connection.");
            } else {
                sc = Tools.getSSLContextWithStrongestTLSVersion();
                this.myLogger.debug((Object)"Prepare TLSv1.2 connection.");
            }
            this.myLogger.debug((Object)"SSL Context created.");
            Security.addProvider(new MasterSecureRandomProvider());
            this.myLogger.debug((Object)"RandomProvider added to security.");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG", "Master");
            this.myLogger.debug((Object)"SecureRandom instance created.");
            sc.init(null, new TrustManager[]{this.mySSLTrustManager}, secureRandom);
            this.myLogger.debug((Object)"SSLContext initialized.");
            this.mySocketFactory = sc.getSocketFactory();
            this.myLogger.debug((Object)"SSLSocketFactory created.");
            this.creatUnconnectedSocket();
            Object object = this.myCreateSocketLock;
            synchronized (object) {
                if (this.mySSLSocket == null) {
                    this.myCreateSocketLock.wait(30000L);
                }
            }
            if (this.mySSLSocket == null) {
                this.myLogger.error((Object)"Creating unconnected socket failed with time-out");
                this.myLogger.error((Object)DebugUtils.generateThreadDump());
                throw new Exception();
            }
            final SSLSocket sslSocket = this.mySSLSocket;
            if (this.myTLSv1Retry) {
                sslSocket.setEnabledProtocols(new String[]{"TLSv1"});
            } else {
                sslSocket.setEnabledProtocols(Tools.getSupportedProtocols((String[])new String[]{"TLSv1.2", "TLSv1"}));
                sslSocket.setEnabledCipherSuites(Tools.getSupportedCipherSuites((String[])SUPPORTED_CIPHER_SUITES_ARRAY));
            }
            this.myLogger.debug((Object)("Creating Socket to address " + host + ":" + port));
            if (com.nokia.em.poseidon.comm.common.Tools.isDnsName((String)host)) {
                this.myLogger.debug((Object)"DNS name given, connecting the old way");
                sslSocket.connect(new InetSocketAddress(host, port), 30000);
            } else {
                this.myLogger.debug((Object)"DNS name not given, connecting the new way");
                sslSocket.connect(com.nokia.em.poseidon.comm.common.Tools.createInetSocketAddress((String)host, (int)port), 30000);
            }
            this.myLogger.debug((Object)("SSL socket connected to " + host + ", local port " + sslSocket.getLocalPort()));
            this.mySocketUnderCreation = true;
            final Boolean[] timeOutValue = new Boolean[]{true};
            CoreAssetThread timeOutThread = new CoreAssetThread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected Object construct() throws Exception {
                    Boolean[] booleanArray = timeOutValue;
                    synchronized (timeOutValue) {
                        HttpImpl.this.myLogger.debug((Object)"SSL TimeOutThread wait start.");
                        timeOutValue.wait(30000L);
                        HttpImpl.this.myLogger.debug((Object)"SSL TimeOutThread wait end.");
                        if (timeOutValue[0].booleanValue() && !HttpImpl.this.mySSLTrustManager.isSSLCertificateValidating()) {
                            HttpImpl.this.myLogger.debug((Object)"SSL TimeOutThread was timeouted and SSL certificate is not validating.");
                            sslSocket.close();
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return null;
                    }
                }
            };
            timeOutThread.start();
            this.myLogger.debug((Object)"SSLSocket created.");
            SSLSession sslSession = sslSocket.getSession();
            this.myLogger.debug((Object)"SSLSession received.");
            Boolean[] booleanArray = timeOutValue;
            synchronized (timeOutValue) {
                timeOutValue[0] = false;
                timeOutValue.notify();
                // ** MonitorExit[var9_11] (shouldn't be in output)
                if (this.mySSLTrustManager.wasRejected()) {
                    sslSocket.close();
                    this.myLogger.debug((Object)"Certificate was rejected");
                    throw new SecurityException("Certificate was rejected.");
                }
                this.myLogger.debug((Object)"Certificate was accepted");
                if ("NONE".equalsIgnoreCase(sslSession.getProtocol())) {
                    sslSocket.close();
                    if (!this.myTLSv1Retry) {
                        this.myTLSv1Retry = true;
                        throw new IOException("retry connection with TLSv1");
                    }
                    this.myLogger.debug((Object)"Socket not SSL, request using unsecure connection.");
                    long delay = System.currentTimeMillis();
                    boolean response = this.requestUnsecureConnection();
                    this.mySocketUnderCreation = false;
                    if (response) {
                        this.myLogger.debug((Object)"Unsecure connection accepted by user...");
                        delay = 3000L - (System.currentTimeMillis() - delay);
                        if (delay > 0L) {
                            try {
                                Thread.sleep(delay);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        this.myLogger.debug((Object)"Trying to open unsecure socket");
                        return new Socket(host, port);
                    }
                    throw new SecurityException("Unsecure connection was rejected.");
                }
                this.myLogger.debug((Object)"SSL Socket initiated.");
                this.mySocketUnderCreation = false;
                return sslSocket;
            }
        }
        catch (SecurityException e) {
            this.mySocketUnderCreation = false;
            throw e;
        }
        catch (Exception e) {
            this.mySocketUnderCreation = false;
            throw new IOException("Cannot create connection.");
        }
    }

    boolean isConnected() {
        return this.connected;
    }

    @Override
    public void connect() throws IOException, SecurityException {
        if (this.connected) {
            return;
        }
        int intPort = this.getURL().getPort();
        if (intPort == -1) {
            intPort = 80;
        }
        this.socket = this.createSocket(this.getURL().getHost(), intPort);
        this.socket.setSoTimeout(0);
        this.localIPAddress = this.socket.getLocalAddress().getHostAddress();
        this.connected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        Object object = this.myCloseSocketLock;
        synchronized (object) {
            if (this.socket != null) {
                try {
                    this.closeSocket();
                    this.myCloseSocketLock.wait(5000L);
                }
                catch (InterruptedException e) {
                    this.myLogger.error((Object)"Exception happened while close the socket, when trying to wait 5 seconds for socket close.", (Throwable)e);
                }
                this.connected = false;
            }
        }
    }

    @Override
    public boolean usingProxy() {
        return false;
    }

    private boolean requestUnsecureConnection() {
        if (PoseidonRuntime.getRuntime().getParameters().isDefined("acceptUnsecureConn") || PoseidonRuntime.getRuntime().getParameters().isDefined("usec")) {
            return true;
        }
        for (ConnectionInfoListener connectionInfoListener : this.myConnectionInfoListeners) {
            try {
                return connectionInfoListener.btsRequestUnsecureConnection();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        this.myLogger.error((Object)"No connection info listeners were able to handle unsecure connection request.");
        return true;
    }

    public boolean isSecureConnection() {
        return this.socket instanceof SSLSocket;
    }

    private void creatUnconnectedSocket() {
        Thread runner = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    HttpImpl.this.mySSLSocket = (SSLSocket)HttpImpl.this.mySocketFactory.createSocket();
                    Object object = HttpImpl.this.myCreateSocketLock;
                    synchronized (object) {
                        HttpImpl.this.myCreateSocketLock.notify();
                    }
                }
                catch (Exception e) {
                    HttpImpl.this.myLogger.error((Object)"Exception happened while creating an unconnected socket.", (Throwable)e);
                    HttpImpl.this.mySSLSocket = null;
                }
            }
        };
        runner.start();
    }

    private void closeSocket() {
        Thread runner = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (HttpImpl.this.socket != null) {
                        try {
                            HttpImpl.this.myLogger.debug((Object)"Trying start to close socket. ");
                            HttpImpl.this.socket.close();
                            HttpImpl.this.myLogger.debug((Object)"Socket closed. ");
                        }
                        catch (IOException e) {
                            HttpImpl.this.myLogger.debug((Object)("IOException: " + e));
                        }
                    }
                    Object e = HttpImpl.this.myCloseSocketLock;
                    synchronized (e) {
                        HttpImpl.this.myCloseSocketLock.notify();
                    }
                }
                catch (Exception e) {
                    HttpImpl.this.myLogger.error((Object)"Exception happened while close the socket.", (Throwable)e);
                    HttpImpl.this.socket = null;
                }
            }
        };
        runner.start();
    }

    public boolean isTLSv1RetryNeeded() {
        return this.myTLSv1Retry;
    }

    public void setTLSv1RetryNeeded(boolean isNeed) {
        this.myTLSv1Retry = isNeed;
    }
}

