/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.connection;

import com.nokia.em.bts.rp.master.RPMaster;
import com.nokia.em.poseidon.services.certificate.CertificateMediator;
import com.nokia.em.poseidon.services.certificate.CertificateService;
import com.nokia.em.poseidon.services.certificate.event.ValidateCertificateCancelEvent;
import com.nokia.em.poseidon.services.certificate.event.ValidateCertificateEvent;
import com.nokia.em.poseidon.services.certificate.event.ValidationResponseEvent;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.EventObject;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class SSLTrustManager
implements X509TrustManager,
CertificateMediator {
    private boolean myResponseReceived = false;
    private boolean myWasRejected = false;
    private int myResponse;
    private Logger myLogger = Logger.getLogger(this.getClass());
    private boolean mySSLCertificateValidating = false;
    private ValidateCertificateEvent myCertificateEvent;
    private long CERTIFICATE_TIMEOUT = 27000L;

    protected boolean isSSLCertificateValidating() {
        return this.mySSLCertificateValidating;
    }

    protected boolean wasRejected() {
        return this.myWasRejected;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        CertificateService certificateService = RPMaster.getPoseidonCertificateService();
        if (certificateService == null) {
            this.myLogger.warn((Object)"Certificate service was not initialized, cannot check cert, accepting connection.");
            return;
        }
        certificateService.addMediator((CertificateMediator)this);
        SSLTrustManager sSLTrustManager = this;
        synchronized (sSLTrustManager) {
            this.myLogger.debug((Object)"Certificate validation ongoing.");
            this.mySSLCertificateValidating = true;
            this.myCertificateEvent = new ValidateCertificateEvent((Object)this, x509Certificates, s);
            certificateService.processEvent((EventObject)this.myCertificateEvent);
            if (!this.myResponseReceived) {
                try {
                    this.wait(this.CERTIFICATE_TIMEOUT);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.mySSLCertificateValidating = false;
        }
        certificateService.removeMediator((CertificateMediator)this);
        if (!this.myResponseReceived) {
            this.myLogger.debug((Object)"certificate query timed out");
            this.myWasRejected = true;
            certificateService.processEvent((EventObject)new ValidateCertificateCancelEvent((Object)this));
            throw new CertificateException("Certificate accept timeout.");
        }
        if (this.myResponse == 0) {
            this.myLogger.debug((Object)"Certificate rejected");
            this.myWasRejected = true;
            throw new CertificateException("Certificate was not accepted.");
        }
        if (this.myResponse == 4) {
            this.myLogger.debug((Object)"Certificate timeouted");
            this.myWasRejected = true;
            throw new CertificateException("Certificate timeouted.");
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(EventObject event) {
        if (event instanceof ValidationResponseEvent) {
            SSLTrustManager sSLTrustManager = this;
            synchronized (sSLTrustManager) {
                if (event.getSource() instanceof ValidateCertificateEvent) {
                    if (this.myCertificateEvent != null && event.getSource() == this.myCertificateEvent) {
                        this.certificateValidated(((ValidationResponseEvent)event).getResponse());
                        this.myLogger.trace((Object)("Certificate validated: " + ((ValidationResponseEvent)event).getResponse()));
                    }
                } else {
                    this.certificateValidated(((ValidationResponseEvent)event).getResponse());
                }
            }
        }
    }

    private void certificateValidated(int response) {
        this.myLogger.debug((Object)("Certificate validated: " + response));
        this.myResponse = response;
        this.myResponseReceived = true;
        this.notify();
    }
}

