/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.connection;

import com.nokia.em.bts.rp.master.RPMaster;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.connection.BTSNotificationListener;
import com.nokia.em.bts.rp.master.connection.BTSScenario;
import com.nokia.em.bts.rp.master.connection.ConnectionInfoListener;
import com.nokia.em.bts.rp.master.connection.HandShakeInformation;
import com.nokia.em.bts.rp.master.connection.HandShakeListener;
import com.nokia.em.bts.rp.master.connection.MessageFactory;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferFactory;
import com.nokia.em.bts.rp.master.filetransfer.TempFileStore;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.time.TimeZoneChangeListener;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.poseidon.plugin.service.Service;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SnapshotBTSConnectionImpl
implements BTSConnection,
Service {
    private Vector myHandShakeListeners;
    private boolean myConnected = false;
    private int myBTSId = -1;
    private int mySessionId = -1;
    private Vector myConnectionInfoListeners = new Vector();
    private long myTimeOffset;
    private long myTimeDiff1900Century;
    private boolean myTimeOffsetSet = true;
    private TimeZoneChangeListener myTimeListener;
    private Logger myLogger;
    private TimeZone myTimeZone;

    public SnapshotBTSConnectionImpl() {
    }

    public SnapshotBTSConnectionImpl(TimeZoneChangeListener listener) {
        this();
        this.myTimeListener = listener;
    }

    @Override
    public int getBTSId() {
        return this.myBTSId;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initSnapshotTimeDiff() {
        String activeTestFile = String.valueOf(RPMaster.getSnapshotOpenLocation().getFile()) + RPMaster.FILE_SEPARATOR + "Time" + RPMaster.FILE_SEPARATOR + "Time" + ".txt";
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(activeTestFile))));
                this.myTimeDiff1900Century = Long.parseLong(reader.readLine());
                this.myTimeOffsetSet = Boolean.valueOf(reader.readLine());
                this.myTimeZone = TimeZone.getTimeZone(reader.readLine());
                return;
            }
            catch (FileNotFoundException e) {
                this.myLogger.debug((Object)"Snapshot file not found, use 0.");
                this.myTimeDiff1900Century = 0L;
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (NumberFormatException nfE) {
                this.myLogger.error((Object)"Timediff was not number, cannot set timediff, time could be wrong.", (Throwable)nfE);
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (Exception ex) {
                this.myLogger.error((Object)"Unknown problem in timediff snapshot opening", (Throwable)ex);
                if (reader == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    reader.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void setBTSTimeOffset() {
        CoreAssetThread worker = new CoreAssetThread(){

            @Override
            protected Object construct() {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception e) {
                    SnapshotBTSConnectionImpl.this.myLogger.warn((Object)e);
                }
                if (SnapshotBTSConnectionImpl.this.myTimeListener != null) {
                    if (SnapshotBTSConnectionImpl.this.myTimeOffsetSet) {
                        SnapshotBTSConnectionImpl.this.myTimeListener.timeOffsetResolved(0L);
                    } else {
                        SnapshotBTSConnectionImpl.this.myTimeListener.timeOffsetResolveFailed();
                    }
                    if (SnapshotBTSConnectionImpl.this.myTimeZone != null) {
                        SnapshotBTSConnectionImpl.this.myTimeListener.timeZoneResolved(SnapshotBTSConnectionImpl.this.myTimeZone);
                    }
                }
                return true;
            }
        };
        worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBTSDisconnected() {
        Vector vecListeners;
        SnapshotBTSConnectionImpl snapshotBTSConnectionImpl = this;
        synchronized (snapshotBTSConnectionImpl) {
            vecListeners = (Vector)this.myConnectionInfoListeners.clone();
        }
        int size = vecListeners.size();
        if (size == 0) {
            return;
        }
        int i = 0;
        while (i < size) {
            ConnectionInfoListener connectionListener = (ConnectionInfoListener)vecListeners.elementAt(i);
            connectionListener.btsDisconnected();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBTSConnected() {
        Vector vecListeners;
        this.myTimeOffsetSet = false;
        this.myTimeOffset = 0L;
        SnapshotBTSConnectionImpl snapshotBTSConnectionImpl = this;
        synchronized (snapshotBTSConnectionImpl) {
            vecListeners = (Vector)this.myConnectionInfoListeners.clone();
        }
        int size = vecListeners.size();
        int i = 0;
        while (i < size) {
            ConnectionInfoListener connectionListener = (ConnectionInfoListener)vecListeners.elementAt(i);
            connectionListener.btsConnected();
            ++i;
        }
    }

    private void sendHandShakeInformation(HandShakeInformation information) {
        int intOMMajorVersion = -1;
        int intEMMajorVersion = -1;
        int intOMMinorVersion = -1;
        int intEMMinorVersion = -1;
        int intReason = -1;
        try {
            intOMMajorVersion = Integer.parseInt(information.getInterfaceMajorVersion());
            intEMMajorVersion = Integer.parseInt("1");
            intOMMinorVersion = Integer.parseInt(information.getInterfaceMinorVersion());
            intEMMinorVersion = Integer.parseInt("0");
        }
        catch (NumberFormatException nfe) {
            intReason = 1;
        }
        int i = 0;
        while (i < this.myHandShakeListeners.size()) {
            HandShakeListener someListener = (HandShakeListener)this.myHandShakeListeners.elementAt(i);
            if (!information.isInterfaceKnown()) {
                someListener.interfaceUnknown(2);
            } else if (intReason == 1) {
                someListener.interfaceUnknown(1);
            } else if (intOMMinorVersion != intEMMinorVersion) {
                if (intOMMajorVersion != intEMMajorVersion) {
                    someListener.interfaceMajorVersionMismatch(intOMMajorVersion, intEMMajorVersion);
                } else {
                    someListener.interfaceMinorVersionMismatch(intOMMinorVersion, intEMMinorVersion);
                }
            } else if (intOMMajorVersion != intEMMajorVersion) {
                someListener.interfaceMajorVersionMismatch(intOMMajorVersion, intEMMajorVersion);
            }
            someListener.authorisationRequired(information.isAuthorisationRequired());
            ++i;
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public void setBTSId(int intBTSId) {
        this.myBTSId = intBTSId;
    }

    @Override
    public void setSessionId(int sessionId) {
        this.mySessionId = sessionId;
    }

    @Override
    public int getSessionId() {
        return this.mySessionId;
    }

    @Override
    public final void addHandShakeListener(HandShakeListener listener) {
        if (this.myHandShakeListeners.contains(listener) || listener == null) {
            return;
        }
        this.myHandShakeListeners.addElement(listener);
    }

    @Override
    public final void removeHandShakeListener(HandShakeListener listener) {
        if (this.myHandShakeListeners.contains(listener) && listener != null) {
            this.myHandShakeListeners.removeElement(listener);
        }
    }

    @Override
    public final long getTimeOffset() {
        return this.myTimeOffset;
    }

    @Override
    public final long getTimeDiff1900Century() {
        return this.myTimeDiff1900Century;
    }

    @Override
    public final boolean isTimeOffsetSet() {
        return this.myTimeOffsetSet;
    }

    @Override
    public boolean sendToBTS(BTSMessage btsMessage) {
        this.myLogger.error((Object)("Cannot send in Snapshot opening mode " + btsMessage.getClass()));
        return true;
    }

    @Override
    public BTSMessage receiveFromBTS(int intSeqNbr) {
        this.myLogger.error((Object)"Cannot receive in Snapshot opening mode.");
        return null;
    }

    @Override
    public BTSMessage receiveFromBTS(int intSeqNbr, long timeout) {
        this.myLogger.error((Object)"Cannot receive in Snapshot opening mode.");
        return null;
    }

    @Override
    public void addMessageFactory(MessageFactory mf) {
    }

    @Override
    public int createScenario() {
        return 0;
    }

    @Override
    public void createScenario(int intSeqNbr) {
    }

    @Override
    public int createScenario(boolean blnKeepAlive) {
        return 0;
    }

    @Override
    public void createScenario(int intSeqNbr, boolean blnKeepAlive) {
    }

    @Override
    public void deleteScenario(int intSeqNbr) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        SnapshotBTSConnectionImpl snapshotBTSConnectionImpl = this;
        synchronized (snapshotBTSConnectionImpl) {
            this.myConnected = false;
            this.notify();
        }
    }

    @Override
    public void deleteTempFiles(long maximumWaitingTime) {
        if (maximumWaitingTime < 1L) {
            TempFileStore.getInstance().deleteTempFiles(4000L);
        } else {
            TempFileStore.getInstance().deleteTempFiles(maximumWaitingTime);
        }
    }

    public void setAuthEnableBlockOn() {
    }

    public void setAuthEnableBlockOff() {
    }

    @Override
    public void reEstablishConnection() {
        this.sendBTSConnected();
    }

    @Override
    public void subscribeNotification(BTSNotificationListener btsNotificationListener) {
    }

    @Override
    public void unsubscribeNotification(BTSNotificationListener btsNotificationListener) {
    }

    @Override
    public final boolean isBTSConnected() {
        return this.myConnected;
    }

    @Override
    public String getLocalIPAddress() {
        return "127.0.0.1";
    }

    @Override
    public void interruptScenario(int seqNbr) {
    }

    @Override
    public BTSScenario getScenario(int seqNbr) {
        return new BTSScenario(0, false);
    }

    @Override
    public void connect(String strIPAddress, int intPort) {
        CoreAssetThread receiverWorker = new CoreAssetThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Object construct() {
                try {
                    final HandShakeInformation handShakeInformation = new HandShakeInformation();
                    handShakeInformation.setAuthorisationRequired(false);
                    handShakeInformation.setInterfaceMajorVersion("1");
                    handShakeInformation.setInterfaceMinorVersion("0");
                    SnapshotBTSConnectionImpl.this.myConnected = true;
                    SnapshotBTSConnectionImpl.this.myLogger.debug((Object)"connection created.");
                    CoreAssetThread worker1 = new CoreAssetThread(){

                        @Override
                        protected Object construct() {
                            SnapshotBTSConnectionImpl.this.setBTSTimeOffset();
                            SnapshotBTSConnectionImpl.this.sendHandShakeInformation(handShakeInformation);
                            SnapshotBTSConnectionImpl.this.sendBTSConnected();
                            return null;
                        }
                    };
                    worker1.start();
                    2 var3_4 = this;
                    synchronized (var3_4) {
                        try {
                            while (SnapshotBTSConnectionImpl.this.myConnected) {
                                ((Object)((Object)this)).wait();
                            }
                        }
                        catch (Exception ex) {
                            SnapshotBTSConnectionImpl.this.myLogger.debug((Object)"connection wait terminated.", (Throwable)ex);
                        }
                    }
                    SnapshotBTSConnectionImpl.this.myLogger.debug((Object)"connection wait notified.");
                }
                catch (Exception e) {
                    SnapshotBTSConnectionImpl.this.myConnected = false;
                    SnapshotBTSConnectionImpl.this.myLogger.error((Object)"connection not created", (Throwable)e);
                    SnapshotBTSConnectionImpl.this.reEstablishConnection();
                }
                return true;
            }

            @Override
            protected void finished() {
                if (SnapshotBTSConnectionImpl.this.isBTSConnected()) {
                    SnapshotBTSConnectionImpl.this.deleteTempFiles(4000L);
                    SnapshotBTSConnectionImpl.this.myLogger.debug((Object)"(in finished) connection terminated.");
                    SnapshotBTSConnectionImpl.this.myLogger.debug((Object)"(in finished) removing active snapshot savers.");
                    RPMaster.removeAllSnapshotSavers();
                    SnapshotBTSConnectionImpl.this.sendBTSDisconnected();
                    SnapshotBTSConnectionImpl.this.myConnected = false;
                }
            }
        };
        receiverWorker.start();
    }

    @Override
    public void addConnectionInfoListener(ConnectionInfoListener listener) {
        if (this.myConnectionInfoListeners.contains(listener) || listener == null) {
            return;
        }
        this.myConnectionInfoListeners.addElement(listener);
        if (this.isBTSConnected()) {
            listener.btsConnected();
        } else {
            listener.btsDisconnected();
        }
    }

    @Override
    public void removeConnectionInfoListener(ConnectionInfoListener listener) {
        if (listener == null) {
            return;
        }
        if (this.myConnectionInfoListeners.contains(listener)) {
            this.myConnectionInfoListeners.removeElement(listener);
        }
    }

    public void endSession() {
    }

    @Override
    public void addTimeZoneChangeListener(TimeZoneChangeListener listener) {
        this.myTimeListener = listener;
    }

    public void start() {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnectionInfoListeners = new Vector();
        this.myHandShakeListeners = new Vector();
        this.initSnapshotTimeDiff();
    }

    public void stop() {
    }

    @Override
    public FileTransferFactory getFileTransferFactory() {
        return null;
    }

    @Override
    public boolean isNtpTimeExpected() {
        return true;
    }

    @Override
    public boolean isSecureConnection() {
        return true;
    }

    @Override
    public void setWriteAccess(boolean writeAccess) {
    }

    @Override
    public boolean hasWriteAccess() {
        return true;
    }

    @Override
    public void clearPreviousResponse(int seqNbr) {
    }
}

