/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.filetransfer;

import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferAdapter;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferClient;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferException;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.poseidon.comm.ftp.FtpClient;
import com.nokia.em.poseidon.comm.ftp.FtpException;
import com.nokia.em.poseidon.comm.ftp.FtpReply;
import com.nokia.em.poseidon.comm.http.Tools;
import com.nokia.em.poseidon.util.concurrency.CachedThread;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.log4j.Logger;

public class FTPClientAdapter
implements FileTransferClient {
    private static final int DEFAULT_PORT = 21;
    private static int CUSTOM_PORT = -1;
    private FileTransferListener myFileTransferListener;
    private FTPTransferInfo myFtpTransferInfo;
    private String myFilePath;
    private FtpClient myFtpClient;
    private String myLocalFile;
    private Logger myLogger = Logger.getLogger(this.getClass());

    public FTPClientAdapter(FTPTransferInfo transferInfo) {
        this();
        this.myFtpTransferInfo = transferInfo;
    }

    public FTPClientAdapter() {
    }

    @Override
    public void setFTPTransferInfo(FTPTransferInfo ftpTransferInfo) {
        this.myFtpTransferInfo = ftpTransferInfo;
    }

    @Override
    public void setFilePath(String filePath) {
        this.myFilePath = filePath;
    }

    public File getFile(String localFile) throws FileTransferException {
        return this.transfer(new File(localFile), new FileTransferAdapter());
    }

    @Override
    public File getFile(FileTransferListener listener) throws FileTransferException {
        FileTransferListener l = listener;
        if (l == null) {
            l = new FileTransferAdapter();
        }
        try {
            File tempFile;
            if (this.myFilePath == null) {
                tempFile = File.createTempFile("ftm", null);
                tempFile.deleteOnExit();
            } else {
                tempFile = new File(this.myFilePath);
            }
            return this.transfer(tempFile, l);
        }
        catch (IOException ioE) {
            throw new FileTransferException("Cannot create temp file.");
        }
    }

    @Override
    public File getFile() throws FileTransferException {
        try {
            File tempFile = File.createTempFile("ftm", null);
            tempFile.deleteOnExit();
            return this.transfer(tempFile, new FileTransferAdapter());
        }
        catch (IOException ioE) {
            throw new FileTransferException("Cannot create temp file.");
        }
    }

    public File getFile(String localFile, FileTransferListener listener) throws FileTransferException {
        FileTransferListener l = listener;
        if (l == null) {
            l = new FileTransferAdapter();
        }
        return this.transfer(new File(localFile), l);
    }

    @Override
    public void abort() {
        CachedThread thread = new CachedThread(){

            public void run() {
                try {
                    FTPClientAdapter.this.myLogger.debug((Object)"FTP Disconnecting.");
                    FTPClientAdapter.this.myFtpClient.disconnect();
                }
                catch (Throwable e) {
                    FTPClientAdapter.this.myLogger.debug((Object)"FTP Disconnect failed.", e);
                }
            }
        };
        thread.start();
    }

    public void connect() throws FtpException {
        this.myFtpClient = new FtpClient();
        if (CUSTOM_PORT > -1) {
            this.myFtpClient.connect(this.myFtpTransferInfo.getServerAddress(), CUSTOM_PORT);
        } else {
            this.myFtpClient.connect(this.myFtpTransferInfo.getServerAddress(), 21);
        }
        this.myFtpClient.login(this.myFtpTransferInfo.getUserName(), new String(this.myFtpTransferInfo.getPassword()));
    }

    public Collection list(String path) throws FtpException {
        return this.myFtpClient.getFileList(path, null, null);
    }

    public File[] getFiles(String[] fileIds, FileTransferListener ftpListener) throws FileTransferException, IOException {
        this.myFileTransferListener = ftpListener != null ? ftpListener : new FileTransferAdapter();
        File[] files = new File[fileIds.length];
        this.myFileTransferListener.fileSetTransferStarted();
        this.myFtpClient = new FtpClient();
        try {
            if (CUSTOM_PORT > -1) {
                this.myFtpClient.connect(this.myFtpTransferInfo.getServerAddress(), CUSTOM_PORT);
            } else {
                this.myFtpClient.connect(this.myFtpTransferInfo.getServerAddress(), 21);
            }
        }
        catch (FtpException e) {
            throw new FileTransferException("Cannot connect to server.");
        }
        try {
            this.myFtpClient.login(this.myFtpTransferInfo.getUserName(), new String(this.myFtpTransferInfo.getPassword()));
        }
        catch (FtpException e) {
            throw new FileTransferException("Invalid username or password.");
        }
        int i = 0;
        while (i < fileIds.length) {
            files[i] = File.createTempFile("ftm", null);
            files[i].deleteOnExit();
            this.myLocalFile = files[i].getAbsolutePath();
            FtpReply reply = null;
            try {
                this.myFtpClient.setTransferType("I");
                reply = this.myFtpClient.getFile(fileIds[i], files[i].getAbsolutePath());
                this.myLogger.debug((Object)("Get file replied " + reply));
            }
            catch (FtpException e) {
                throw new FileTransferException("Failed to get file", e);
            }
            if (reply == null) {
                this.myLogger.error((Object)"Get file failed with null reply");
                files[i] = null;
                this.myFileTransferListener.fileTransferFailed(fileIds[i]);
            } else if (!reply.getCode().equals("226")) {
                this.myLogger.error((Object)("Get file failed with reply " + reply.getCode() + ": " + reply.getMessage()));
                files[i] = null;
                this.myFileTransferListener.fileTransferFailed(fileIds[i]);
            }
            this.myFileTransferListener.fileTransferSucceeded(this.myLocalFile);
            ++i;
        }
        try {
            this.disconnect();
        }
        catch (FtpException ftpException) {
            // empty catch block
        }
        this.myFileTransferListener.fileSetTransferCompleted(null);
        return files;
    }

    public void disconnect() throws FtpException {
        this.myFtpClient.disconnect();
    }

    public static void setCustomPort(int customPort) {
        CUSTOM_PORT = customPort;
    }

    private synchronized File transfer(File localFile, FileTransferListener listener) throws FileTransferException {
        if (this.myFtpTransferInfo == null) {
            throw new FileTransferException("FTPTransferInfo not defined.");
        }
        FtpReply reply = null;
        this.myLocalFile = localFile.getAbsolutePath();
        this.myFileTransferListener = listener;
        this.myFtpClient = new FtpClient();
        try {
            String address = this.myFtpTransferInfo.getServerAddress();
            int port = Tools.getTransferPort((String)address, (int)21);
            address = Tools.getTransferIPAddress((String)address);
            this.myFtpClient.connect(address, port);
        }
        catch (FtpException e) {
            throw new FileTransferException("Cannot connect to server: ", e);
        }
        try {
            this.myFtpClient.login(this.myFtpTransferInfo.getUserName(), new String(this.myFtpTransferInfo.getPassword()));
        }
        catch (FtpException e) {
            throw new FileTransferException("Invalid username or password.", e);
        }
        this.myFileTransferListener.fileTransferStarted(this.myFtpTransferInfo.getFileId(), localFile.length());
        try {
            this.myFtpClient.setTransferType("I");
            reply = this.myFtpClient.getFile(this.myFtpTransferInfo.getFileId(), localFile.getAbsolutePath());
            this.myLogger.debug((Object)("Get file replied " + reply));
        }
        catch (FtpException e) {
            throw new FileTransferException("Failed to get file", e, Integer.parseInt(e.getReplyCode()));
        }
        try {
            this.myFtpClient.disconnect();
        }
        catch (FtpException ftpException) {
            // empty catch block
        }
        if (reply == null) {
            throw new FileTransferException("null reply");
        }
        if (!reply.getCode().equals("226")) {
            throw new FileTransferException(String.valueOf(reply.getCode()) + ": " + reply.getMessage());
        }
        this.myFileTransferListener.fileTransferSucceeded(this.myLocalFile);
        return localFile;
    }
}

