/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.filetransfer;

import com.nokia.em.bts.rp.master.RPMaster;
import com.nokia.em.bts.rp.master.filetransfer.FTPSessionAdapter;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferAdapter;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferException;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferServer;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.poseidon.comm.common.TransferListener;
import com.nokia.em.poseidon.comm.ftp.FtpException;
import com.nokia.em.poseidon.comm.ftp.FtpServer;
import com.nokia.em.poseidon.comm.ftp.PortRange;
import com.nokia.em.poseidon.comm.ftp.ServerConfiguration;
import com.nokia.em.poseidon.comm.ftp.ServerListener;
import com.nokia.em.poseidon.comm.ftp.ServerSession;
import com.nokia.em.poseidon.comm.ftp.UserProfile;
import com.nokia.em.poseidon.util.security.UserCredentials;
import com.nokia.em.poseidon.util.security.UserCredentialsFactory;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class FTPServerAdapter
implements ServerListener,
FileTransferServer {
    public static final int DEFAULT_PORT = 21;
    private static final int DEFAULT_PROGRESS_INTERVAL = 500;
    private FileTransferListener myListener;
    private final String myUserName;
    private final String myPassword;
    private FtpServer myFTPServer;
    private FTPSessionAdapter mySessionAdapter;
    private String myPath;
    private Logger myLogger;

    public FTPServerAdapter(FileTransferListener listener, String path, String userName, String password) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myPath = path;
        this.myListener = listener;
        this.myUserName = userName;
        this.myPassword = password;
    }

    public FTPServerAdapter() {
        this.myLogger = Logger.getLogger(this.getClass());
        UserCredentialsFactory generator = UserCredentialsFactory.getInstance();
        UserCredentials userCredentials = generator.generateTemporaryAccount();
        this.myUserName = userCredentials.getName();
        this.myPassword = userCredentials.getPassword();
    }

    public FTPServerAdapter(FileTransferListener listener, String path) {
        this.myPath = path;
        this.myLogger = Logger.getLogger(this.getClass());
        this.myLogger.debug((Object)this.getClass().toString());
        this.myListener = listener == null ? new FileTransferAdapter() : listener;
        UserCredentialsFactory generator = UserCredentialsFactory.getInstance();
        UserCredentials userCredentials = generator.generateTemporaryAccount();
        this.myUserName = userCredentials.getName();
        this.myPassword = userCredentials.getPassword();
    }

    @Override
    public void initListenerAndPath(FileTransferListener listener, String path) {
        this.myListener = listener == null ? new FileTransferAdapter() : listener;
        this.myPath = path;
    }

    public int startFTPServer() throws FileTransferException {
        this.myLogger.debug((Object)"FTP Server starting.");
        this.myFTPServer = new FtpServer();
        this.myFTPServer.addServerListener((ServerListener)this);
        PortRange portRange = RPMaster.getFTPServerPortRange();
        ServerConfiguration configuration = this.myFTPServer.getServerConfiguration();
        configuration.setProgressInterval(500);
        if (portRange != null) {
            configuration.setServerPortRange(portRange);
        }
        UserProfile user = configuration.createUser(this.myUserName, this.myPassword, this.myPath);
        user.createAccessRight(this.myPath, true, false);
        try {
            this.myFTPServer.start();
        }
        catch (FtpException e) {
            this.myLogger.debug((Object)"Cannot open ftp port, retrying other ports.");
            configuration.setServerPortRange(new PortRange(13062, 13092));
            try {
                this.myFTPServer.start();
            }
            catch (FtpException ftpException) {
                this.myLogger.error((Object)"Cannot open ftp to range.", (Throwable)ftpException);
                throw new FileTransferException("Cannot open ftp server.");
            }
        }
        return this.myFTPServer.getServerConfiguration().getServerPort();
    }

    public void stopFTPServer() {
        this.myLogger.debug((Object)"Stopping Poseidon FTP Server.");
        if (this.myFTPServer != null && this.myFTPServer.isRunning()) {
            ServerConfiguration configuration = this.myFTPServer.getServerConfiguration();
            configuration.deleteUser(this.myUserName);
            final Collection sessions = this.myFTPServer.getSession(this.myUserName);
            CoreAssetThread worker = new CoreAssetThread(){

                @Override
                protected Object construct() {
                    Iterator iterator = sessions.iterator();
                    while (iterator.hasNext()) {
                        try {
                            ServerSession session = (ServerSession)iterator.next();
                            session.removeTransferListener((TransferListener)FTPServerAdapter.this.mySessionAdapter);
                            session.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return true;
                }
            };
            worker.start();
            this.myFTPServer.stop();
            this.myFTPServer.removeServerListener((ServerListener)this);
        }
    }

    @Override
    public String getUserName() {
        return this.myUserName;
    }

    @Override
    public String getPassword() {
        return this.myPassword;
    }

    public char[] getPasswordCharacters() {
        return this.myPassword.toCharArray();
    }

    @Override
    public int startServer() throws FileTransferException {
        return this.startFTPServer();
    }

    @Override
    public void stopServer() {
        this.stopFTPServer();
    }

    public void userLoggedIn(ServerSession session) {
        this.myLogger.debug((Object)("User " + session.getUser().getUserName() + " logged in."));
        if (session.getUser().getUserName().equals(this.myUserName)) {
            this.mySessionAdapter = new FTPSessionAdapter(this.myListener, this.myUserName, new File(this.myPath));
            session.addTransferListener((TransferListener)this.mySessionAdapter);
        }
    }

    public void userLoggedOut(UserProfile user, InetSocketAddress address) {
        this.myLogger.debug((Object)("User " + user.getUserName() + " logged out."));
    }

    public void serverStarted() {
        this.myLogger.debug((Object)"FTP Server is started.");
    }

    public void serverStopped() {
        this.myLogger.debug((Object)"FTP Server is stopped.");
    }
}

