/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.filetransfer;

import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.filetransfer.RelativePathResolver;
import com.nokia.em.poseidon.comm.common.TransferInfo;
import com.nokia.em.poseidon.comm.common.TransferListener;
import java.io.File;
import org.apache.log4j.Logger;

public class FTPSessionAdapter
implements TransferListener {
    private FileTransferListener myFileTransferListener;
    private String myUserName;
    private boolean started;
    private File myRootFolder = null;
    private Logger myLogger = Logger.getLogger(this.getClass());

    protected FTPSessionAdapter(FileTransferListener listener, String userName, File rootFolder) {
        this.myFileTransferListener = listener;
        this.myUserName = userName;
        this.started = false;
        this.myRootFolder = rootFolder;
    }

    public void transferUpdated(TransferInfo transferInfo) {
        String fileName = RelativePathResolver.resolveRelativePath(this.myRootFolder, transferInfo.getFile());
        if (transferInfo.getTransferStatus().equals((Object)TransferInfo.TransferStatus.TRANSFER_ONGOING)) {
            if (transferInfo.getUserName().equals(this.myUserName)) {
                Double percentage = transferInfo.getTransferPercentage();
                if (!this.started) {
                    this.myLogger.debug((Object)("User " + this.myUserName + " started transferring file " + fileName));
                    this.myFileTransferListener.fileTransferStarted(fileName, transferInfo.getContentLength());
                    this.started = true;
                } else {
                    this.myFileTransferListener.fileTransferUpdated(fileName, percentage.floatValue() * 100.0f);
                }
            }
        } else if (transferInfo.getTransferStatus().equals((Object)TransferInfo.TransferStatus.TRANSFER_COMPLETED) && transferInfo.getUserName().equals(this.myUserName)) {
            this.started = false;
            if (transferInfo.getContentLength() < 1L) {
                this.myLogger.debug((Object)("User " + this.myUserName + " transferring file " + fileName + " failed, file does not exist."));
                this.myFileTransferListener.fileTransferFailed(fileName);
            } else if (transferInfo.getTransferPercentage() < 1.0) {
                this.myLogger.debug((Object)("User " + this.myUserName + " transferring file " + fileName + " failed."));
                this.myFileTransferListener.fileTransferFailed(fileName);
            } else {
                this.myLogger.debug((Object)("User " + this.myUserName + " completed transferring file " + fileName));
                this.myFileTransferListener.fileTransferSucceeded(fileName);
            }
        }
    }
}

