/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.filetransfer;

public class FTPTransferInfo {
    private String myFileId;
    private String myServerAddress;
    private String myUsername;
    private char[] myPassword;

    public FTPTransferInfo(String strFileId, String strServerAddress, String strUsername, char[] password) {
        this.myFileId = strFileId;
        this.myServerAddress = this.formatIPv6Address(strServerAddress);
        this.myUsername = strUsername;
        this.myPassword = password == null ? new char[0] : password;
    }

    public FTPTransferInfo() {
        this("Coreasset_Unknown", "Coreasset_Unknown", "Coreasset_Unknown", "Coreasset_Unknown".toCharArray());
    }

    private String formatIPv6Address(String ipv6) {
        if (ipv6 != null && ipv6.matches("([0-9a-fA-F]{1,4}:){8}[0-9]{1,5}")) {
            int port = ipv6.lastIndexOf(":");
            return "[" + ipv6.substring(0, port) + "]" + ipv6.substring(port);
        }
        return ipv6;
    }

    public final String getFileId() {
        return this.myFileId;
    }

    public final String getServerAddress() {
        return this.myServerAddress;
    }

    public final String getUserName() {
        return this.myUsername;
    }

    public final char[] getPassword() {
        return this.myPassword;
    }

    public final void setFileName(String strFileName) {
        this.myFileId = strFileName;
    }

    public final void setServerAddress(String strServerAddress) {
        this.myServerAddress = this.formatIPv6Address(strServerAddress);
    }

    public final void setUserName(String strUsername) {
        this.myUsername = strUsername;
    }

    public final void setPassword(char[] password) {
        this.myPassword = password == null ? new char[0] : password;
    }
}

