/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.filetransfer;

import com.nokia.em.bts.rp.master.RPMaster;
import com.nokia.em.bts.rp.master.filetransfer.FTPClientAdapter;
import com.nokia.em.bts.rp.master.filetransfer.FTPServerAdapter;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferClient;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferServer;
import com.nokia.em.bts.rp.master.filetransfer.HTTPClientAdapter;
import com.nokia.em.bts.rp.master.filetransfer.HTTPServerAdapter;

public class FileTransferFactory {
    private static final String DEFAULT_PROTOCOL = "FTP";
    private static String[] protocols = new String[]{"FTP", "HTTP", "HTTPS"};
    private String myUsedProtocol;
    private Object lockObject = new Object();

    public static String[] getSupportedProtocols() {
        return protocols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUsedProtocol(String p) {
        Object object = this.lockObject;
        synchronized (object) {
            String protocol = p;
            if (protocol == null) {
                protocol = DEFAULT_PROTOCOL;
            }
            this.myUsedProtocol = protocol.trim();
            this.lockObject.notifyAll();
        }
    }

    public FileTransferClient getFileTransferClient() {
        this.checkProtocol();
        if (this.myUsedProtocol == null) {
            return new FTPClientAdapter();
        }
        if (DEFAULT_PROTOCOL.equalsIgnoreCase(this.myUsedProtocol)) {
            return new FTPClientAdapter();
        }
        if ("HTTP".equalsIgnoreCase(this.myUsedProtocol)) {
            return new HTTPClientAdapter(false);
        }
        if ("HTTPS".equalsIgnoreCase(this.myUsedProtocol)) {
            return new HTTPClientAdapter(true);
        }
        return new FTPClientAdapter();
    }

    public FileTransferServer getFileTransferServer() {
        this.checkProtocol();
        if (this.myUsedProtocol == null) {
            return new FTPServerAdapter();
        }
        if (DEFAULT_PROTOCOL.equalsIgnoreCase(this.myUsedProtocol)) {
            return new FTPServerAdapter();
        }
        if ("HTTP".equalsIgnoreCase(this.myUsedProtocol)) {
            return new HTTPServerAdapter(false);
        }
        if ("HTTPS".equalsIgnoreCase(this.myUsedProtocol)) {
            return new HTTPServerAdapter(true);
        }
        return new FTPServerAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkProtocol() {
        if (RPMaster.getNeedsQueryFileTransferProtocol() && this.myUsedProtocol == null) {
            Object object = this.lockObject;
            synchronized (object) {
                try {
                    this.lockObject.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.myUsedProtocol == null) {
                    this.myUsedProtocol = DEFAULT_PROTOCOL;
                }
            }
        }
    }
}

