/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.filetransfer;

import com.nokia.em.bts.rp.master.connection.SSLTrustManager;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferAdapter;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferClient;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferException;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.comm.common.TransferInfo;
import com.nokia.em.poseidon.comm.common.TransferListener;
import com.nokia.em.poseidon.comm.http.HttpConstants;
import com.nokia.em.poseidon.comm.http.Tools;
import com.nokia.em.poseidon.comm.http.client.HttpClient;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class HTTPClientAdapter
implements FileTransferClient,
TransferListener {
    private final boolean myIsSecure;
    private FTPTransferInfo myFTPTransferInfo;
    private FileTransferListener myFileTransferListener;
    private boolean myIsReady = false;
    private File myTransferredFile;
    private boolean myStarted = false;
    private String myFilePath;
    private boolean myHasFileTransferError;
    private Throwable myThrowableError;
    private int myHttpErrorResponseCode;

    public HTTPClientAdapter(boolean isSecure) {
        this.myIsSecure = isSecure;
    }

    @Override
    public void setFTPTransferInfo(FTPTransferInfo fileTransferInfo) {
        String siteemPort = (String)PoseidonRuntime.getRuntime().getRuntimeProperty("siteemport");
        if ("6011".equals(siteemPort)) {
            String ip = (String)PoseidonRuntime.getRuntime().getRuntimeProperty("XoHIP");
            if (Tools.isIpv6Address((String)ip)) {
                ip = "[" + ip + "]";
            }
            fileTransferInfo.setServerAddress(String.valueOf(ip) + ":" + siteemPort);
        }
        this.myFTPTransferInfo = fileTransferInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File getFile(FileTransferListener listener) throws FileTransferException {
        this.myHasFileTransferError = false;
        if (this.myFTPTransferInfo == null || this.myFTPTransferInfo.getFileId() == null || this.myFTPTransferInfo.getServerAddress() == null) {
            throw new FileTransferException("FTP transfer info not set.");
        }
        this.myFileTransferListener = listener;
        String a = this.myFTPTransferInfo.getServerAddress();
        String host = Tools.getTransferIPAddress((String)a);
        HttpClient httpClient = new HttpClient(host, Tools.getTransferPort((String)a, (int)(this.myIsSecure ? 6001 : 6000)));
        httpClient.addFileTransferListener((TransferListener)this);
        httpClient.setClientDirectory(System.getProperty("java.io.tmpdir"));
        httpClient.setUserName(this.myFTPTransferInfo.getUserName());
        httpClient.setPassword(new String(this.myFTPTransferInfo.getPassword()));
        httpClient.setAuthentication(HttpConstants.Authentication.AUTHENTICATION_BASIC);
        httpClient.setSecure(this.myIsSecure);
        BufferedInputStream in = new BufferedInputStream(ClassLoader.getSystemResourceAsStream("FileTransfer.jks"));
        File f = null;
        try {
            f = File.createTempFile("tmp", "tmp");
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            while (true) {
                int c;
                if ((c = in.read()) < 0) {
                    in.close();
                    out.close();
                    break;
                }
                out.write(c);
            }
        }
        catch (Exception e2) {
            Logger.getLogger(this.getClass()).error((Object)"Failed to write FileTransfer.jks to temp file", (Throwable)e2);
        }
        if (f != null) {
            httpClient.setTrustStoreFile(f.getAbsolutePath());
        }
        String s = "fv3c09nm5yq";
        httpClient.setTrustStorePassword(s.toCharArray());
        httpClient.setTrustManager((X509TrustManager)new SSLTrustManager());
        try {
            File localFile;
            if (this.myFilePath == null) {
                localFile = File.createTempFile("tmp", "tmp");
                localFile.deleteOnExit();
            } else {
                localFile = new File(this.myFilePath);
                httpClient.setClientDirectory(localFile.getParent());
            }
            httpClient.getFile(this.myFTPTransferInfo.getFileId(), localFile.getName());
            HTTPClientAdapter hTTPClientAdapter = this;
            synchronized (hTTPClientAdapter) {
                while (!this.myIsReady) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)"Failed to get file", (Throwable)e);
        }
        if (f != null && !f.delete()) {
            f.deleteOnExit();
        }
        if (this.myHasFileTransferError) {
            throw new FileTransferException("Cannot transfer file: " + this.myHttpErrorResponseCode, this.myThrowableError, this.myHttpErrorResponseCode);
        }
        return this.myTransferredFile;
    }

    @Override
    public File getFile() throws FileTransferException {
        return this.getFile(new FileTransferAdapter());
    }

    @Override
    public void abort() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferUpdated(TransferInfo transferInfo) {
        String absolutePath;
        Object response = transferInfo.getProtocolResponseCode();
        this.myHttpErrorResponseCode = response != null ? (Integer)response : 0;
        File file = transferInfo.getFile();
        TransferInfo.TransferStatus transferStatus = transferInfo.getTransferStatus();
        String string = absolutePath = file != null ? file.getAbsolutePath() : "no file";
        if (this.myHttpErrorResponseCode == 200 && !this.myStarted) {
            this.myFileTransferListener.fileTransferStarted(absolutePath, transferInfo.getContentLength());
            this.myStarted = true;
        } else if (TransferInfo.TransferStatus.TRANSFER_COMPLETED.equals((Object)transferStatus)) {
            this.myTransferredFile = file;
            HTTPClientAdapter hTTPClientAdapter = this;
            synchronized (hTTPClientAdapter) {
                this.myIsReady = true;
                this.notifyAll();
            }
            this.myFileTransferListener.fileTransferSucceeded(absolutePath);
        } else if (TransferInfo.TransferStatus.TRANSFER_ONGOING.equals((Object)transferStatus)) {
            this.myFileTransferListener.fileTransferUpdated(absolutePath, (float)(100.0 * transferInfo.getTransferPercentage()));
        } else {
            HTTPClientAdapter hTTPClientAdapter = this;
            synchronized (hTTPClientAdapter) {
                this.myIsReady = true;
                this.myFileTransferListener.fileTransferFailed(absolutePath);
                this.notifyAll();
            }
            if (TransferInfo.TransferStatus.TRANSFER_ERROR.equals((Object)transferStatus)) {
                Object error = transferInfo.getErrorData();
                if (error != null && error instanceof Throwable) {
                    this.myThrowableError = (Throwable)error;
                }
                this.myHasFileTransferError = true;
            }
        }
    }

    @Override
    public void setFilePath(String filePath) {
        this.myFilePath = filePath;
    }
}

