/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.filetransfer;

import com.nokia.em.bts.rp.master.RPMaster;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferException;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferServer;
import com.nokia.em.bts.rp.master.filetransfer.RelativePathResolver;
import com.nokia.em.poseidon.comm.common.TransferInfo;
import com.nokia.em.poseidon.comm.common.TransferListener;
import com.nokia.em.poseidon.comm.ftp.PortRange;
import com.nokia.em.poseidon.comm.http.HttpConstants;
import com.nokia.em.poseidon.comm.http.Tools;
import com.nokia.em.poseidon.comm.http.server.EndPoint;
import com.nokia.em.poseidon.comm.http.server.Handler;
import com.nokia.em.poseidon.comm.http.server.HttpServer;
import com.nokia.em.poseidon.comm.http.server.HttpServerFactory;
import com.nokia.em.poseidon.comm.http.server.SSLServerSocketEndPoint;
import com.nokia.em.poseidon.util.security.UserCredentials;
import com.nokia.em.poseidon.util.security.UserCredentialsFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;
import org.apache.log4j.Logger;

public class HTTPServerAdapter
implements FileTransferServer,
TransferListener {
    private final String myUserName;
    private final String myPassword;
    private HttpServer myHttpServer;
    private final boolean myIsSecure;
    private FileTransferListener myFileTransferListener;
    private Logger myLogger = Logger.getLogger(this.getClass());
    private File myRootFolder = null;
    private static final String[] DEFAULT_SUPPORTED_CIPHER_SUITES = new String[]{"TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_RC4_128_SHA"};

    public HTTPServerAdapter(boolean isSecure) {
        UserCredentialsFactory generator = UserCredentialsFactory.getInstance();
        UserCredentials userCredentials = generator.generateTemporaryAccount();
        this.myUserName = userCredentials.getName();
        this.myPassword = userCredentials.getPassword();
        this.myIsSecure = isSecure;
    }

    @Override
    public int startServer() throws FileTransferException {
        for (Handler handler : this.myHttpServer.getHandlers()) {
            handler.addFileTransferListener((TransferListener)this);
        }
        for (EndPoint endPoint : this.myHttpServer.getEndPoints().values()) {
            if (!(endPoint instanceof SSLServerSocketEndPoint)) continue;
            ((SSLServerSocketEndPoint)endPoint).setEnabledCipherSuites(Tools.getSupportedCipherSuites((String[])DEFAULT_SUPPORTED_CIPHER_SUITES));
        }
        this.myLogger.debug((Object)"Starting HTTP server...");
        this.myHttpServer.start();
        this.myLogger.debug((Object)"HTTP Server started.");
        Map m = this.myHttpServer.getEndPoints();
        try {
            this.myLogger.debug((Object)"Getting port from server endpoints...");
            int port = ((EndPoint)m.values().iterator().next()).getPort();
            this.myLogger.debug((Object)("Got port: " + port));
            return port;
        }
        catch (Exception e) {
            this.myLogger.error((Object)"Failed to get port from server endpoint", (Throwable)e);
            throw new FileTransferException("HTTP server not configured correctly, " + e.getMessage());
        }
    }

    @Override
    public void stopServer() {
        this.myLogger.trace((Object)"Stopping HTTP server");
        for (Handler handler : this.myHttpServer.getHandlers()) {
            handler.removeFileTransferListener((TransferListener)this);
        }
        this.myHttpServer.stop();
        this.myLogger.trace((Object)"HTTP server stopped");
    }

    @Override
    public void initListenerAndPath(FileTransferListener listener, String path) {
        this.myFileTransferListener = listener;
        PortRange portRange = RPMaster.getFTPServerPortRange();
        BufferedInputStream in = new BufferedInputStream(ClassLoader.getSystemResourceAsStream("FileTransfer.jks"));
        File f = null;
        try {
            int c;
            f = File.createTempFile("tmp", "tmp");
            f.deleteOnExit();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            while ((c = in.read()) >= 0) {
                out.write(c);
            }
            in.close();
            out.close();
        }
        catch (Exception e2) {
            this.myLogger.error((Object)"Failed to write certificate to temp file.", (Throwable)e2);
        }
        String s = "fv3c09nm5yq";
        this.myRootFolder = new File(path);
        this.myHttpServer = portRange == null ? HttpServerFactory.createHttpServer((boolean)this.myIsSecure, (HttpConstants.Authentication)HttpConstants.Authentication.AUTHENTICATION_BASIC, (String)path, (String)this.myUserName, (String)this.myPassword, (int)13062, (String)f.getAbsolutePath(), (String)s, (int[])new int[]{13062, 13092}) : HttpServerFactory.createHttpServer((boolean)this.myIsSecure, (HttpConstants.Authentication)HttpConstants.Authentication.AUTHENTICATION_BASIC, (String)path, (String)this.myUserName, (String)this.myPassword, (int)portRange.getStart(), (String)f.getAbsolutePath(), (String)s, (int[])new int[]{portRange.getStart(), portRange.getEnd()});
    }

    @Override
    public String getUserName() {
        return this.myUserName;
    }

    @Override
    public String getPassword() {
        return this.myPassword;
    }

    public void transferUpdated(TransferInfo transferInfo) {
        if (transferInfo != null && transferInfo.getUserName().equals(this.myUserName)) {
            Object response = transferInfo.getProtocolResponseCode();
            int responseCode = 0;
            if (response != null) {
                responseCode = (Integer)response;
            }
            String fileName = RelativePathResolver.resolveRelativePath(this.myRootFolder, transferInfo.getFile());
            this.myLogger.debug((Object)("Requested file path: '" + transferInfo.getFile() + "'; fileName: " + fileName + "; status: " + transferInfo.getTransferStatus() + "; code: " + responseCode));
            if (responseCode == 200 && TransferInfo.TransferStatus.TRANSFER_INITIALIZING.equals((Object)transferInfo.getTransferStatus())) {
                this.myFileTransferListener.fileTransferStarted(fileName, transferInfo.getContentLength());
            } else if (responseCode == 401 || responseCode == 404 || responseCode == 500 || responseCode == 403 || TransferInfo.TransferStatus.TRANSFER_ERROR.equals((Object)transferInfo.getTransferStatus())) {
                this.myFileTransferListener.fileTransferFailed(fileName);
            } else if (TransferInfo.TransferStatus.TRANSFER_ONGOING.equals((Object)transferInfo.getTransferStatus())) {
                this.myFileTransferListener.fileTransferUpdated(fileName, (float)transferInfo.getTransferPercentage());
            } else if (TransferInfo.TransferStatus.TRANSFER_COMPLETED.equals((Object)transferInfo.getTransferStatus())) {
                this.myFileTransferListener.fileTransferSucceeded(fileName);
            }
        }
    }
}

