/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.filetransfer;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class RelativePathResolver {
    private static Logger logger = Logger.getLogger(RelativePathResolver.class);

    public static String resolveRelativePath(File root, File requestedFile) {
        String name = requestedFile.getName();
        if (requestedFile.isAbsolute()) {
            try {
                if (requestedFile.getCanonicalPath().indexOf(root.getCanonicalPath()) != -1) {
                    name = requestedFile.getCanonicalPath().substring(root.getCanonicalPath().length());
                    if (RelativePathResolver.isLeadingSlashNotNeeded(name = name.replace('\\', '/'))) {
                        name = name.replaceFirst("/", "");
                    }
                }
            }
            catch (IOException e) {
                logger.error((Object)"failed to get relative path, just use the file name", (Throwable)e);
            }
        }
        return name;
    }

    private static boolean isLeadingSlashNotNeeded(String name) {
        return name.matches("^/[^/]*");
    }
}

