/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.filetransfer;

import com.nokia.em.poseidon.util.concurrency.CachedThread;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class TempFileStore {
    private static final TempFileStore INSTANCE = new TempFileStore();
    private Set temporaryFiles;
    private Logger myLogger = Logger.getLogger(this.getClass());

    private TempFileStore() {
        this.temporaryFiles = Collections.synchronizedSet(new TreeSet());
    }

    public static TempFileStore getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTempFile(String fileName) {
        Set set = this.temporaryFiles;
        synchronized (set) {
            if (fileName != null && fileName.length() > 0) {
                this.temporaryFiles.add(fileName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTempFiles(long timeOut) {
        if (this.temporaryFiles.isEmpty()) {
            this.myLogger.debug((Object)"No temporary files found.");
            return;
        }
        this.myLogger.debug((Object)"Deleting temporary files.");
        final Object lock = new Object();
        CachedThread deleteThread = new CachedThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                TempFileStore.this.myLogger.debug((Object)"run start.");
                try {
                    File newTempFile = File.createTempFile("temp", ".tmp");
                    String newTempFileParent = newTempFile.getParent();
                    if (!newTempFile.delete()) {
                        newTempFile.deleteOnExit();
                    }
                    Set set = TempFileStore.this.temporaryFiles;
                    synchronized (set) {
                        for (String fileName : TempFileStore.this.temporaryFiles) {
                            try {
                                File file = new File(fileName);
                                if (!file.exists() || newTempFile == null || !newTempFileParent.equals(file.getParent()) || file.delete()) continue;
                                file.deleteOnExit();
                            }
                            catch (Exception e) {
                                TempFileStore.this.myLogger.error((Object)("Cannot delete file " + fileName + ". "), (Throwable)e);
                            }
                        }
                        TempFileStore.this.temporaryFiles.clear();
                    }
                }
                catch (IOException ioE) {
                    TempFileStore.this.myLogger.error((Object)"Cannot start deleting, cannot resolve temporary folder.");
                }
                catch (Exception ex) {
                    TempFileStore.this.myLogger.error((Object)"Unknown problem. ", (Throwable)ex);
                }
                Object object = lock;
                synchronized (object) {
                    lock.notifyAll();
                }
                TempFileStore.this.myLogger.debug((Object)"run end.");
            }
        };
        try {
            Object object = lock;
            synchronized (object) {
                deleteThread.start();
                lock.wait(timeOut);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.temporaryFiles.isEmpty()) {
            this.myLogger.error((Object)"All temp files might not be deleted.");
        } else {
            this.myLogger.debug((Object)"Temp files deleted.");
        }
    }
}

