/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.message;

import com.nokia.em.bts.rp.master.alarm.AlarmAdditionalInformation;
import com.nokia.em.bts.rp.master.alarm.AlarmCellularInformation;
import com.nokia.em.bts.rp.master.message.BTSInboundMessage;
import com.nokia.em.bts.rp.master.tool.Tools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AlarmObservation
extends BTSInboundMessage {
    private static final String ADDITIONAL_ATTRIBUTE = "attribute";
    private static final String ADDITIONAL_ATTR_NAME = "name";
    private static final String ADDITIONAL_ATTR_VALUE = "value";
    private int myAlarmNumber;
    private int myAlarmDetailNbr;
    private int myAlarmActivity;
    private int myUnitIndex;
    private int mySubUnitNumber;
    private List<AlarmCellularInformation> myCellularInformation;
    private int myRack;
    private int mySlot;
    private int myShelf;
    private int myEventType;
    private int mySeverity;
    private String myAlarmDetail;
    private AlarmAdditionalInformation myAdditionalInfo;
    private String myTypeOfPlugInUnit;
    private String myObservationTime;
    private Map<String, String> myAlarmAttributes;
    private Map<String, String> myAlarmAdditionalAttributes;
    private int myProbableCause;
    private String myObject;
    private int myReportedNumber;
    private String myArgumentInfo;
    private int myNotificationId;
    private Logger myLogger = Logger.getLogger(this.getClass());
    private int myUnitInformationId;
    private static final String OBJECT_INFORMATION_NODENAME = "ObjectInformation";
    private static final String CELLULAR_OBJECT_TYPE_NODENAME = "_cellularObjectType";
    private static final String CELLULAR_OBJECT_TYPE_BS_NODEVALUE = "bs";
    private static final String CELLULAR_OBJECT_TYPE_LNBTS_NODEVALUE = "LNBTS";
    private static final String CELLULAR_OBJECT_TYPE_BTSSCW_NODEVALUE = "BTSSCW";
    private static final String CELLULAR_OBJECT_TYPE_ANTMOD_NODEVALUE = "ANTMOD";
    private static final String CELLULAR_OBJECT_TYPE_APMOD_NODEVALUE = "APMOD";
    private static final String CELLULAR_OBJECT_TYPE_APANTMOD_NODEVALUE = "APANTMOD";
    private static final String CELLULAR_OBJECT_TYPE_CELL_NODEVALUE = "cell";
    private static final String CELLULAR_OBJECT_TYPE_LNCEL_NODEVALUE = "LNCEL";
    private static final String CELLULAR_OBJECT_TYPE_LCELW_NODEVALUE = "LCELW";
    private static final String CELLULAR_OBJECT_TYPE_CHANNEL_NODEVALUE = "channel";
    private static final String CELLULAR_OBJECT_TYPE_ADJ_NODEVALUE = "adj";
    private static final String CELLULAR_OBJECT_TYPE_LNADJ_NODEVALUE = "LNADJ";
    private static final String CELLULAR_OBJECT_TYPE_LNADJG_NODEVALUE = "LNADJG";
    private static final String CELLULAR_OBJECT_TYPE_LNADJW_NODEVALUE = "LNADJW";
    private static final String CELLULAR_OBJECT_TYPE_MME_NODEVALUE = "mme";
    private static final String CELLULAR_OBJECT_TYPE_LNMME_NODEVALUE = "LNMME";
    private static final String CELLULAR_OBJECT_TYPE_SCTP_NODEVALUE = "sctp";
    private static final String CELLULAR_OBJECT_TYPE_GTPU_NODEVALUE = "gtpu";
    private static final String CELLULAR_OBJECT_TYPE_LNM3_NODEVALUE = "LNM3";
    private static final String ALARM_ADDITIONAL_INFO_SHARED_NODENAME = "shared";
    private static final String ALARM_ADDITIONAL_INFO_SOURCE_IP_ADDR_NODENAME = "sourceIPAddr";
    private static final String ALARM_ADDITIONAL_INFO_DEST_IP_ADDR_NODENAME = "destinationIPAddr";
    private static final String ALARM_ADDITIONAL_INFO_FEATURE_CODE_NODENAME = "featureCode";
    private static final String ALARM_ADDITIONAL_INFO_ADDITIONL_DEST_IP_ADDR_NODENAME = "supplDestinationIPAddr";
    private static final String ALARM_ADDITIONAL_INFO_DESTINATION_PORT_NUM_NODENAME = "destinationPortNum";
    private static final String ALARM_ADDITIONAL_INFO_ADDITIONL_FAULT_REASON_NODENAME = "additionalFaultReason";
    private static final String ALARM_ADDITIONAL_INFO_SUPPLY_INFO_NODENAME = "supplAlarmInfo";
    private static final String CELLULAR_OBJECT_INDEX_NODENAME = "_cellularObjectIndex";
    private static final String UNIT_INFORMATION_NODENAME = "UnitInformation";
    private static final String ALARM_INFORMATION_NODENAME = "AlarmInformation";
    private static final String TRANSPORT_INFORMATION_NODENAME = "TransportInformation";
    private static final String PROBABLE_CAUSE_NODENAME = "_probableCause";
    private static final String OBJECT_NODENAME = "_object";
    private static final String REPORTED_NUMBER_NODENAME = "_reportedNumber";
    private static final String ARGUMENT_INFO_NODENAME = "_argumentInfo";
    private static final String NOTIFICATION_ID_NODENAME = "_notificationId";
    private static final String RACK_NODENAME = "_rack";
    private static final String SHELF_NODENAME = "_shelf";
    private static final String SLOT_NODENAME = "_slot";
    private static final String TYPE_OF_PLUGIN_UNIT_NODENAME = "_typeOfPlugInUnit";
    private static final String UNIT_NUMBER_NODENAME = "_unitNumber";
    private static final String UNIT_INDEX_NODENAME = "_unitIndex";
    private static final String SUB_UNIT_NUMBER_NODENAME = "_subUnitNumber";
    private static final String ALARM_NUMBER_NODENAME = "_alarmNumber";
    private static final String ALARM_ACTIVITY_NODENAME = "_alarmActivity";
    private static final String ALARM_ACTIVITY_CANCEL_NODEVALUE = "cancel";
    private static final String ALARM_ACTIVITY_SET_NODEVALUE = "set";
    private static final String ALARM_ACTIVITY_TRANSIENT_NODEVALUE = "transient";
    private static final String SEVERITY_NODENAME = "_severity";
    private static final String SEVERITY_A1_NODEVALUE = "a1";
    private static final String SEVERITY_A2_NODEVALUE = "a2";
    private static final String SEVERITY_A3_NODEVALUE = "a3";
    private static final String SEVERITY_NOTICE_NODEVALUE = "notice";
    private static final String ALARM_TEXT_NODENAME = "AlarmText";
    private static final String ALARM_DETAIL_NODENAME = "_alarmDetail";
    private static final String ALARM_DETAIL_NUMBER_NODENAME = "_alarmDetailNbr";
    private static final String ALARM_ADDITION_FAULT_ID = "additionalFaultID";
    private static final String ALARM_ADDITIONAL_INFO_NODENAME = "_alarmAdditionalInfo";
    private static final String EVENT_TYPE_NODENAME = "_eventType";
    private static final String EVENT_TYPE_EQUIPMENT_FAILURE_NODEVALUE = "equipmentFailure";
    private static final String EVENT_TYPE_COMMUNICATION_FAILURE_NODEVALUE = "communicationFailure";
    private static final String EVENT_TYPE_QUALITY_OF_SERVICE_NODEVALUE = "qualityOfService";
    private static final String EVENT_TYPE_PROCESSING_FAILURE_NODEVALUE = "processingFailure";
    private static final String EVENT_TYPE_ENVIRONMENT_FAILURE_NODEVALUE = "environmentFailure";
    private static final String TIMESTAMP_SET_NODENAME = "_timeStampSet";
    private static final String TIMESTAMP_CANCEL_NODENAME = "_timeStampCancel";
    private static final String OBSERVATION_TIME_NODENAME = "_observationTime";
    private static final String ALARM_ATTRIBUTES = "AlarmAttributes";
    private static final String ID_NODENAME = "_id";
    private static final String CELLULAR_OBJECT_LCRID_NODENAME = "_lcrId";

    public AlarmObservation(int intSeqNbr, int intAlarmNumber, int intAlarmDetailNbr, int intAlarmActivity, int intUnitIndex, int intSubUnitNumber, int intRack, int intSlot, int intShelf, int intEventType, int intSeverity, String strAlarmDetail, String strTypeOfPlugInUnit, String strObservationTime, Map alarmAttributes, Map alarmAdditionalAttributes, int probableCause, String object, int reportedNumber, String argumentInfo, int notificationId, List<AlarmCellularInformation> cellularInformation, int unitInformationId) {
        super(intSeqNbr);
        this.myAlarmNumber = intAlarmNumber;
        this.myAlarmDetailNbr = intAlarmDetailNbr;
        this.myAlarmActivity = intAlarmActivity;
        this.myUnitIndex = intUnitIndex;
        this.mySubUnitNumber = intSubUnitNumber;
        this.myRack = intRack;
        this.mySlot = intSlot;
        this.myShelf = intShelf;
        this.myEventType = intEventType;
        this.mySeverity = intSeverity;
        this.myAlarmDetail = strAlarmDetail;
        this.myTypeOfPlugInUnit = strTypeOfPlugInUnit;
        this.myObservationTime = strObservationTime;
        this.myAlarmAttributes = alarmAttributes;
        this.myAlarmAdditionalAttributes = alarmAdditionalAttributes;
        this.myProbableCause = probableCause;
        this.myObject = object;
        this.myReportedNumber = reportedNumber;
        this.myArgumentInfo = argumentInfo;
        this.myNotificationId = notificationId;
        this.myCellularInformation = cellularInformation;
        this.myUnitInformationId = unitInformationId;
    }

    public AlarmObservation(int intSeqNbr, Node xmlNode) throws Exception {
        super(intSeqNbr);
        this.setCodedMessage(Tools.xmlToString(xmlNode));
        this.myAlarmActivity = -1;
        this.myAlarmDetailNbr = -1;
        this.myAlarmNumber = -1;
        this.myEventType = -1;
        this.myRack = -1;
        this.mySeverity = -1;
        this.myShelf = -1;
        this.mySlot = -1;
        this.myUnitIndex = -1;
        this.mySubUnitNumber = -1;
        this.myAlarmDetail = "Coreasset_Unknown";
        this.myAdditionalInfo = new AlarmAdditionalInformation();
        this.myObservationTime = "Coreasset_Unknown";
        this.myAlarmAttributes = new HashMap<String, String>();
        this.myAlarmAdditionalAttributes = new LinkedHashMap<String, String>();
        this.myTypeOfPlugInUnit = "Coreasset_Unknown";
        this.myProbableCause = -1;
        this.myObject = "Coreasset_Unknown";
        this.myReportedNumber = -1;
        this.myArgumentInfo = "Coreasset_Unknown";
        this.myNotificationId = -1;
        this.myCellularInformation = new ArrayList<AlarmCellularInformation>();
        this.myUnitInformationId = -1;
        NodeList nodeList = xmlNode.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.hasChildNodes()) {
                if (node.getNodeName().equalsIgnoreCase(OBJECT_INFORMATION_NODENAME)) {
                    this.getObjectInformation(node.getChildNodes());
                } else if (node.getNodeName().equalsIgnoreCase(UNIT_INFORMATION_NODENAME)) {
                    this.getUnitInformation(node.getChildNodes());
                } else if (node.getNodeName().equalsIgnoreCase(ALARM_INFORMATION_NODENAME)) {
                    this.getAlarmInformation(node.getChildNodes());
                } else if (node.getNodeName().equalsIgnoreCase(TRANSPORT_INFORMATION_NODENAME)) {
                    this.getTransportInformation(node.getChildNodes());
                }
            }
            ++i;
        }
    }

    public final List<AlarmCellularInformation> getCellularInformation() {
        return this.myCellularInformation;
    }

    public final int getProbableCause() {
        return this.myProbableCause;
    }

    public final String getObject() {
        return this.myObject;
    }

    public final int getReportedNumber() {
        return this.myReportedNumber;
    }

    public final String getArgumentInfo() {
        return this.myArgumentInfo;
    }

    public final int getNotificationId() {
        return this.myNotificationId;
    }

    public final int getSeverity() {
        return this.mySeverity;
    }

    public final int getAlarmNumber() {
        return this.myAlarmNumber;
    }

    public final int getAlarmActivity() {
        return this.myAlarmActivity;
    }

    public final String getAlarmDetail() {
        return this.myAlarmDetail;
    }

    public final AlarmAdditionalInformation getAdditionalInfo() {
        return this.myAdditionalInfo;
    }

    public final int getAlarmDetailNbr() {
        return this.myAlarmDetailNbr;
    }

    public final int getEventType() {
        return this.myEventType;
    }

    public final int getUnitIndex() {
        return this.myUnitIndex;
    }

    public final int getSubUnitNumber() {
        return this.mySubUnitNumber;
    }

    public final String getObservationTime() {
        if (this.myObservationTime != null) {
            return this.myObservationTime;
        }
        return "";
    }

    public final String getAlarmAttribute(String name) {
        return this.myAlarmAttributes.get(name);
    }

    public final Map getAlarmAttributes() {
        return this.myAlarmAttributes;
    }

    public final String getAlarmAdditionalAttribute(String name) {
        return this.myAlarmAdditionalAttributes.get(name);
    }

    public final Map getAlarmAdditionalAttributes() {
        return this.myAlarmAdditionalAttributes;
    }

    public final String getTypeOfPlugInUnit() {
        return this.myTypeOfPlugInUnit;
    }

    public final int getRackOfUnit() {
        return this.myRack;
    }

    public final int getShelfOfUnit() {
        return this.myShelf;
    }

    public final int getSlotOfUnit() {
        return this.mySlot;
    }

    public final int getUnitInformationId() {
        return this.myUnitInformationId;
    }

    private void getObjectInformation(NodeList objectList) {
        int i = 0;
        while (i < objectList.getLength()) {
            Node node = objectList.item(i);
            NodeList childNodes = node.getChildNodes();
            int cellularObjectTypeValue = -1;
            int cellularObjectIndexValue = -1;
            int cellularObjectLcrIdValue = -1;
            int j = 0;
            while (j < childNodes.getLength()) {
                Node cellularInfo = childNodes.item(j);
                if (cellularInfo.getNodeName().equalsIgnoreCase(CELLULAR_OBJECT_TYPE_NODENAME)) {
                    try {
                        cellularObjectTypeValue = this.getCellularObjectType(cellularInfo);
                    }
                    catch (Exception e) {
                        this.myLogger.error((Object)"cannot set object type.", (Throwable)e);
                    }
                } else if (cellularInfo.getNodeName().equalsIgnoreCase(CELLULAR_OBJECT_INDEX_NODENAME)) {
                    try {
                        cellularObjectIndexValue = Integer.parseInt(cellularInfo.getFirstChild().getNodeValue().trim());
                    }
                    catch (Exception e) {
                        this.myLogger.error((Object)"cannot set object index.", (Throwable)e);
                    }
                } else if (cellularInfo.getNodeName().equalsIgnoreCase(CELLULAR_OBJECT_LCRID_NODENAME)) {
                    try {
                        cellularObjectLcrIdValue = Integer.parseInt(cellularInfo.getFirstChild().getNodeValue().trim());
                    }
                    catch (Exception e) {
                        this.myLogger.error((Object)"cannot se object lcrId.", (Throwable)e);
                    }
                }
                ++j;
            }
            if (cellularObjectIndexValue != -1 || cellularObjectTypeValue != -1 || cellularObjectLcrIdValue != -1) {
                this.myCellularInformation.add(new AlarmCellularInformation(cellularObjectTypeValue, cellularObjectIndexValue, cellularObjectLcrIdValue));
            }
            ++i;
        }
    }

    private int getCellularObjectType(Node cellularInfo) {
        int value = -1;
        String s = cellularInfo.getFirstChild().getNodeValue().trim();
        if (s.equalsIgnoreCase(CELLULAR_OBJECT_TYPE_BS_NODEVALUE) || s.equalsIgnoreCase(CELLULAR_OBJECT_TYPE_LNBTS_NODEVALUE) || s.equalsIgnoreCase(CELLULAR_OBJECT_TYPE_BTSSCW_NODEVALUE)) {
            value = 7;
        } else if (s.equalsIgnoreCase(CELLULAR_OBJECT_TYPE_ANTMOD_NODEVALUE)) {
            value = 135;
        } else if (s.equalsIgnoreCase(CELLULAR_OBJECT_TYPE_APMOD_NODEVALUE)) {
            value = 134;
        } else if (s.equalsIgnoreCase(CELLULAR_OBJECT_TYPE_APANTMOD_NODEVALUE)) {
            value = 136;
        } else if (s.equalsIgnoreCase(CELLULAR_OBJECT_TYPE_CELL_NODEVALUE) || s.equalsIgnoreCase(CELLULAR_OBJECT_TYPE_LNCEL_NODEVALUE) || s.equalsIgnoreCase(CELLULAR_OBJECT_TYPE_LCELW_NODEVALUE)) {
            value = 8;
        } else if (s.equalsIgnoreCase(CELLULAR_OBJECT_TYPE_CHANNEL_NODEVALUE)) {
            value = 9;
        } else if (s.equalsIgnoreCase(CELLULAR_OBJECT_TYPE_ADJ_NODEVALUE)) {
            value = 101;
        } else if (s.equalsIgnoreCase(CELLULAR_OBJECT_TYPE_LNADJ_NODEVALUE)) {
            value = 1011;
        } else if (s.equalsIgnoreCase(CELLULAR_OBJECT_TYPE_LNADJG_NODEVALUE)) {
            value = 1012;
        } else if (s.equalsIgnoreCase(CELLULAR_OBJECT_TYPE_LNADJW_NODEVALUE)) {
            value = 1013;
        } else if (s.equalsIgnoreCase(CELLULAR_OBJECT_TYPE_MME_NODEVALUE)) {
            value = 102;
        } else if (s.equalsIgnoreCase(CELLULAR_OBJECT_TYPE_LNMME_NODEVALUE)) {
            value = 1021;
        } else if (s.equalsIgnoreCase(CELLULAR_OBJECT_TYPE_SCTP_NODEVALUE)) {
            value = 111;
        } else if (s.equalsIgnoreCase(CELLULAR_OBJECT_TYPE_GTPU_NODEVALUE)) {
            value = 112;
        } else if (s.equalsIgnoreCase(CELLULAR_OBJECT_TYPE_LNM3_NODEVALUE)) {
            value = 133;
        }
        return value;
    }

    private void getTransportInformation(NodeList transportInformation) {
        int i = 0;
        while (i < transportInformation.getLength()) {
            Node node = transportInformation.item(i);
            if (node.hasChildNodes()) {
                if (node.getNodeName().equalsIgnoreCase(PROBABLE_CAUSE_NODENAME)) {
                    this.myProbableCause = Integer.parseInt(node.getFirstChild().getNodeValue().trim());
                } else if (node.getNodeName().equalsIgnoreCase(OBJECT_NODENAME)) {
                    this.myObject = node.getFirstChild().getNodeValue().trim();
                } else if (node.getNodeName().equalsIgnoreCase(REPORTED_NUMBER_NODENAME)) {
                    this.myReportedNumber = Integer.parseInt(node.getFirstChild().getNodeValue().trim());
                } else if (node.getNodeName().equalsIgnoreCase(ARGUMENT_INFO_NODENAME)) {
                    this.myArgumentInfo = node.getFirstChild().getNodeValue().trim();
                } else if (node.getNodeName().equalsIgnoreCase(NOTIFICATION_ID_NODENAME)) {
                    this.myNotificationId = Integer.parseInt(node.getFirstChild().getNodeValue().trim());
                }
            }
            ++i;
        }
    }

    private void getUnitInformation(NodeList unitInfoNodeList) {
        int i = 0;
        while (i < unitInfoNodeList.getLength()) {
            Node node = unitInfoNodeList.item(i);
            if (node.hasChildNodes()) {
                if (node.getNodeName().equals(RACK_NODENAME)) {
                    this.myRack = Integer.parseInt(node.getFirstChild().getNodeValue().trim());
                } else if (node.getNodeName().equals(SHELF_NODENAME)) {
                    this.myShelf = Integer.parseInt(node.getFirstChild().getNodeValue().trim());
                } else if (node.getNodeName().equals(SLOT_NODENAME)) {
                    this.mySlot = Integer.parseInt(node.getFirstChild().getNodeValue().trim());
                } else if (node.getNodeName().equals(TYPE_OF_PLUGIN_UNIT_NODENAME)) {
                    this.myTypeOfPlugInUnit = node.getFirstChild().getNodeValue().trim();
                } else if (node.getNodeName().equals(UNIT_NUMBER_NODENAME)) {
                    this.myUnitIndex = Integer.parseInt(node.getFirstChild().getNodeValue().trim());
                } else if (node.getNodeName().equals(UNIT_INDEX_NODENAME)) {
                    this.myUnitIndex = Integer.parseInt(node.getFirstChild().getNodeValue().trim());
                } else if (node.getNodeName().equals(SUB_UNIT_NUMBER_NODENAME)) {
                    this.mySubUnitNumber = Integer.parseInt(node.getFirstChild().getNodeValue().trim());
                } else if (node.getNodeName().equals(ID_NODENAME)) {
                    this.myUnitInformationId = Integer.parseInt(node.getFirstChild().getNodeValue().trim());
                }
            }
            ++i;
        }
    }

    private void getAlarmInformation(NodeList alarmInfoNodeList) {
        String strTimeStampSet = "";
        String strTimeStampCancel = "";
        int i = 0;
        while (i < alarmInfoNodeList.getLength()) {
            Node node = alarmInfoNodeList.item(i);
            if (node.hasChildNodes()) {
                if (node.getNodeName().equals(ALARM_NUMBER_NODENAME)) {
                    this.myAlarmNumber = Integer.parseInt(node.getFirstChild().getNodeValue().trim());
                } else if (node.getNodeName().equals(ALARM_ACTIVITY_NODENAME)) {
                    if (node.getFirstChild().getNodeValue().trim().equals(ALARM_ACTIVITY_CANCEL_NODEVALUE)) {
                        this.myAlarmActivity = 1;
                    } else if (node.getFirstChild().getNodeValue().trim().equals(ALARM_ACTIVITY_SET_NODEVALUE)) {
                        this.myAlarmActivity = 2;
                    } else if (node.getFirstChild().getNodeValue().trim().equals(ALARM_ACTIVITY_TRANSIENT_NODEVALUE)) {
                        this.myAlarmActivity = 3;
                    }
                } else if (node.getNodeName().equals(SEVERITY_NODENAME)) {
                    if (node.getFirstChild().getNodeValue().trim().equals(SEVERITY_A1_NODEVALUE)) {
                        this.mySeverity = 16;
                    } else if (node.getFirstChild().getNodeValue().trim().equals(SEVERITY_A2_NODEVALUE)) {
                        this.mySeverity = 17;
                    } else if (node.getFirstChild().getNodeValue().trim().equals(SEVERITY_A3_NODEVALUE)) {
                        this.mySeverity = 18;
                    } else if (node.getFirstChild().getNodeValue().trim().equals(SEVERITY_NOTICE_NODEVALUE)) {
                        this.mySeverity = 19;
                    }
                } else if (node.getNodeName().equals(ALARM_TEXT_NODENAME)) {
                    NodeList alarmTextNodeList = node.getChildNodes();
                    int k = 0;
                    while (k < alarmTextNodeList.getLength()) {
                        Node alarmTextNode = alarmTextNodeList.item(k);
                        if (alarmTextNode.hasChildNodes()) {
                            if (alarmTextNode.getNodeName().equals(ALARM_DETAIL_NODENAME)) {
                                this.myAlarmDetail = alarmTextNode.getFirstChild().getNodeValue().trim();
                            } else if (alarmTextNode.getNodeName().equals(ALARM_DETAIL_NUMBER_NODENAME)) {
                                this.myAlarmDetailNbr = Integer.parseInt(alarmTextNode.getFirstChild().getNodeValue().trim());
                            } else if (alarmTextNode.getNodeName().equals(ALARM_ADDITIONAL_INFO_NODENAME)) {
                                this.parseAdditionalInfos(alarmTextNode);
                            }
                        }
                        ++k;
                    }
                } else if (node.getNodeName().equals(ALARM_DETAIL_NODENAME)) {
                    this.myAlarmDetail = node.getFirstChild().getNodeValue().trim();
                } else if (node.getNodeName().equals(EVENT_TYPE_NODENAME)) {
                    if (node.getFirstChild().getNodeValue().trim().equals(EVENT_TYPE_EQUIPMENT_FAILURE_NODEVALUE)) {
                        this.myEventType = 25;
                    } else if (node.getFirstChild().getNodeValue().trim().equals(EVENT_TYPE_COMMUNICATION_FAILURE_NODEVALUE)) {
                        this.myEventType = 22;
                    } else if (node.getFirstChild().getNodeValue().trim().equals(EVENT_TYPE_QUALITY_OF_SERVICE_NODEVALUE)) {
                        this.myEventType = 23;
                    } else if (node.getFirstChild().getNodeValue().trim().equals(EVENT_TYPE_PROCESSING_FAILURE_NODEVALUE)) {
                        this.myEventType = 24;
                    } else if (node.getFirstChild().getNodeValue().trim().equals(EVENT_TYPE_ENVIRONMENT_FAILURE_NODEVALUE)) {
                        this.myEventType = 26;
                    }
                } else if (node.getNodeName().equals(TIMESTAMP_SET_NODENAME)) {
                    strTimeStampSet = node.getFirstChild().getNodeValue().trim();
                } else if (node.getNodeName().equals(TIMESTAMP_CANCEL_NODENAME)) {
                    strTimeStampCancel = node.getFirstChild().getNodeValue().trim();
                } else if (node.getNodeName().equals(OBSERVATION_TIME_NODENAME)) {
                    this.myObservationTime = node.getFirstChild().getNodeValue().trim();
                } else if (node.getNodeName().equals(ALARM_ATTRIBUTES)) {
                    this.createAlarmAttributes(node.getChildNodes());
                }
            }
            ++i;
        }
        if (this.myAlarmActivity == 1 && !"".equals(strTimeStampCancel)) {
            this.myObservationTime = strTimeStampCancel;
        } else if (!(this.myAlarmActivity != 2 && this.myAlarmActivity != 3 || "".equals(strTimeStampSet))) {
            this.myObservationTime = strTimeStampSet;
        }
    }

    private void createAlarmAttributes(NodeList alarmAttributes) {
        int i = 0;
        while (i < alarmAttributes.getLength()) {
            Node node = alarmAttributes.item(i);
            String attributeName = node.getNodeName();
            if (!attributeName.equalsIgnoreCase(ADDITIONAL_ATTRIBUTE)) {
                String attributeValue = "";
                if (node.hasChildNodes()) {
                    attributeValue = node.getFirstChild().getNodeValue().trim();
                }
                this.myAlarmAttributes.put(attributeName, attributeValue);
            } else {
                Node nameNode = node.getAttributes().getNamedItem(ADDITIONAL_ATTR_NAME);
                Node valueNode = node.getAttributes().getNamedItem(ADDITIONAL_ATTR_VALUE);
                if (nameNode != null && valueNode != null) {
                    String name = nameNode.getNodeValue().trim();
                    String value = valueNode.getNodeValue().trim();
                    this.myAlarmAdditionalAttributes.put(name, value);
                }
            }
            ++i;
        }
    }

    private void parseAdditionalInfos(Node infoNodes) {
        Node firstChild = infoNodes.getFirstChild();
        if (firstChild != null && 3 == firstChild.getNodeType() && firstChild.getNodeValue().trim().length() > 0) {
            this.myAdditionalInfo.setInfoValue(firstChild.getNodeValue().trim());
            return;
        }
        NodeList infoChildren = infoNodes.getChildNodes();
        int i = 0;
        while (i < infoChildren.getLength()) {
            String nodeValue;
            Node info = infoChildren.item(i);
            String string = nodeValue = info.hasChildNodes() ? info.getFirstChild().getNodeValue().trim() : "";
            if (ALARM_ADDITIONAL_INFO_SOURCE_IP_ADDR_NODENAME.equalsIgnoreCase(info.getNodeName())) {
                this.myAdditionalInfo.setSourceIPAddr(nodeValue);
            }
            if (ALARM_ADDITIONAL_INFO_DEST_IP_ADDR_NODENAME.equalsIgnoreCase(info.getNodeName())) {
                this.myAdditionalInfo.setDestinationIPAddr(nodeValue);
            }
            if (ALARM_ADDITIONAL_INFO_FEATURE_CODE_NODENAME.equalsIgnoreCase(info.getNodeName())) {
                this.myAdditionalInfo.setFeatureCode(nodeValue);
            }
            if (ALARM_ADDITIONAL_INFO_SHARED_NODENAME.equalsIgnoreCase(info.getNodeName())) {
                this.myAdditionalInfo.setShared(nodeValue);
            }
            if (ALARM_ADDITIONAL_INFO_ADDITIONL_DEST_IP_ADDR_NODENAME.equalsIgnoreCase(info.getNodeName())) {
                this.myAdditionalInfo.setAdditionalDestIPAddr(nodeValue);
            }
            if (ALARM_ADDITIONAL_INFO_DESTINATION_PORT_NUM_NODENAME.equalsIgnoreCase(info.getNodeName())) {
                this.myAdditionalInfo.setDestinationPortNum(nodeValue);
            }
            if (ALARM_ADDITIONAL_INFO_ADDITIONL_FAULT_REASON_NODENAME.equalsIgnoreCase(info.getNodeName())) {
                this.myAdditionalInfo.setAdditionalFaultReason(nodeValue);
            }
            if (ALARM_ADDITIONAL_INFO_SUPPLY_INFO_NODENAME.equalsIgnoreCase(info.getNodeName())) {
                this.myAdditionalInfo.setSupplyInfo(nodeValue);
            }
            if (ALARM_ADDITION_FAULT_ID.equalsIgnoreCase(info.getNodeName())) {
                this.myAdditionalInfo.setAdditionalFaultId(nodeValue);
            }
            ++i;
        }
    }
}

