/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.message;

public abstract class BTSMessage {
    public static final int UNEXPECTED_CODE = -1;
    public static final int CANCEL = 1;
    public static final int SET = 2;
    public static final int TRANSIENT = 3;
    public static final int WORKING = 4;
    public static final int DEGRADED = 5;
    public static final int FAULTY = 6;
    public static final int BS = 7;
    public static final int CELL = 8;
    public static final int CHANNEL = 9;
    public static final int LNM3 = 133;
    public static final int APMOD = 134;
    public static final int ANTMOD = 135;
    public static final int APANTMOD = 136;
    public static final int ALARM_DB = 10;
    public static final int CONFIG_DB = 11;
    public static final int BLOCKED = 12;
    public static final int UNBLOCKED = 13;
    public static final int LOCKED = 14;
    public static final int UNLOCKED = 15;
    public static final int A1 = 16;
    public static final int A2 = 17;
    public static final int A3 = 18;
    public static final int NOTICE = 19;
    public static final int DEFERRED = 20;
    public static final int IMMEDIATE = 21;
    public static final int COMMUNICATION_FAILURE = 22;
    public static final int QUALITY_OF_SERVICE = 23;
    public static final int PROCESSING_FAILURE = 24;
    public static final int EQUIPMENT_FAILURE = 25;
    public static final int ENVIRONMENT_FAILURE = 26;
    public static final int BUSY = 27;
    public static final int INVALID_MESSAGE = 28;
    public static final int BAD_VALUE = 29;
    public static final int EXECUTION_ERROR = 30;
    public static final int UNKNOWN_OBJECT = 31;
    public static final int NORMAL = 32;
    public static final int FAST_TUNING = 33;
    public static final int OK = 34;
    public static final int NOK = 35;
    public static final int SUCCESSFUL = 36;
    public static final int FAILED = 37;
    public static final int IDLE = 38;
    public static final int NO_TEST = 39;
    public static final int ACCESS_DENIED = 40;
    public static final int FILE_WRITE_ERROR = 41;
    public static final int INVALID_PARAMETER = 42;
    public static final int EACS_DB = 43;
    public static final int ON = 44;
    public static final int OFF = 45;
    public static final int INPUT = 46;
    public static final int OUTPUT = 47;
    public static final int ENABLED = 48;
    public static final int DISABLED = 49;
    public static final int NO_CHANGE = 50;
    public static final int RESET = 51;
    public static final int STARTING = 52;
    public static final int READY = 53;
    public static final int USER_DB = 54;
    public static final int SUBUNIT = 55;
    public static final int UNIT = 56;
    public static final int RESETTING = 57;
    public static final int TELECOM_NOT_RESPONDING = 58;
    public static final int TELECOM_REJECTING = 59;
    public static final int INVALID_STATE = 60;
    public static final int EXISTING_TEST_REFERENCED = 61;
    public static final int INTERRUPTED_BY_USER = 62;
    public static final int ACTIVE = 63;
    public static final int INACTIVE = 64;
    public static final int INVALID_DATA = 65;
    public static final int FILE_NOT_FOUND = 66;
    public static final int PARAM_UPDATE_FAILED = 67;
    public static final int TIMEOUT = 68;
    public static final int LOW = 69;
    public static final int HIGH = 70;
    public static final int REJECTED_BY_RNC = 71;
    public static final int FTP_TRANSFERRED = 72;
    public static final int DISTRIBUTED = 73;
    public static final int BURNED_TO_FLASH = 74;
    public static final int INVALID_LOGIN = 75;
    public static final int INVALID_FORMAT = 76;
    public static final int MISSING_LICENCE = 77;
    public static final int MISSING_FEATURE = 78;
    public static final int LICENCE_ALREADY_EXISTS = 79;
    public static final int INVALID_LICENCE = 80;
    public static final int FTP_ERROR = 81;
    public static final int OPERATION_FAILED = 82;
    public static final int UNKNOWN_FEATURE_CODE = 83;
    public static final int WAITING_FOR_RF_CONNECTIONS = 84;
    public static final int NO_SNAPSHOT = 85;
    public static final int OUT_OF_RANGE = 86;
    public static final int CONNECTION_LOST = 87;
    public static final int VALIDATION_FAILURE = 88;
    public static final int FILE_ACTIVATION_FAILURE = 89;
    public static final int RESET_SITE = 90;
    public static final int RESET_BS = 91;
    public static final int RESET_CELL = 92;
    public static final int RESET_UNIT = 93;
    public static final int RESET_NONE = 94;
    public static final int FILETYPE_RNW = 95;
    public static final int FILETYPE_COMBINED = 96;
    public static final int FILETYPE_ALL = 97;
    public static final int FILETYPE_HW_CONFIGURATION = 98;
    public static final int FILETYPE_ALARM_HISTORY = 99;
    public static final int FILETYPE_VENDOR_SPECIFIC = 100;
    public static final int ADJ = 101;
    public static final int LNADJ = 1011;
    public static final int LNADJG = 1012;
    public static final int LNADJW = 1013;
    public static final int MME = 102;
    public static final int LNMME = 1021;
    public static final int SETUP_FAILURE = 103;
    public static final int OLD = 104;
    public static final int RROM_NOT_RESPONDING = 105;
    public static final int RROM_REJECTING = 106;
    public static final int RFSW_NOT_RESPONDING = 107;
    public static final int RFSW_REJECTING = 108;
    public static final int FILETYPE_ANTENNA_PARAMETERS = 109;
    public static final int DISCONNECTED = 110;
    public static final int SCTP = 111;
    public static final int GTPU = 112;
    public static final int PDU_NOT_AVAILABLE = 113;
    public static final int RF_POWERCONTROL_NOT_SUPPORTEDBYPDU = 114;
    @Deprecated
    public static final int TOO_MANY_FAILED_LOGINS = 115;
    public static final int WRITE_ACCESS_RESERVED = 116;
    public static final int UNAUTHORIZED = 117;
    public static final int LOGIN_DELAY_ACTIVE = 118;
    public static final int FILETYPE_TROUBLESHOOTING_DATA = 119;
    public static final int ABORTED = 120;
    public static final int FILETYPE_RAMDISKLOG = 121;
    public static final int FILES_NOT_DELETED = 122;
    public static final int REJECTED_BY_CCS = 123;
    public static final int EXECUTING = 124;
    public static final int REJECTED = 125;
    public static final int UNABLE_TO_STORE_FILE = 126;
    public static final int UNABLE_TO_GENERATE_FILE = 127;
    public static final int UNABLE_TO_EXECUTE = 128;
    public static final int INVALID_BTS_STATE = 129;
    public static final int TEST_MODEL_START_FAIL = 130;
    public static final int FILETYPE_RFTEST = 131;
    public static final int UNKNOWN_RESULT = 132;
    public static final int TELECOM_NOT_RELEASED = 135;
    public static final int FAILURE = 136;
    public static final int FILETYPE_AUTOCONF_REPORT = 137;
    public static final int UNKNOWN_ERROR = 138;
    public static final int UNABLE_TO_CLEANUP = 138;
    public static final int SWDL_ONGOING = 139;
    public static final int PASSWORD_EXPIRED = 140;
    public static final int RESTRICTED_LOGIN_PERIOD = 141;
    public static final int BLOCKED_BY_CNUM = 142;
    public static final int FTP_PORT_IN_USE = 300;
    public static final int FAILED_IN_BTS = 301;
    public static final int BTS_REJECTED = 302;
    public static final int UNKNOWN_HOST = 303;
    public static final int NO_FILES_TO_ZIP = 304;
    public static final int FILETYPE_RAEWEIGHTFILE = 142;
    public static final int FILETYPE_RAEPATTERNFILE = 143;
    public static final int FILETYPE_REMOTE_SELF_TEST = 144;
    public static final int NO_TEST_RESULT = 145;
    public static final int INVALID_VALUE = 146;
    public static final int ACCOUNT_INACTIVE = 147;
    public static final int PASSWORD_NOT_SET = 148;
    public static final int PROFILE_NOT_FETCHED = 149;
    public static final int NORA = 1;
    public static final int FLEXI = 2;
    public static final String EST = "est";
    public static final String RF_LOOP = "RFLoop";
    public static final String ELEMENTARY_LOOP = "ElementaryLoop";
    public static final String CDMA_TEST = "CDMATest";
    public static final String PIMSWEEP_TEST = "PIMSweep";
    public static final String PIMDTP_TEST = "PIMDTP";
    public static final String PIM_DESENSITIZATION_TEST = "PIMDesensitization";
    public static final String RF_SCANNING_TEST = "RFScanning";
    public static final String BER_TEST = "BER";
    public static final String BERBLER_TEST = "BERBLER";
    public static final String CABINET_TEST = "cabinetTest";
    public static final String WIMAX_TEST_MODEL = "testModelWimax";
    public static final String WIMAX_TEST_MODEL_TEST_TYPE_TX = "tx";
    public static final String WIMAX_TEST_MODEL_TEST_TYPE_RX = "rx";
    public static final String WIMAX_TEST_MODEL_TEST_TYPE_TXRX = "txrx";
    public static final int CHANGE_MODE_SYSTEM = 1;
    public static final int CHANGE_MODE_EXTENSION = 2;
    public static final String TESTMODELLTE_DOWNLINK = "testModelLTEDownLink";
    public static final String TESTMODELLTE_UPLINK_TP = "testModelLTEUpLinkTP";
    public static final String TESTMODELLTE_UPLINK_CCM = "testModelLTEUpLinkCCM";
    public static final String AASYSLOG = "AaSyslog";
    public static final String AATRACELOG = "AaTracelog";
    public static final String TTITRACELOG = "TtiTracelog";
    public static final int DEFAULT_MESSAGE_TIMEOUT = 60000;
    public static final int DEFAULT_ACK_TIMEOUT = 3000;
    public static final int DEFAULT_TESTMODEL_TIMEOUT = 200000;
    public static final int DEFAULT_FILEACTIVATION_TIMEOUT = 360000;
    public static final int DEFAULT_RESET_TIMEOUT = 480000;
    public static final int TRIPLE_DEFAULT_MESSAGE_TIMEOUT = 180000;
    public static final int SEXTUPLE_DEFAULT_MESSAGE_TIMEOUT = 360000;
    public static final int DEFAULT_REMOTE_SELF_TEST_TIMEOUT = 150000;
    public static final int DEFAULT_REMOTE_SELF_TEST_REPORT_TIMEOUT = 300000;
    private String myMessageData;
    private int mySeqNbr;
    private int myBtsId;
    private String myXMLVersion;
    private int mySessionId = -1;
    protected Type myType = Type.BTS;
    private static final String BTS_OM = "BTS-OM";
    private static final String BTS_TRS = "BTS-TRS";
    private static final String BTS_OM_WCDMA = "BTS-OM-WCDMA";
    private static final String BTS_OM_LTE = "BTS-OM-LTE";
    private static final String BTS_OM_GSM = "BTS-OM-GSM";
    private static final String SEM = "SEM";
    private boolean myUnauthorized = false;

    public BTSMessage(int intSeqNbr) {
        this.mySeqNbr = intSeqNbr;
        this.myMessageData = "Coreasset_Unknown";
        this.myXMLVersion = "<?xml version=\"1.0\"?>";
    }

    public BTSMessage(int intSeqNbr, Type type) {
        this(intSeqNbr);
        this.myType = type;
    }

    public boolean isUnauthorized() {
        return this.myUnauthorized;
    }

    public void setUnauthorized(boolean authorized) {
        this.myUnauthorized = authorized;
    }

    public String getCodedMessage() {
        if (this.myMessageData.equals("Coreasset_Unknown")) {
            this.construct();
        }
        return this.myMessageData;
    }

    public String getDebugMessage() {
        return this.getCodedMessage();
    }

    public final void setSeqNbr(int intSeqNbr) {
        this.mySeqNbr = intSeqNbr;
    }

    public final int getSeqNbr() {
        return this.mySeqNbr;
    }

    public final void setBtsId(int intBtsId) {
        this.myBtsId = intBtsId;
    }

    public final int getBtsId() {
        return this.myBtsId;
    }

    public final void setSessionId(int sessionId) {
        this.mySessionId = sessionId;
    }

    public final int getSessionId() {
        return this.mySessionId;
    }

    @Deprecated
    public final String getMessageData() {
        return this.myMessageData;
    }

    @Deprecated
    public final void setMessageData(String strMessageData) {
        this.setCodedMessage(strMessageData);
    }

    public void setCodedMessage(String strMessageData) {
        this.myMessageData = strMessageData;
    }

    public final String getXMLVersion() {
        return this.myXMLVersion;
    }

    public final void setXMLVersion(String strXMLVersion) {
        this.myXMLVersion = strXMLVersion;
    }

    public final Type getType() {
        return this.myType;
    }

    public final void construct() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getXMLVersion());
        sb.append("<BTSMessage>");
        sb.append(this.createMessageHdr());
        sb.append(this.getContent());
        sb.append("</BTSMessage>");
        this.setCodedMessage(sb.toString());
    }

    public void setType(Type type) {
        this.myType = type;
    }

    protected abstract String getContent();

    protected String createXMLTag(String strTagName, int intTagValue) {
        return this.createXMLTag(strTagName, String.valueOf(intTagValue));
    }

    protected String createXMLTag(String strTagName, String strTagValue) {
        if (strTagValue == null) {
            return "<" + strTagName + "/>";
        }
        return "<" + strTagName + ">" + strTagValue + "</" + strTagName + ">";
    }

    protected String createMessageHdr() {
        switch (this.getType()) {
            case TRS: {
                return this.createTRSMessageHdr();
            }
            case GSM: {
                return this.createGSMMessageHdr();
            }
            case WCDMA: {
                return this.createWCDMAMessageHdr();
            }
            case LTE: {
                return this.createLTEMessageHdr();
            }
        }
        return this.createBTSMessageHdr();
    }

    protected String createBTSMessageHdr() {
        return this.createCustomMessageHdr(BTS_OM, SEM);
    }

    protected String createTRSMessageHdr() {
        return this.createCustomMessageHdr(BTS_TRS, SEM);
    }

    protected String createWCDMAMessageHdr() {
        return this.createCustomMessageHdr(BTS_OM_WCDMA, SEM);
    }

    protected String createLTEMessageHdr() {
        return this.createCustomMessageHdr(BTS_OM_LTE, SEM);
    }

    protected String createGSMMessageHdr() {
        return this.createCustomMessageHdr(BTS_OM_GSM, SEM);
    }

    protected String createCustomMessageHdr(String to, String from) {
        StringBuilder sb = new StringBuilder("<BTSMessageHdr><_seqNumber>");
        sb.append(this.getSeqNbr());
        sb.append("</_seqNumber><_btsId>");
        sb.append(this.getBtsId());
        sb.append("</_btsId><_to>");
        sb.append(to);
        sb.append("</_to><_from>");
        sb.append(from);
        sb.append("</_from>");
        if (this.getSessionId() > 0) {
            sb.append("<_sessionId>");
            sb.append(this.getSessionId());
            sb.append("</_sessionId>");
        }
        sb.append("</BTSMessageHdr>");
        return sb.toString();
    }

    protected static String valueOf(int intConstant) {
        String retValue = "Coreasset_Unknown";
        switch (intConstant) {
            case 16: {
                retValue = "A1";
                break;
            }
            case 17: {
                retValue = "A2";
                break;
            }
            case 18: {
                retValue = "A3";
                break;
            }
            case 40: {
                retValue = "access denied";
                break;
            }
            case 63: {
                retValue = "active";
                break;
            }
            case 10: {
                retValue = "alarmDb";
                break;
            }
            case 29: {
                retValue = "badValue";
                break;
            }
            case 12: {
                retValue = "blocked";
                break;
            }
            case 7: {
                retValue = "bs";
                break;
            }
            case 27: {
                retValue = "busy";
                break;
            }
            case 1: {
                retValue = "cancel";
                break;
            }
            case 8: {
                retValue = "cell";
                break;
            }
            case 9: {
                retValue = "channel";
                break;
            }
            case 22: {
                retValue = "communicationFailure";
                break;
            }
            case 11: {
                retValue = "configDb";
                break;
            }
            case 20: {
                retValue = "deferred";
                break;
            }
            case 5: {
                retValue = "degraded";
                break;
            }
            case 49: {
                retValue = "disabled";
                break;
            }
            case 43: {
                retValue = "eacsDb";
                break;
            }
            case 48: {
                retValue = "enabled";
                break;
            }
            case 26: {
                retValue = "environmentFailure";
                break;
            }
            case 25: {
                retValue = "equipmentFailure";
                break;
            }
            case 30: {
                retValue = "executionError";
                break;
            }
            case 61: {
                retValue = "existingTestReferenced";
                break;
            }
            case 37: {
                retValue = "failed";
                break;
            }
            case 33: {
                retValue = "fastTuning";
                break;
            }
            case 6: {
                retValue = "faulty";
                break;
            }
            case 66: {
                retValue = "fileNotFound";
                break;
            }
            case 41: {
                retValue = "fileWriteError";
                break;
            }
            case 38: {
                retValue = "idle";
                break;
            }
            case 21: {
                retValue = "immediate";
                break;
            }
            case 64: {
                retValue = "inactive";
                break;
            }
            case 46: {
                retValue = "input";
                break;
            }
            case 62: {
                retValue = "interruptedByUser";
                break;
            }
            case 65: {
                retValue = "invalidData";
                break;
            }
            case 28: {
                retValue = "invalidMessage";
                break;
            }
            case 42: {
                retValue = "invalidParameter";
                break;
            }
            case 60: {
                retValue = "invalidState";
                break;
            }
            case 14: {
                retValue = "locked";
                break;
            }
            case 69: {
                retValue = "low";
                break;
            }
            case 50: {
                retValue = "noChange";
                break;
            }
            case 39: {
                retValue = "noTest";
                break;
            }
            case 35: {
                retValue = "nok";
                break;
            }
            case 32: {
                retValue = "normal";
                break;
            }
            case 19: {
                retValue = "notice";
                break;
            }
            case 45: {
                retValue = "off";
                break;
            }
            case 34: {
                retValue = "ok";
                break;
            }
            case 44: {
                retValue = "on";
                break;
            }
            case 47: {
                retValue = "output";
                break;
            }
            case 67: {
                retValue = "paramUpdateFailed";
                break;
            }
            case 24: {
                retValue = "processingFailure";
                break;
            }
            case 23: {
                retValue = "qualityOfService";
                break;
            }
            case 53: {
                retValue = "ready";
                break;
            }
            case 51: {
                retValue = "reset";
                break;
            }
            case 57: {
                retValue = "resetting";
                break;
            }
            case 2: {
                retValue = "set";
                break;
            }
            case 52: {
                retValue = "starting";
                break;
            }
            case 55: {
                retValue = "subunit";
                break;
            }
            case 36: {
                retValue = "successful";
                break;
            }
            case 58: {
                retValue = "telecomNotResponding";
                break;
            }
            case 59: {
                retValue = "telecomRejecting";
                break;
            }
            case 105: {
                retValue = "rromNotResponding";
                break;
            }
            case 106: {
                retValue = "rromRejecting";
                break;
            }
            case 107: {
                retValue = "rfswNotResponding";
                break;
            }
            case 108: {
                retValue = "rfswRejecting";
                break;
            }
            case 68: {
                retValue = "timeout";
                break;
            }
            case 3: {
                retValue = "transient";
                break;
            }
            case 13: {
                retValue = "unblocked";
                break;
            }
            case -1: {
                retValue = "unexpectedCode";
                break;
            }
            case 56: {
                retValue = "unit";
                break;
            }
            case 31: {
                retValue = "unknownObject";
                break;
            }
            case 15: {
                retValue = "unlocked";
                break;
            }
            case 54: {
                retValue = "userDb";
                break;
            }
            case 4: {
                retValue = "working";
                break;
            }
            case 70: {
                retValue = "high";
                break;
            }
            case 71: {
                retValue = "rejectedByRNC";
                break;
            }
            case 72: {
                retValue = "ftpTransferred";
                break;
            }
            case 73: {
                retValue = "distributed";
                break;
            }
            case 74: {
                retValue = "burnedToFlash";
                break;
            }
            case 77: {
                retValue = "missingLicence";
                break;
            }
            case 78: {
                retValue = "missingFeature";
                break;
            }
            case 79: {
                retValue = "licenceAlreadyExists";
                break;
            }
            case 80: {
                retValue = "invalidLicence";
                break;
            }
            case 81: {
                retValue = "ftpError";
                break;
            }
            case 82: {
                retValue = "operationFailed";
                break;
            }
            case 83: {
                retValue = "unknownFeatureCode";
                break;
            }
            case 95: {
                retValue = "rnwConfigurationPlanFile";
                break;
            }
            case 96: {
                retValue = "combinedSiteConfigurationPlanFile";
                break;
            }
            case 97: {
                retValue = "allConfigurationPlanFile";
                break;
            }
            case 98: {
                retValue = "hwConfigurationFile";
                break;
            }
            case 99: {
                retValue = "alarmHistoryFile";
                break;
            }
            case 100: {
                retValue = "vendorSpecificFile";
                break;
            }
            case 109: {
                retValue = "antennaParametersFile";
                break;
            }
            case 119: {
                retValue = "troubleShootingData";
                break;
            }
            case 120: {
                retValue = "aborted";
                break;
            }
            case 121: {
                retValue = "ramdisklog";
                break;
            }
            case 122: {
                retValue = "filesNotDeleted";
                break;
            }
            case 123: {
                retValue = "rejectedByCCS";
                break;
            }
            case 124: {
                retValue = "executing";
                break;
            }
            case 125: {
                retValue = "rejected";
                break;
            }
            case 131: {
                retValue = "rftest";
                break;
            }
            case 137: {
                retValue = "autoConfReport";
                break;
            }
            case 142: {
                retValue = "raeWeightFile";
                break;
            }
            case 143: {
                retValue = "raePatternFile";
                break;
            }
            case 144: {
                retValue = "selfTest";
            }
        }
        return retValue;
    }

    public static enum Compression {
        NONE,
        GZIP,
        BZIP;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static enum Encoding {
        BASE64;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static enum Type {
        BTS,
        TRS,
        GSM,
        WCDMA,
        LTE;

    }
}

