/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.message;

import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.tool.Tools;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileLoadCompleted
extends BTSMessage {
    private List<String> myFileIds = new ArrayList<String>();
    private int myCause = -1;
    private int myResetCoverage = -1;
    private String myOperationFeedback = "";
    private int myFileType = -1;
    private int myUnitId = -1;
    static final String FILE_ID_NODENAME = "_fileId";
    static final String CAUSE_NODENAME = "_cause";
    static final String CAUSE_SUCCESSFUL_NODEVALUE = "successful";
    static final String CAUSE_FAILED_NODEVALUE = "failed";
    static final String CAUSE_FILENOTFOUND_NODEVALUE = "fileNotFound";
    static final String CAUSE_VALIDATIONFAILURE_NODEVALUE = "validationFailure";
    static final String CAUSE_FILEACTIVATIONFAILURE_NODEVALUE = "fileActivationFailure";
    static final String CAUSE_BUSY_NODEVALUE = "busy";
    static final String RESETCOVERAGE_NODENAME = "_resetCoverage";
    static final String RESETCOVERAGE_SITE_NODEVALUE = "site";
    static final String RESETCOVERAGE_BS_NODEVALUE = "bs";
    static final String RESETCOVERAGE_CELL_NODEVALUE = "cell";
    static final String RESETCOVERAGE_UNIT_NODEVALUE = "unit";
    static final String RESETCOVERAGE_NONE_NODEVALUE = "none";
    static final String OPERATIONFEEDBACK_NODENAME = "_operationFeedback";

    public FileLoadCompleted(int seqNbr, String[] fileIds) {
        this(seqNbr, fileIds, -1);
    }

    public FileLoadCompleted(int seqNbr, List<String> fileIds) {
        this(seqNbr, fileIds, -1);
    }

    public FileLoadCompleted(int seqNbr, String[] fileIds, int fileType) {
        super(seqNbr);
        int i = 0;
        while (i < fileIds.length) {
            this.myFileIds.add(fileIds[i]);
            ++i;
        }
        this.myFileType = fileType;
    }

    public FileLoadCompleted(int seqNbr, List<String> fileIds, int fileType) {
        super(seqNbr);
        for (String file : fileIds) {
            this.myFileIds.add(file);
        }
        this.myFileType = fileType;
    }

    public FileLoadCompleted(int seqNbr, Node node) throws Exception {
        super(seqNbr);
        NodeList nList = node.getChildNodes();
        int i = 0;
        while (i < nList.getLength()) {
            Node n = nList.item(i);
            if (n.hasChildNodes() && n.getFirstChild().getNodeValue() != null) {
                if (n.getNodeName().equals(FILE_ID_NODENAME)) {
                    this.myFileIds.add(n.getFirstChild().getNodeValue().trim());
                } else if (n.getNodeName().equals(CAUSE_NODENAME)) {
                    this.myCause = FileLoadCompleted.getCause(n.getFirstChild().getNodeValue().trim());
                } else if (n.getNodeName().equals(RESETCOVERAGE_NODENAME)) {
                    this.myResetCoverage = FileLoadCompleted.getResetCoverage(n.getFirstChild().getNodeValue().trim());
                }
            }
            if (n.getNodeName().equals(OPERATIONFEEDBACK_NODENAME)) {
                this.myOperationFeedback = Tools.xmlToString(n);
            }
            ++i;
        }
    }

    static int getResetCoverage(String value) {
        int coverage = -1;
        if (value.equals(RESETCOVERAGE_SITE_NODEVALUE)) {
            coverage = 90;
        } else if (value.equals(RESETCOVERAGE_BS_NODEVALUE)) {
            coverage = 91;
        } else if (value.equals(RESETCOVERAGE_CELL_NODEVALUE)) {
            coverage = 92;
        } else if (value.equals(RESETCOVERAGE_UNIT_NODEVALUE)) {
            coverage = 93;
        } else if (value.equals(RESETCOVERAGE_NONE_NODEVALUE)) {
            coverage = 94;
        }
        return coverage;
    }

    static int getCause(String value) {
        int cause = 28;
        if (value.equals(CAUSE_SUCCESSFUL_NODEVALUE)) {
            cause = 36;
        } else if (value.equals(CAUSE_FAILED_NODEVALUE)) {
            cause = 37;
        } else if (value.equals(CAUSE_FILENOTFOUND_NODEVALUE)) {
            cause = 66;
        } else if (value.equals(CAUSE_VALIDATIONFAILURE_NODEVALUE)) {
            cause = 88;
        } else if (value.equals(CAUSE_FILEACTIVATIONFAILURE_NODEVALUE)) {
            cause = 89;
        } else if (value.equals(CAUSE_BUSY_NODEVALUE)) {
            cause = 27;
        }
        return cause;
    }

    public List<String> getFileIds() {
        return this.myFileIds;
    }

    public int getFileType() {
        return this.myFileType;
    }

    public int getCause() {
        return this.myCause;
    }

    public void setCause(int cause) {
        this.myCause = cause;
    }

    public int getResetCoverage() {
        return this.myResetCoverage;
    }

    public String getOperationFeedback() {
        return this.myOperationFeedback;
    }

    @Override
    public String getContent() {
        StringBuilder s = new StringBuilder();
        s.append("<FileLoadCompleted>");
        if (this.myFileType != -1) {
            s.append("<_fileType>");
            s.append(FileLoadCompleted.valueOf(this.myFileType));
            s.append("</_fileType>");
        }
        if (this.myUnitId != -1) {
            s.append("<_unitId>");
            s.append(this.myUnitId);
            s.append("</_unitId>");
        }
        for (String file : this.myFileIds) {
            s.append("<_fileId>");
            s.append(file);
            s.append("</_fileId>");
        }
        if (this.myCause != -1) {
            s.append("<_cause>");
            s.append(FileLoadCompleted.valueOf(this.myCause));
            s.append("</_cause>");
        }
        s.append("</FileLoadCompleted>");
        return s.toString();
    }
}

