/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.message;

import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.poseidon.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileLoadPrepare
extends BTSMessage {
    private int myFileType;
    private long myChecksum;
    private boolean myLastFile = true;
    private int myUnitId = -1;
    private int myFileRemaining = -1;
    private int myFileTotal = -1;
    private String myOperationFeedback = "";
    private List<FTPTransferInfo> myFTPTransferInfos = new ArrayList<FTPTransferInfo>();
    private int myCause = -1;
    static final String FTP_TRANSFER_INFO_NODENAME = "FTPTransferInfo";
    static final String FILE_ID_NODENAME = "_fileId";
    static final String SERVER_ADDRESS_NODENAME = "_serverAddress";
    static final String USER_NAME_NODENAME = "_userName";
    static final String PASSWORD_NODENAME = "_password";
    static final String LAST_FILE_NODENAME = "_lastFile";
    static final String CAUSE_NODENAME = "_cause";
    static final String OPERATIONFEEDBACK_NODENAME = "_operationFeedback";
    static final String FILE_TOTAL = "_fileTotal";
    static final String FILE_REMAINING = "_fileRemaining";
    static final String CAUSE_SUCCESSFUL_NODEVALUE = "successful";
    static final String CAUSE_FAILED_NODEVALUE = "failed";
    static final String CAUSE_FILENOTFOUND_NODEVALUE = "fileNotFound";
    static final String CAUSE_VALIDATIONFAILURE_NODEVALUE = "validationFailure";
    static final String CAUSE_FILEACTIVATIONFAILURE_NODEVALUE = "fileActivationFailure";
    static final String CAUSE_BUSY_NODEVALUE = "busy";

    public FileLoadPrepare(int seqNbr, FTPTransferInfo ftpInfo, int fileType, long checksum) {
        super(seqNbr);
        this.myFTPTransferInfos.add(ftpInfo);
        this.myFileType = fileType;
        this.myChecksum = checksum;
    }

    public FileLoadPrepare(int seqNbr, FTPTransferInfo ftpInfo, int fileType, long checksum, BTSMessage.Type type) {
        super(seqNbr, type);
        this.myFTPTransferInfos.add(ftpInfo);
        this.myFileType = fileType;
        this.myChecksum = checksum;
    }

    public FileLoadPrepare(int seqNbr, FTPTransferInfo ftpInfo, int fileType, BTSMessage.Type type) {
        this(seqNbr, ftpInfo, fileType, -1L, type);
    }

    public FileLoadPrepare(int seqNbr, FTPTransferInfo ftpInfo, int fileType) {
        this(seqNbr, ftpInfo, fileType, -1L);
    }

    public FileLoadPrepare(int seqNbr, FTPTransferInfo ftpInfo, int fileType, int unitId) {
        this(seqNbr, ftpInfo, fileType, -1L);
        this.myUnitId = unitId;
    }

    public FileLoadPrepare(int seqNbr, Node node) throws Exception {
        super(seqNbr);
        NodeList nList = node.getChildNodes();
        int i = 0;
        while (i < nList.getLength()) {
            Node n = nList.item(i);
            if (nList.item(i).getNodeName().equalsIgnoreCase(FTP_TRANSFER_INFO_NODENAME)) {
                FTPTransferInfo ftpTransferInfo = new FTPTransferInfo();
                NodeList trInfoNodeList = nList.item(i).getChildNodes();
                int j = 0;
                while (j < trInfoNodeList.getLength()) {
                    Node trInfoNode = trInfoNodeList.item(j);
                    if (trInfoNode.hasChildNodes() && trInfoNode.getFirstChild().getNodeValue() != null) {
                        FileLoadPrepare.injectFTPParameters(ftpTransferInfo, trInfoNode);
                    }
                    ++j;
                }
                this.myFTPTransferInfos.add(ftpTransferInfo);
            } else if (n.hasChildNodes() && n.getFirstChild().getNodeValue() != null) {
                if (CAUSE_NODENAME.equalsIgnoreCase(n.getNodeName())) {
                    this.myCause = FileLoadPrepare.getCause(n.getFirstChild().getNodeValue().trim());
                } else if (OPERATIONFEEDBACK_NODENAME.equals(n.getNodeName())) {
                    this.myOperationFeedback = n.getFirstChild().getNodeValue().trim();
                } else if (LAST_FILE_NODENAME.equalsIgnoreCase(n.getNodeName())) {
                    this.myLastFile = Boolean.valueOf(n.getFirstChild().getNodeValue().trim());
                } else if (FILE_TOTAL.equalsIgnoreCase(n.getNodeName())) {
                    String fileTotal = n.getFirstChild().getNodeValue().trim();
                    this.myFileTotal = TextUtils.isNumeric((String)fileTotal) ? Integer.valueOf(fileTotal) : -1;
                } else if (FILE_REMAINING.equalsIgnoreCase(n.getNodeName())) {
                    String fileRemaining = n.getFirstChild().getNodeValue().trim();
                    this.myFileRemaining = TextUtils.isNumeric((String)fileRemaining) ? Integer.valueOf(fileRemaining) : -1;
                }
            }
            ++i;
        }
    }

    static int getCause(String value) {
        int cause = -1;
        if (value.equalsIgnoreCase(CAUSE_SUCCESSFUL_NODEVALUE)) {
            cause = 36;
        } else if (value.equalsIgnoreCase(CAUSE_FAILED_NODEVALUE)) {
            cause = 37;
        } else if (value.equalsIgnoreCase(CAUSE_FILENOTFOUND_NODEVALUE)) {
            cause = 66;
        } else if (value.equalsIgnoreCase(CAUSE_VALIDATIONFAILURE_NODEVALUE)) {
            cause = 88;
        } else if (value.equalsIgnoreCase(CAUSE_FILEACTIVATIONFAILURE_NODEVALUE)) {
            cause = 89;
        } else if (value.equalsIgnoreCase(CAUSE_BUSY_NODEVALUE)) {
            cause = 27;
        }
        return cause;
    }

    public String getOperationFeedback() {
        return this.myOperationFeedback;
    }

    static void injectFTPParameters(FTPTransferInfo info, Node node) {
        if (node.getNodeName().equalsIgnoreCase(FILE_ID_NODENAME)) {
            info.setFileName(node.getFirstChild().getNodeValue().trim());
        } else if (node.getNodeName().equalsIgnoreCase(SERVER_ADDRESS_NODENAME)) {
            info.setServerAddress(node.getFirstChild().getNodeValue().trim());
        } else if (node.getNodeName().equalsIgnoreCase(USER_NAME_NODENAME)) {
            info.setUserName(node.getFirstChild().getNodeValue().trim());
        } else if (node.getNodeName().equalsIgnoreCase(PASSWORD_NODENAME)) {
            info.setPassword(node.getFirstChild().getNodeValue().trim().toCharArray());
        }
    }

    public List<FTPTransferInfo> getFTPTransferInfo() {
        return this.myFTPTransferInfos;
    }

    public int getCause() {
        return this.myCause;
    }

    public boolean isLastFile() {
        return this.myLastFile;
    }

    public int getFileRemaining() {
        return this.myFileRemaining;
    }

    public int getFileTotal() {
        return this.myFileTotal;
    }

    @Override
    public String getContent() {
        StringBuilder s = new StringBuilder();
        FTPTransferInfo myFtpInfo = this.myFTPTransferInfos.get(0);
        s.append("<FileLoadPrepare><FTPTransferInfo><_fileId>");
        s.append(myFtpInfo.getFileId());
        s.append("</_fileId><_serverAddress>");
        s.append(myFtpInfo.getServerAddress());
        s.append("</_serverAddress><_userName>");
        s.append(myFtpInfo.getUserName());
        s.append("</_userName><_password>");
        s.append(String.valueOf(myFtpInfo.getPassword()));
        s.append("</_password></FTPTransferInfo><_fileType>");
        s.append(FileLoadPrepare.valueOf(this.myFileType));
        s.append("</_fileType>");
        if (this.myChecksum != -1L) {
            s.append("<FileInfo><_fileId>");
            s.append(myFtpInfo.getFileId());
            s.append("</_fileId><_checksum>");
            s.append(this.myChecksum);
            s.append("</_checksum></FileInfo>");
        }
        if (this.myUnitId != -1) {
            s.append("<_unitId>");
            s.append(this.myUnitId);
            s.append("</_unitId>");
        }
        s.append("</FileLoadPrepare>");
        return s.toString();
    }

    public int getFileType() {
        return this.myFileType;
    }

    public long getChecksum() {
        return this.myChecksum;
    }
}

