/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.message;

import com.nokia.em.bts.rp.master.message.BTSMessage;

public class LoginRequest
extends BTSMessage {
    private String myUsername;
    private char[] myPassword;
    private char[] myNewPassword;
    private boolean myReadOnly = false;

    public LoginRequest(int intSeqNbr, String strUserName, char[] password) {
        this(intSeqNbr, strUserName, password, false);
    }

    public LoginRequest(int intSeqNbr, String strUserName, char[] password, boolean readOnly) {
        this(intSeqNbr, strUserName, password, null, readOnly);
    }

    public LoginRequest(int intSeqNbr, String strUserName, char[] password, char[] newPassword, boolean readOnly) {
        super(intSeqNbr);
        this.myUsername = strUserName;
        this.myPassword = password;
        this.myNewPassword = newPassword;
        this.myReadOnly = readOnly;
    }

    @Override
    public String getContent() {
        StringBuilder s = new StringBuilder();
        s.append("<LoginRequest><_userName>");
        s.append(this.validateXMLChars(this.myUsername.toCharArray()));
        s.append("</_userName><_password>");
        s.append(this.validateXMLChars(this.myPassword));
        s.append("</_password>");
        if (this.myNewPassword != null && this.myNewPassword.length != 0) {
            s.append("<_newPassword>" + this.validateXMLChars(this.myNewPassword) + "</_newPassword>");
        }
        if (this.myReadOnly) {
            s.append("<_readOnly>true</_readOnly>");
        }
        s.append("</LoginRequest>");
        return s.toString();
    }

    public boolean isReadOnly() {
        return this.myReadOnly;
    }

    private String validateXMLChars(char[] data) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < data.length) {
            if (data[i] == '<') {
                builder.append("&lt;");
            } else if (data[i] == '>') {
                builder.append("&gt;");
            } else if (data[i] == '&') {
                builder.append("&amp;");
            } else if (data[i] == '\"') {
                builder.append("&quot;");
            } else if (data[i] == '\'') {
                builder.append("&apos;");
            } else {
                builder.append(data[i]);
            }
            ++i;
        }
        return builder.toString();
    }
}

