/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.message;

import com.nokia.em.bts.rp.master.message.ActiveConnection;
import com.nokia.em.bts.rp.master.message.BTSInboundMessage;
import com.nokia.em.bts.rp.master.message.LoginHistory;
import com.nokia.em.bts.rp.master.message.LoginUserProfile;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LoginResponse
extends BTSInboundMessage {
    private int mySuccessCode;
    private ActiveConnection myActiveConnection = new ActiveConnection();
    private LoginUserProfile myLoginUserProfile = new LoginUserProfile();
    private LoginHistory myLoginHistory = new LoginHistory();
    private static final String FAIL_REASON_NODENAME = "_failReason";
    private static final String FAIL_REASON_INVALID_LOGIN_NODEVALUE = "invalidLogin";
    private static final String FAIL_REASON_EXECUTION_ERROR_NODEVALUE = "executionError";
    private static final String FAIL_REASON_WRITE_ACCESS_RESERVED_NODEVALUE = "writeAccessReserved";
    private static final String FAIL_REASON_TOO_MANY_FAILED_LOGINS_NODEVALUE = "tooManyFailedLogins";
    private static final String FAIL_REASON_LOGIN_DELAY_ACTIVE_NODEVALUE = "loginDelayActive";
    private static final String FAIL_REASON_PASSWORD_EXPIRED_NODEVALUE = "passwordExpired";
    private static final String FAIL_REASON_INVALID_FORMAT_ERROR_NODEVALUE = "invalidFormat";
    private static final String FAIL_REASON_RESTRICTED_LOGIN_PERIOD_NODEVALUE = "restrictedLoginPeriod";
    private static final String FAIL_REASON_BLOCKED_BY_CNUM_NODEVALUE = "blockedByCnum";
    private static final String FAIL_REASON_ACCOUNT_INACTIVE_NODEVALUE = "accountInactive";
    private static final String FAIL_REASON_PASSWORD_NOT_SET = "passwordNotSet";
    private static final String FAIL_REASON_PROFILE_NOT_FETCHED = "profileNotFetched";
    private static final String ACTIVE_CONNECTION_NODENAME = "ActiveConnection";
    private static final String ACTIVE_CONNECTION_USERNAME_NODENAME = "_userName";
    private static final String ACTIVE_CONNECTION_IPADDRESS_NODENAME = "_ipAddress";
    private static final String USER_PROFILE_NODENAME = "UserProfile";
    private static final String USER_PROFILE_ACCOUNT_TYPE = "_accountType";
    private static final String USER_PROFILE_ACCOUNT_ROLE = "_accountRole";
    private static final String USER_PROFILE_DAYS_TO_PASSWORD_EXPIRY = "_daysToPasswordExpiry";
    private static final String USER_PROFILE_GRACE_LOGINS_LEFT = "_graceLoginsLeft";
    public static final String USER_PROFILE_WRITE_NODEVALUE = "read-write";
    public static final String USER_PROFILE_READ_ONLY_NODEVALUE = "read-only";
    public static final String USER_PROFILE_ACOUNT_TYPE_LOCAL = "local";
    public static final String USER_PROFILE_ACOUNT_TYPE_CENTRALIZED = "centralized";
    public static final String USER_PROFILE_ACCESS_WRITE = "_accessRight";
    public static final String LOGIN_HISTORY_NODENAME = "LoginHistory";
    public static final String LOGIN_HISTORY_LAST_LOGIN_TIME_ON_BTS = "_lastSuccessfulLoginTimeOnBts";
    public static final String LOGIN_HISTORY_FAILED_COUNT_ON_BTS = "_failedCountSinceLastSuccessOnBts";
    public static final String LOGIN_HISTORY_LAST_LOGIN_TIME_ON_NETWORK = "_lastSuccessfulLoginTimeOnNetwork";
    public static final String LOGIN_HISTORY_FAILED_COUNT_ON_NETWORK = "_failedCountSinceLastSuccessOnNetwork";

    public LoginResponse(int intSeqNbr, int intSuccessCode) {
        super(intSeqNbr);
        this.mySuccessCode = intSuccessCode;
    }

    public LoginResponse(int intSeqNbr, Node xmlNode) throws Exception {
        super(intSeqNbr);
        this.mySuccessCode = -1;
        NodeList nodeList = xmlNode.getOwnerDocument().getElementsByTagName(FAIL_REASON_NODENAME);
        if (nodeList.getLength() == 0) {
            this.mySuccessCode = 34;
            nodeList = xmlNode.getOwnerDocument().getElementsByTagName(USER_PROFILE_NODENAME);
            if (nodeList.getLength() > 0) {
                this.parseUserProfile(nodeList);
            }
            if ((nodeList = xmlNode.getOwnerDocument().getElementsByTagName(LOGIN_HISTORY_NODENAME)).getLength() > 0) {
                this.parseLoginHistory(nodeList);
            }
        } else {
            String failReason = nodeList.item(0).getFirstChild().getNodeValue().trim();
            if (failReason.compareTo(FAIL_REASON_INVALID_LOGIN_NODEVALUE) == 0) {
                this.mySuccessCode = 75;
            } else if (failReason.compareTo(FAIL_REASON_EXECUTION_ERROR_NODEVALUE) == 0) {
                this.mySuccessCode = 30;
            } else if (failReason.compareTo(FAIL_REASON_INVALID_FORMAT_ERROR_NODEVALUE) == 0) {
                this.mySuccessCode = 76;
            } else if (failReason.compareTo(FAIL_REASON_WRITE_ACCESS_RESERVED_NODEVALUE) == 0) {
                this.mySuccessCode = 116;
                nodeList = xmlNode.getOwnerDocument().getElementsByTagName(ACTIVE_CONNECTION_NODENAME);
                if (nodeList.getLength() == 1) {
                    this.setActiveConnection(nodeList);
                }
            } else if (failReason.compareTo(FAIL_REASON_PASSWORD_EXPIRED_NODEVALUE) == 0) {
                this.mySuccessCode = 140;
                nodeList = xmlNode.getOwnerDocument().getElementsByTagName(USER_PROFILE_NODENAME);
                if (nodeList.getLength() > 0) {
                    this.parseUserProfile(nodeList);
                }
            } else if (failReason.compareTo(FAIL_REASON_LOGIN_DELAY_ACTIVE_NODEVALUE) == 0 || failReason.compareTo(FAIL_REASON_TOO_MANY_FAILED_LOGINS_NODEVALUE) == 0) {
                this.mySuccessCode = 118;
            } else if (failReason.compareTo(FAIL_REASON_RESTRICTED_LOGIN_PERIOD_NODEVALUE) == 0) {
                this.mySuccessCode = 141;
            } else if (failReason.compareTo(FAIL_REASON_BLOCKED_BY_CNUM_NODEVALUE) == 0) {
                this.mySuccessCode = 142;
            } else if (failReason.compareTo(FAIL_REASON_ACCOUNT_INACTIVE_NODEVALUE) == 0) {
                this.mySuccessCode = 147;
            } else if (failReason.compareTo(FAIL_REASON_PASSWORD_NOT_SET) == 0) {
                this.mySuccessCode = 148;
            } else if (failReason.compareTo(FAIL_REASON_PROFILE_NOT_FETCHED) == 0) {
                this.mySuccessCode = 149;
            } else {
                throw new InstantiationException("Unrecognized fail reason in LoginResponse: " + failReason);
            }
        }
    }

    private void parseUserProfile(NodeList nodeList) {
        NodeList accessRights = nodeList.item(0).getChildNodes();
        int i = 0;
        while (i < accessRights.getLength()) {
            Node n = accessRights.item(i);
            if (USER_PROFILE_ACCESS_WRITE.equals(n.getNodeName())) {
                if (n.hasChildNodes()) {
                    this.myLoginUserProfile.setReadOnly(USER_PROFILE_READ_ONLY_NODEVALUE.equalsIgnoreCase(n.getFirstChild().getNodeValue()));
                }
            } else if (USER_PROFILE_DAYS_TO_PASSWORD_EXPIRY.equals(n.getNodeName())) {
                this.myLoginUserProfile.setDaysToPasswordExpiry(n.getFirstChild().getNodeValue().trim());
            } else if (USER_PROFILE_GRACE_LOGINS_LEFT.equals(n.getNodeName())) {
                this.myLoginUserProfile.setGraceLoginsLeft(n.getFirstChild().getNodeValue().trim());
            } else if (USER_PROFILE_ACCOUNT_TYPE.equals(n.getNodeName())) {
                this.myLoginUserProfile.setAccountType(n.getFirstChild().getNodeValue().trim());
            } else if (USER_PROFILE_ACCOUNT_ROLE.equals(n.getNodeName())) {
                this.myLoginUserProfile.setAccountRole(n.getFirstChild().getNodeValue().trim());
            }
            ++i;
        }
    }

    private void parseLoginHistory(NodeList nodeList) {
        NodeList loginHistory = nodeList.item(0).getChildNodes();
        int i = 0;
        while (i < loginHistory.getLength()) {
            Node n = loginHistory.item(i);
            if (LOGIN_HISTORY_LAST_LOGIN_TIME_ON_BTS.equals(n.getNodeName())) {
                this.myLoginHistory.setLastSuccLoginTimeOnBTS(n.getFirstChild().getNodeValue().trim());
            } else if (LOGIN_HISTORY_FAILED_COUNT_ON_BTS.equals(n.getNodeName())) {
                this.myLoginHistory.setFailedCountOnBTS(n.getFirstChild().getNodeValue().trim());
            } else if (LOGIN_HISTORY_LAST_LOGIN_TIME_ON_NETWORK.equals(n.getNodeName())) {
                this.myLoginHistory.setLastSuccLoginTimeOnNet(n.getFirstChild().getNodeValue().trim());
            } else if (LOGIN_HISTORY_FAILED_COUNT_ON_NETWORK.equals(n.getNodeName())) {
                this.myLoginHistory.setFailedCountOnNet(n.getFirstChild().getNodeValue().trim());
            }
            ++i;
        }
    }

    private void setActiveConnection(NodeList nodeList) {
        NodeList activeConnectionList = nodeList.item(0).getChildNodes();
        int i = 0;
        while (i < activeConnectionList.getLength()) {
            Node node = activeConnectionList.item(i);
            if (node != null && node.getFirstChild() != null && node.getFirstChild().getNodeValue() != null) {
                if (node.getNodeName().equals(ACTIVE_CONNECTION_IPADDRESS_NODENAME)) {
                    this.myActiveConnection.setIpAddres(node.getFirstChild().getNodeValue().trim());
                } else if (node.getNodeName().equals(ACTIVE_CONNECTION_USERNAME_NODENAME)) {
                    this.myActiveConnection.setUserName(node.getFirstChild().getNodeValue().trim());
                }
            }
            ++i;
        }
    }

    public final int getSuccessCode() {
        return this.mySuccessCode;
    }

    public final LoginUserProfile getLoginUserProfile() {
        return this.myLoginUserProfile;
    }

    public final LoginHistory getLoginHistory() {
        return this.myLoginHistory;
    }

    public ActiveConnection getActiveConnection() {
        return this.myActiveConnection;
    }
}

