/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.message;

import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ModifyUserRequest
extends BTSMessage {
    private static final String FILTERED_CONTENT = "filtered_content";
    private static final String ELEMENT_NAME_MODIFY_USER_REQUEST = "ModifyUserRequest";
    private static final String ELEMENT_NAME_USER_NAME = "_userName";
    private static final String ELEMENT_NAME_OLD_PASSWORD = "_oldPassword";
    private static final String ELEMENT_NAME_NEW_PASSWORD = "_newPassword";
    private static final String EMPTY_STRING = "";
    private String myUserName = "";
    private String myOldPassword = "";
    private String myNewPassword = "";

    public ModifyUserRequest(int sequenceNo, String userName, String oldPassword, String newPassword) {
        super(sequenceNo);
        this.handleNullValues(userName, oldPassword, newPassword);
        this.handleEmptyValues(userName, oldPassword, newPassword);
        this.myUserName = userName;
        this.myOldPassword = oldPassword;
        this.myNewPassword = newPassword;
    }

    private void handleNullValues(String userName, String oldPassword, String newPassword) {
        if (userName == null || oldPassword == null || newPassword == null) {
            throw new IllegalArgumentException();
        }
    }

    private void handleEmptyValues(String userName, String oldPassword, String newPassword) {
        if (userName.isEmpty() || oldPassword.isEmpty() || newPassword.isEmpty()) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public String getContent() {
        Document document = this.createNewDocument();
        if (document == null) {
            return EMPTY_STRING;
        }
        this.addModifyUserRequestElement(document);
        return this.convertToXML(document);
    }

    private Document createNewDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            return document;
        }
        catch (ParserConfigurationException e) {
            return null;
        }
    }

    private void addModifyUserRequestElement(Document document) {
        Element modifyUserRequestNode = document.createElement(ELEMENT_NAME_MODIFY_USER_REQUEST);
        modifyUserRequestNode.appendChild(this.createElement(document, ELEMENT_NAME_USER_NAME, this.myUserName));
        modifyUserRequestNode.appendChild(this.createElement(document, ELEMENT_NAME_OLD_PASSWORD, this.myOldPassword));
        modifyUserRequestNode.appendChild(this.createElement(document, ELEMENT_NAME_NEW_PASSWORD, this.myNewPassword));
        document.appendChild(modifyUserRequestNode);
    }

    private Element createElement(Document document, String elementName, String elementValue) {
        Element element = document.createElement(elementName);
        element.setTextContent(elementValue);
        return element;
    }

    private String convertToXML(Document document) {
        try {
            OutputFormat format = new OutputFormat(document);
            format.setOmitXMLDeclaration(Boolean.TRUE);
            StringWriter xml = new StringWriter();
            XMLSerializer serial = new XMLSerializer(xml, format);
            serial.serialize(document);
            return xml.toString();
        }
        catch (IOException e) {
            return EMPTY_STRING;
        }
    }

    @Override
    public String getDebugMessage() {
        String startElement = "<ModifyUserRequest>";
        String endElement = "</ModifyUserRequest>";
        StringBuilder sb = new StringBuilder(this.getCodedMessage());
        int startIndex = sb.indexOf(startElement);
        int endIndex = sb.indexOf(endElement);
        sb.replace(startIndex, endIndex, String.valueOf(startElement) + FILTERED_CONTENT);
        return sb.toString();
    }
}

