/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.message;

import com.nokia.em.bts.rp.master.connection.HttpContent;
import com.nokia.em.bts.rp.master.connection.MessageFactory;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.AlarmObservation;
import com.nokia.em.bts.rp.master.message.AlarmStatusReply;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.CommissioningReply;
import com.nokia.em.bts.rp.master.message.EmptyMessage;
import com.nokia.em.bts.rp.master.message.FileLoadCompleted;
import com.nokia.em.bts.rp.master.message.FileLoadPrepare;
import com.nokia.em.bts.rp.master.message.FileTransferProtocolResponse;
import com.nokia.em.bts.rp.master.message.LoginResponse;
import com.nokia.em.bts.rp.master.message.ModifyUserResponse;
import com.nokia.em.bts.rp.master.message.ParseCommissionDataReply;
import com.nokia.em.bts.rp.master.message.PerformanceDataResponse;
import com.nokia.em.bts.rp.master.message.PerformanceDataUpdatedNotif;
import com.nokia.em.bts.rp.master.message.RAMLNotification;
import com.nokia.em.bts.rp.master.message.RAMLResponse;
import com.nokia.em.bts.rp.master.message.TRSNotification;
import com.nokia.em.bts.rp.master.message.TRSResponse;
import com.nokia.em.bts.rp.master.message.WriteSessionAvailableNotification;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RPMessageFactory
implements MessageFactory {
    private DocumentBuilder myDocBuilder;
    private final ErrorHandler myErrorHandler;
    private final Logger myLogger = Logger.getLogger(this.getClass());
    private static final String SEQ_NUMBER = "_seqNumber";
    private static final String BTS_ID = "_btsId";
    private static final String SESSION_ID = "_sessionId";
    private static final String HEADER = "BTSMessageHdr";
    private static final String MESSAGE = "BTSMessage";

    public RPMessageFactory() {
        this.myErrorHandler = new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) {
            }

            @Override
            public void fatalError(SAXParseException exception) {
            }

            @Override
            public void warning(SAXParseException exception) {
            }
        };
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(true);
        try {
            this.myDocBuilder = docBuilderFactory.newDocumentBuilder();
            this.myDocBuilder.setErrorHandler(this.myErrorHandler);
        }
        catch (ParserConfigurationException e) {
            this.myLogger.error((Object)"Unable to create DocumentBuilder: ", (Throwable)e);
        }
    }

    @Override
    public synchronized BTSMessage createMessage(HttpContent content) throws InstantiationException {
        BTSMessage ret;
        block51: {
            ret = null;
            int seqNbr = 0;
            int btsId = 0;
            int sessionId = 0;
            String mesType = null;
            try {
                Document doc = this.myDocBuilder.parse(new ByteArrayInputStream(content.getContent().getBytes()));
                Element root = doc.getDocumentElement();
                if (root.getNodeName().compareTo(MESSAGE) != 0) break block51;
                NodeList nList = root.getChildNodes();
                int i = 0;
                while (i < nList.getLength()) {
                    if (nList.item(i).getNodeName().compareTo(HEADER) == 0) {
                        NodeList n1List = nList.item(i).getChildNodes();
                        int j = 0;
                        while (j < n1List.getLength()) {
                            if (n1List.item(j).getNodeName().compareTo(SEQ_NUMBER) == 0) {
                                seqNbr = Integer.parseInt(n1List.item(j).getFirstChild().getNodeValue().trim());
                            } else if (n1List.item(j).getNodeName().compareTo(BTS_ID) == 0) {
                                btsId = Integer.parseInt(n1List.item(j).getFirstChild().getNodeValue().trim());
                            } else if (n1List.item(j).getNodeName().compareTo(SESSION_ID) == 0) {
                                sessionId = Integer.parseInt(n1List.item(j).getFirstChild().getNodeValue().trim());
                            }
                            ++j;
                        }
                        if (nList.getLength() == 1) {
                            ret = new EmptyMessage(seqNbr);
                        }
                    } else {
                        mesType = nList.item(i).getNodeName();
                        Node xmlNode = nList.item(i);
                        if (mesType.compareTo("Ack") == 0) {
                            ret = new Ack(seqNbr, xmlNode);
                        } else if (mesType.compareTo("AlarmObservation") == 0) {
                            ret = new AlarmObservation(seqNbr, xmlNode);
                        } else if (mesType.compareTo("CommissioningReply") == 0) {
                            ret = new CommissioningReply(seqNbr, xmlNode);
                        } else if ("LoginResponse".equals(mesType)) {
                            ret = new LoginResponse(seqNbr, xmlNode);
                        } else if ("ModifyUserResponse".equals(mesType)) {
                            ret = new ModifyUserResponse(seqNbr, xmlNode);
                        } else if ("ParseCommissionDataReply".equals(mesType)) {
                            ret = new ParseCommissionDataReply(seqNbr, xmlNode);
                        } else if ("AlarmStatusReply".equals(mesType)) {
                            ret = new AlarmStatusReply(seqNbr, xmlNode);
                        } else if ("PerformanceDataUpdatedNotif".equals(mesType)) {
                            ret = new PerformanceDataUpdatedNotif(seqNbr, xmlNode);
                        } else if ("PerformanceDataResponse".equals(mesType)) {
                            ret = new PerformanceDataResponse(seqNbr, xmlNode);
                        } else if ("FileTransferProtocolResponse".equals(mesType)) {
                            ret = new FileTransferProtocolResponse(seqNbr, xmlNode);
                        } else if ("RAMLResponse".equals(mesType)) {
                            ret = new RAMLResponse(seqNbr, xmlNode);
                        } else if ("RAMLNotification".equals(mesType)) {
                            ret = new RAMLNotification(seqNbr, xmlNode);
                        } else if ("FileLoadCompleted".equals(mesType)) {
                            ret = new FileLoadCompleted(seqNbr, xmlNode);
                        } else if ("FileLoadPrepare".equals(mesType)) {
                            ret = new FileLoadPrepare(seqNbr, xmlNode);
                        } else if ("TRSNotification".equals(mesType)) {
                            ret = new TRSNotification(seqNbr, xmlNode);
                        } else if ("TRSResponse".equals(mesType) || "ShellCommandResponse".equals(mesType)) {
                            ret = new TRSResponse(seqNbr, xmlNode);
                        } else if ("WriteSessionAvailableNotification".equals(mesType)) {
                            ret = new WriteSessionAvailableNotification(seqNbr);
                        } else {
                            this.myLogger.trace((Object)("Unknown message type: " + mesType + ". Invalid tag or empty line in BTSMessage."));
                        }
                    }
                    if (ret != null) {
                        if (seqNbr > 0) {
                            ret.setBtsId(btsId);
                            ret.setSessionId(sessionId);
                            ret.setUnauthorized(content.getStatusCode() == 401);
                            break;
                        }
                        this.myLogger.error((Object)"Unable to create message: (BTSMesssageHdr fault)");
                        throw new InstantiationException(" instantiation failed: (BTSMesssageHdr fault)");
                    }
                    ++i;
                }
            }
            catch (SAXParseException e) {
                String strError = "** Parsing error, line " + e.getLineNumber() + ", uri " + e.getSystemId();
                this.myLogger.error((Object)("Unable to create message: " + strError));
                throw new InstantiationException(" instantiation failed: (" + e + ")");
            }
            catch (SAXException e) {
                this.myLogger.error((Object)"Unable to create message: ", (Throwable)e);
                throw new InstantiationException(" instantiation failed: (" + e + ")");
            }
            catch (Exception e) {
                this.myLogger.error((Object)"Unable to create message: ", (Throwable)e);
                throw new InstantiationException(" instantiation failed: (" + e + ")");
            }
            catch (Throwable t) {
                this.myLogger.error((Object)"Unable to create message:: ", t);
                throw new InstantiationException(" instantiation failed: (" + t + ")");
            }
        }
        return ret;
    }
}

