/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.security;

import com.nokia.em.bts.rp.master.RPMaster;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.ActiveConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.FileTransferProtocolRequest;
import com.nokia.em.bts.rp.master.message.FileTransferProtocolResponse;
import com.nokia.em.bts.rp.master.message.LoginHistory;
import com.nokia.em.bts.rp.master.message.LoginRequest;
import com.nokia.em.bts.rp.master.message.LoginResponse;
import com.nokia.em.bts.rp.master.message.LoginUserProfile;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.security.AuthenticationListener;
import com.nokia.em.bts.rp.master.security.AuthenticationManager;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class AuthenticationManagerImpl
implements AuthenticationManager {
    private BTSConnection myBtsConnection;
    private final Logger myLogger = Logger.getLogger(this.getClass());
    private static final int LOGIN_RETRY_INTERVAL = 60000;
    private static boolean myLoginOngoing = false;
    private ActiveConnection myActiveConnection = null;
    private LoginUserProfile myLoginUserProfile;
    private LoginHistory myLoginHistory;

    public AuthenticationManagerImpl(BTSConnection btsConnection) {
        this.myBtsConnection = btsConnection;
    }

    @Override
    public void destroy() {
        this.myBtsConnection = null;
    }

    public static boolean isLoginOngoing() {
        return myLoginOngoing;
    }

    @Override
    public void logIn(AuthenticationListener listener, String strUserName, char[] password) {
        this.logIn(listener, strUserName, password, null, false);
    }

    @Override
    public void logIn(AuthenticationListener listener, String strUserName, char[] password, boolean readOnly) {
        this.logIn(listener, strUserName, password, null, readOnly);
    }

    @Override
    public void logIn(final AuthenticationListener listener, final String strUserName, final char[] password, final char[] newPassword, final boolean readOnly) {
        CoreAssetThread worker = new CoreAssetThread(){

            @Override
            protected Object construct() {
                if (RPMaster.isSnapshotOpening()) {
                    AuthenticationManagerImpl.this.myLogger.debug((Object)"Not supported in snapshot open mode.");
                    listener.loginGranted();
                    return true;
                }
                myLoginOngoing = true;
                int seqNumber = AuthenticationManagerImpl.this.myBtsConnection.createScenario();
                LoginRequest loginRequest = new LoginRequest(seqNumber, strUserName, password, newPassword, readOnly);
                AuthenticationManagerImpl.this.myBtsConnection.sendToBTS(loginRequest);
                loginRequest = null;
                BTSMessage response = AuthenticationManagerImpl.this.myBtsConnection.receiveFromBTS(seqNumber, 60000L);
                AuthenticationManagerImpl.this.myBtsConnection.deleteScenario(seqNumber);
                if (response instanceof LoginResponse) {
                    LoginResponse loginResponse = (LoginResponse)response;
                    AuthenticationManagerImpl.this.myActiveConnection = loginResponse.getActiveConnection();
                    AuthenticationManagerImpl.this.myLoginUserProfile = ((LoginResponse)response).getLoginUserProfile();
                    AuthenticationManagerImpl.this.myLoginHistory = ((LoginResponse)response).getLoginHistory();
                    if (loginResponse.getSuccessCode() == 34) {
                        if (RPMaster.getNeedsQueryFileTransferProtocol()) {
                            int seqNbr = AuthenticationManagerImpl.this.myBtsConnection.createScenario();
                            AuthenticationManagerImpl.this.myBtsConnection.sendToBTS(new FileTransferProtocolRequest(seqNbr));
                            BTSMessage fileTransferResponse = AuthenticationManagerImpl.this.myBtsConnection.receiveFromBTS(seqNbr, 30000L);
                            if (fileTransferResponse instanceof FileTransferProtocolResponse) {
                                AuthenticationManagerImpl.this.myBtsConnection.getFileTransferFactory().setUsedProtocol(((FileTransferProtocolResponse)fileTransferResponse).getUsedFileTransferProtocol());
                            }
                        }
                        AuthenticationManagerImpl.this.myBtsConnection.setWriteAccess(!AuthenticationManagerImpl.this.myLoginUserProfile.isReadOnly());
                        listener.loginGranted();
                    } else {
                        AuthenticationManagerImpl.this.myLogger.debug((Object)("BTS replied Nack to LoginRequest with reason " + loginResponse.getSuccessCode()));
                        listener.loginDenied(loginResponse.getSuccessCode());
                    }
                } else if (response instanceof Timeout) {
                    AuthenticationManagerImpl.this.myLogger.error((Object)"Login timeout reached.");
                    listener.loginFailed();
                } else if (response == null) {
                    AuthenticationManagerImpl.this.myLogger.error((Object)"LoginResponse expected but connection lost.");
                    listener.loginDenied(30);
                } else {
                    AuthenticationManagerImpl.this.myLogger.error((Object)("Wrong reply received from BTS. LoginResponse expected but got " + response));
                    listener.loginDenied(30);
                }
                return true;
            }

            @Override
            protected void finished() {
                myLoginOngoing = false;
            }
        };
        worker.start();
    }

    @Override
    public final ActiveConnection getActiveConnection() {
        return this.myActiveConnection;
    }

    @Override
    public LoginUserProfile getUserProfile() {
        return this.myLoginUserProfile;
    }

    @Override
    public LoginHistory getLoginHistory() {
        return this.myLoginHistory;
    }
}

