/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.snapshot.saving;

import com.nokia.em.bts.rp.master.snapshot.SaverProgressListener;
import com.nokia.em.bts.rp.master.snapshot.saving.SnapshotData;
import com.nokia.em.bts.rp.master.snapshot.saving.SnapshotFileSaverNotifier;
import com.nokia.em.bts.rp.master.snapshot.saving.SnapshotFileWriter;
import com.nokia.em.bts.rp.master.snapshot.saving.SnapshotLoggingData;
import com.nokia.em.bts.rp.master.snapshot.saving.SnapshotSavingException;
import com.nokia.em.poseidon.util.file.PFileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.InvalidParameterException;

public class SnapshotFileSaver {
    private SnapshotFileWriter myFileWriter;
    private Class<SnapshotFileWriter> myFileWriterClass;
    private Object myParentObject;
    private SnapshotFileSaverNotifier myNotifier;

    public SnapshotFileSaver(String taskName, boolean localisation) throws InvalidParameterException {
        this(new SnapshotFileSaverNotifier(taskName, localisation));
    }

    public SnapshotFileSaver(String taskName, boolean localisation, int defaultSuccessStatus) throws InvalidParameterException {
        this(new SnapshotFileSaverNotifier(taskName, localisation, defaultSuccessStatus));
    }

    public <T extends SnapshotFileWriter> SnapshotFileSaver(String taskName, boolean localisation, Class<T> fileWriterClass) throws InvalidParameterException {
        this(new SnapshotFileSaverNotifier(taskName, localisation), null, fileWriterClass);
    }

    public <T extends SnapshotFileWriter> SnapshotFileSaver(String taskName, boolean localisation, Object parentObject, Class<T> fileWriterClass) throws InvalidParameterException {
        this(new SnapshotFileSaverNotifier(taskName, localisation), parentObject, fileWriterClass);
    }

    public SnapshotFileSaver(SnapshotFileSaverNotifier notifier) throws InvalidParameterException {
        this(notifier, null, SnapshotFileWriter.class);
    }

    public <T extends SnapshotFileWriter> SnapshotFileSaver(SnapshotFileSaverNotifier notifier, Object parentObject, Class<T> fileWriterClass) throws InvalidParameterException {
        if (notifier == null) {
            throw new InvalidParameterException("Notifier should have a value");
        }
        if (fileWriterClass == null) {
            throw new InvalidParameterException("SnapshotFileWriter class needs to have a value");
        }
        this.myNotifier = notifier;
        this.myParentObject = parentObject;
        this.myFileWriterClass = fileWriterClass;
    }

    public boolean saveToUrl(String url, SaverProgressListener listener, SnapshotLoggingData logData, SnapshotData data) {
        boolean isSuccess = false;
        try {
            if (data == null) {
                throw new SnapshotSavingException("Snapshot data is null.");
            }
            File dir = new File(url, data.getDirectory());
            if (!PFileUtils.makeDirectory((File)dir)) {
                this.myNotifier.createDirectoryFailure(logData, dir.getAbsolutePath());
            }
            isSuccess = this.save(listener, logData, new File(dir, data.getFileName()), data);
        }
        catch (Exception e) {
            this.myNotifier.exceptionHandling(listener, logData, e);
        }
        return isSuccess;
    }

    private boolean save(SaverProgressListener listener, SnapshotLoggingData logData, File destination, SnapshotData data) {
        boolean isSuccess;
        block8: {
            isSuccess = false;
            this.myFileWriter = null;
            try {
                try {
                    if (data.getSnapshotData() instanceof File) {
                        isSuccess = this.doCopy(listener, logData, destination, data);
                        break block8;
                    }
                    this.doWrite(listener, logData, destination, data);
                    isSuccess = true;
                }
                catch (Exception e) {
                    this.myNotifier.exceptionHandling(listener, logData, e);
                    if (this.myFileWriter != null) {
                        isSuccess = this.myNotifier.finallyHandling(listener, logData, (Closeable)((Object)this.myFileWriter));
                    }
                }
            }
            finally {
                if (this.myFileWriter != null) {
                    isSuccess = this.myNotifier.finallyHandling(listener, logData, (Closeable)((Object)this.myFileWriter));
                }
            }
        }
        return isSuccess;
    }

    private boolean doCopy(SaverProgressListener listener, SnapshotLoggingData logData, File destination, SnapshotData data) throws IOException {
        boolean isSuccess;
        File source = (File)data.getSnapshotData();
        if (!this.isSourceExist(source)) {
            this.myNotifier.sourceNotExistFailure(listener, logData, source);
            isSuccess = false;
        } else {
            if (!destination.exists() && !destination.createNewFile()) {
                this.myNotifier.updateFailure(null, logData, "Can't create file: " + destination.getPath());
            }
            this.copy(destination, source);
            this.myNotifier.updateSuccess(listener, logData, "Successfully copied " + source.getName());
            isSuccess = true;
        }
        return isSuccess;
    }

    protected boolean isSourceExist(File source) {
        return source != null && source.exists();
    }

    protected void copy(File destination, File source) throws IOException {
        PFileUtils.copyFile((File)destination, (File)source);
    }

    private void doWrite(SaverProgressListener listener, SnapshotLoggingData logData, File destination, SnapshotData data) throws Exception {
        this.myFileWriter = this.createSnapshotFileWriter(destination);
        this.myFileWriter.writeData(data);
        this.myNotifier.updateSuccess(listener, logData);
    }

    private SnapshotFileWriter createSnapshotFileWriter(File file) throws Exception {
        if (this.myParentObject == null) {
            Constructor<SnapshotFileWriter> contructor = this.myFileWriterClass.getDeclaredConstructor(File.class);
            return contructor.newInstance(file);
        }
        Constructor<SnapshotFileWriter> contructor = this.myFileWriterClass.getDeclaredConstructor(this.myParentObject.getClass(), File.class);
        return contructor.newInstance(this.myParentObject, file);
    }
}

