/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.snapshot.saving;

import com.nokia.em.bts.rp.master.snapshot.SaverProgressListener;
import com.nokia.em.bts.rp.master.snapshot.saving.SnapshotLoggingData;
import com.nokia.em.poseidon.util.file.diskspace.DiskSpaceChecker;
import com.nokia.em.poseidon.util.file.diskspace.DiskSpaceException;
import java.io.Closeable;
import java.io.File;
import java.security.InvalidParameterException;
import org.apache.log4j.Logger;

public class SnapshotFileSaverNotifier {
    private static final String COLON = ": ";
    private static final String FAILED_TO_SAVE = "failed to save";
    private static final String DOESNT_EXIST = " doesn't exist.";
    private static final String FAILED_TO_CREATE_DIRECTORY = "Failed to create directory: ";
    private String myTaskName;
    private boolean myLocalisation;
    private Logger myLogger;
    private int myDefaultSuccessStatus;

    public SnapshotFileSaverNotifier(String taskName, boolean localisation) throws InvalidParameterException {
        this(taskName, localisation, 8);
    }

    public SnapshotFileSaverNotifier(String taskName, boolean localisation, int defaultSuccessStatus) throws InvalidParameterException {
        if (!this.hasValue(taskName)) {
            throw new InvalidParameterException("Task name needs to have a value.");
        }
        this.myTaskName = taskName;
        this.myLocalisation = localisation;
        this.myLogger = Logger.getLogger(this.getClass());
        this.myDefaultSuccessStatus = defaultSuccessStatus;
    }

    private boolean hasValue(String value) {
        return value != null && value.length() > 0;
    }

    public void updateSuccess(SaverProgressListener listener, SnapshotLoggingData data) {
        this.updateSuccess(listener, data, "successfully written");
    }

    public void updateSuccess(SaverProgressListener listener, SnapshotLoggingData data, String message) {
        this.updateStatus(listener, this.myDefaultSuccessStatus);
        if (this.isLoggingDataValid(data)) {
            data.getLogger().debug((Object)(String.valueOf(data.getLoggerTaskName()) + COLON + message));
        } else {
            this.myLogger.error((Object)("Failed to log success with message: " + message));
        }
    }

    private boolean isLoggingDataValid(SnapshotLoggingData data) {
        return data != null && data.isValid();
    }

    public void updateFailure(SaverProgressListener listener, SnapshotLoggingData data, String message) {
        String errorMessage = message;
        if (errorMessage == null) {
            errorMessage = FAILED_TO_SAVE;
        }
        this.updateStatus(listener, 4);
        this.logError(data, errorMessage);
    }

    private void logError(SnapshotLoggingData data, String errorMessage) {
        if (this.isLoggingDataValid(data)) {
            data.getLogger().error((Object)(String.valueOf(data.getLoggerTaskName()) + COLON + errorMessage));
        } else {
            this.myLogger.error((Object)("Failed to log failure with message: " + errorMessage));
        }
    }

    public void createDirectoryFailure(SnapshotLoggingData data, String directory) {
        this.logError(data, FAILED_TO_CREATE_DIRECTORY + directory);
    }

    public void sourceNotExistFailure(SaverProgressListener listener, SnapshotLoggingData data, File source) {
        this.updateFailure(listener, data, this.createMessageFileNotExist(source));
    }

    public void exceptionHandling(SaverProgressListener listener, SnapshotLoggingData data, Exception exception) {
        DiskSpaceChecker checker = new DiskSpaceChecker.Builder((Throwable)exception).build();
        boolean diskSpace = checker.getCause() instanceof DiskSpaceException;
        this.updateStatus(listener, diskSpace ? 16 : 4);
        String message = String.valueOf(data.getLoggerTaskName()) + COLON + FAILED_TO_SAVE + (diskSpace ? " Disk is full: " : COLON);
        if (this.isLoggingDataValid(data)) {
            data.getLogger().error((Object)message, checker.getCause());
        } else {
            this.myLogger.error((Object)("Failed to log exception with message: " + message), checker.getCause());
        }
    }

    public boolean finallyHandling(SaverProgressListener listener, SnapshotLoggingData data, Closeable out) {
        boolean isSuccess = true;
        try {
            out.close();
            this.updateSuccess(listener, data, "Snapshot file successfully created.");
        }
        catch (Exception e) {
            this.exceptionHandling(listener, data, e);
            isSuccess = false;
        }
        return isSuccess;
    }

    public String createMessageFileNotExist(File source) {
        String message = source == null ? "Null file doesn't exist." : String.valueOf(source.getPath()) + DOESNT_EXIST;
        return message;
    }

    public void updateStatus(SaverProgressListener listener, int status) {
        if (listener != null) {
            listener.taskUpdated(this.myTaskName, status, this.myLocalisation);
        }
    }
}

