/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.time;

import com.nokia.em.bts.rp.master.RPMaster;
import com.nokia.em.bts.rp.master.time.BTSTimeListener;
import com.nokia.em.bts.rp.master.time.TimeManager;
import com.nokia.em.bts.rp.master.time.TimeZoneChangeListener;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class TimeManagerImpl
implements TimeManager,
TimeZoneChangeListener {
    private long myOffset;
    private TimeZone myTimeZone;
    private Object myLock = new Object();
    private boolean offsetSet;
    private boolean timezoneSet;
    private boolean failed;
    private Logger myLogger = Logger.getLogger(this.getClass());
    private BTSTimeListener myTimeListener;

    public TimeManagerImpl() {
        this.reset();
    }

    @Override
    public Calendar getBTSCalendar() {
        Calendar calendar = Calendar.getInstance();
        if (RPMaster.isSnapshotOpening() && !this.btsTimeSet()) {
            calendar.setTimeZone(this.myTimeZone);
            return calendar;
        }
        if (!this.btsTimeSet()) {
            return calendar;
        }
        calendar.setTimeZone(this.myTimeZone);
        if (this.myOffset > Integer.MAX_VALUE || this.myOffset < Integer.MIN_VALUE) {
            calendar.add(13, (int)(this.myOffset / 1000L));
        } else {
            calendar.add(14, (int)this.myOffset);
        }
        return calendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timeOffsetResolved(long offset) {
        Object object = this.myLock;
        synchronized (object) {
            this.myOffset = offset;
            this.offsetSet = true;
            this.myLock.notifyAll();
        }
        this.myLogger.debug((Object)("set offset to " + offset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timeOffsetResolveFailed() {
        Object object = this.myLock;
        synchronized (object) {
            this.offsetSet = false;
            this.failed = true;
            this.myLock.notifyAll();
        }
        this.myLogger.debug((Object)"Failed to get time offset.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timeZoneResolved(TimeZone timeZone) {
        Object object = this.myLock;
        synchronized (object) {
            this.myTimeZone = timeZone;
            this.timezoneSet = true;
            this.myLock.notifyAll();
        }
        if (this.myTimeListener != null) {
            this.myTimeListener.btsTimeReceived();
        }
        this.myLogger.debug((Object)("set time zone to " + this.myTimeZone.getID()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timeZoneResolveFailed() {
        Object object = this.myLock;
        synchronized (object) {
            this.timezoneSet = false;
            this.failed = true;
            this.myLock.notifyAll();
        }
        this.myLogger.debug((Object)"Failed to get time zone.");
    }

    @Override
    public synchronized void adjustToBTSTime(final BTSTimeListener listener) {
        this.myLogger.debug((Object)this.getClass().toString());
        CoreAssetThread worker = new CoreAssetThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Object construct() throws Exception {
                Object object = TimeManagerImpl.this.myLock;
                synchronized (object) {
                    TimeManagerImpl.this.myLogger.debug((Object)"Waiting for offset and time zone");
                    while (!TimeManagerImpl.this.btsTimeSet() && !TimeManagerImpl.this.failed) {
                        TimeManagerImpl.this.myLock.wait();
                    }
                    TimeManagerImpl.this.myLogger.debug((Object)("Acquired: " + TimeManagerImpl.this.myTimeZone.getID() + " " + TimeManagerImpl.this.myOffset));
                    return Boolean.TRUE;
                }
            }

            @Override
            protected void finished() {
                if (TimeManagerImpl.this.btsTimeSet()) {
                    listener.btsTimeReceived();
                } else {
                    listener.btsTimeReceiveFailed();
                }
            }
        };
        worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean btsTimeSet() {
        boolean isReady;
        Object object = this.myLock;
        synchronized (object) {
            isReady = this.offsetSet && this.timezoneSet;
        }
        return isReady;
    }

    @Override
    public void btsDisconnected() {
        this.reset();
    }

    @Override
    public void btsConnected() {
    }

    @Override
    public boolean btsRequestUnsecureConnection() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void btsConnectionRefused(String strActiveHost) {
    }

    @Override
    public void disconnectingFailed() {
    }

    @Override
    public void disconnectingSucceeded() {
    }

    @Override
    public void btsCertificateRejected() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        this.myLogger.debug((Object)"resetting");
        Object object = this.myLock;
        synchronized (object) {
            this.myLock.notifyAll();
            this.myTimeZone = TimeZone.getDefault();
            this.myOffset = 0L;
            this.timezoneSet = false;
            this.offsetSet = false;
            this.failed = false;
        }
    }

    @Override
    public void setTimeListener(BTSTimeListener listener) {
        this.myTimeListener = listener;
    }
}

