/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.tool;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DomParserHelper {
    public static final String extractFirstValue(Node node) {
        Node child = node.getFirstChild();
        while (child != null) {
            String nodeValue;
            short nodeType = child.getNodeType();
            if (!(nodeType != 3 && nodeType != 4 || (nodeValue = child.getNodeValue().trim()).isEmpty())) {
                return nodeValue;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            String testXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><TestXml><GettingString><ValueToGet>This is a String value</ValueToGet></GettingString><GettingNonString><IntegerValue booleanAttribute=\"true\">123</IntegerValue></GettingNonString><CustomTypeTest><FloatValue>4.5565</FloatValue></CustomTypeTest></TestXml>";
            Element root = DomParserHelper.parse(testXml);
            StringTarget stringValue = new StringTarget("GettingString", "ValueToGet");
            BooleanTarget booleanValue = new BooleanTarget(ParseTargetType.ATTRIBUTE, "GettingNonString", "IntegerValue", "booleanAttribute");
            IntegerTarget integerValue = new IntegerTarget("GettingNonString", "IntegerValue");
            ParseTarget<Float> floatValue = new ParseTarget<Float>(new String[]{"CustomTypeTest", "FloatValue"}){

                @Override
                protected void addValue(Node node) {
                    this.addValueImpl(Float.valueOf(Float.parseFloat(DomParserHelper.extractFirstValue(node))));
                }
            };
            DomParserHelper.parseTarget((Node)root, stringValue, booleanValue, integerValue, floatValue);
            testXml = "<Test><data><parameter><name>teraliter</name><short>Tl</short><exp>12</exp></parameter><parameter><name>gigaliter</name><short>Gl</short><exp>9</exp></parameter><parameter><name>megaliter</name><short>Ml</short><exp>6</exp></parameter><parameter><name>kiloliter</name><short>kl</short><exp>3</exp></parameter><parameter><name>hehtoliter</name><short>hl</short><exp>2</exp></parameter><parameter><name>dekaliter</name><short>dal</short><exp>1</exp></parameter><parameter><name>liter</name><short>l</short><exp>0</exp></parameter><parameter><name>deciliter</name><short>dl</short><exp>-1</exp></parameter><parameter><name>centiliter</name><short>cl</short><exp>-2</exp></parameter><parameter><name>milliliter</name><short>ml</short><exp>-3</exp></parameter><parameter><name>microliter</name><short>ul</short><exp>-6</exp></parameter><parameter><name>nanoliter</name><short>nl</short><exp>-9</exp></parameter><parameter><name>pikoliter</name><short>pl</short><exp>-12</exp></parameter></data></Test>";
            root = DomParserHelper.parse(testXml);
            StructTarget structTarget = new StructTarget("data", "parameter");
            structTarget.add("name");
            structTarget.add("short");
            structTarget.add("exp");
            structTarget.setMultiplicity(Integer.MAX_VALUE);
            DomParserHelper.parseTarget((Node)root, structTarget);
            testXml = "<Test><data><parameter name=\"name\">Rule Test</parameter><parameter name=\"description\">Testing rule capabilities</parameter><parameter name=\"important\">false</parameter><customRule value=\"wrong one\">123</customRule><customRule value=\"correct!\">456</customRule><customRule value=\"wrong one\">789</customRule></data></Test>";
            root = DomParserHelper.parse(testXml);
            StringTarget name = new StringTarget(new AttributeRule("name", "name"), "data", "parameter");
            StringTarget description = new StringTarget(new AttributeRule("name", "description"), "data", "parameter");
            BooleanTarget important = new BooleanTarget(new AttributeRule("name", "important"), "data", "parameter");
            ParseRule customRule = new ParseRule(){

                @Override
                protected boolean isAccepted(Node node) {
                    return "456".equals(DomParserHelper.extractFirstValue(node));
                }
            };
            StringTarget custom = new StringTarget(ParseTargetType.ATTRIBUTE, customRule, "data", "customRule", "value");
            DomParserHelper.parseTarget((Node)root, name, description, important, custom);
            testXml = "<Test><element><data><p name=\"name\">name of test</p><p name=\"description\">advanced feature test</p></data><data><p name=\"name\">purpose of test</p></data><data><p name=\"name\">description of test</p><p name=\"description\">using parse rules inside a struct</p></data></element></Test>";
            root = DomParserHelper.parse(testXml);
            StructTarget ruleStructTarget = new StructTarget("element", "data");
            ruleStructTarget.add("name", new AttributeRule("name", "name"), "p");
            ruleStructTarget.add("description", new AttributeRule("name", "description"), "p");
            ruleStructTarget.setMultiplicity(Integer.MAX_VALUE);
            DomParserHelper.parseTarget((Node)root, ruleStructTarget);
        }
        catch (Throwable ex) {
            System.err.println("Oops, test failed: " + ex);
            ex.printStackTrace();
        }
    }

    public static Element parse(String xml) throws ParserConfigurationException, SAXException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) {
            }

            @Override
            public void fatalError(SAXParseException exception) {
            }

            @Override
            public void warning(SAXParseException exception) {
            }
        });
        Document document = documentBuilder.parse(in);
        in.close();
        Element element = document.getDocumentElement();
        return element;
    }

    public static void parseTarget(Node parent, List<ParseTarget<?>> parseTargetList) {
        DomParserHelper.parseTarget(parent, new ArrayList<String>(10), parseTargetList);
    }

    public static void parseTarget(Node parent, ParseTarget<?> ... parseTargets) {
        ArrayList parseTargetList = new ArrayList(parseTargets.length);
        ParseTarget<?>[] parseTargetArray = parseTargets;
        int n = parseTargets.length;
        int n2 = 0;
        while (n2 < n) {
            ParseTarget<?> parseTarget = parseTargetArray[n2];
            parseTargetList.add(parseTarget);
            ++n2;
        }
        DomParserHelper.parseTarget(parent, parseTargetList);
    }

    public static void parseTarget(String xml, List<ParseTarget<?>> parseTargetList) throws ParserConfigurationException, SAXException, IOException {
        DomParserHelper.parseTarget((Node)DomParserHelper.parse(xml), parseTargetList);
    }

    public static void parseTarget(String xml, ParseTarget<?> ... parseTargets) throws ParserConfigurationException, SAXException, IOException {
        DomParserHelper.parseTarget((Node)DomParserHelper.parse(xml), parseTargets);
    }

    public static String toXml(Node node) {
        return DomParserHelper.toXml(node, 0);
    }

    public static String toXml(Node node, int indent) {
        StringBuilder b = new StringBuilder(1000);
        return DomParserHelper.toXml(b, node, indent).toString();
    }

    public static StringBuilder toXml(StringBuilder b, Node node, int indent) {
        if (node.getNodeType() == 1) {
            DomParserHelper.createIndent(b, indent).append("<").append(node.getNodeName());
            boolean hasChildren = node.getChildNodes().getLength() > 0;
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                int i = 0;
                while (i < attributes.getLength()) {
                    Node item = attributes.item(i);
                    b.append(' ').append(item.getNodeName());
                    b.append("=\"").append(item.getNodeValue()).append('\"');
                    ++i;
                }
            }
            if (hasChildren) {
                b.append(">\n");
                Node child = node.getFirstChild();
                while (child != null) {
                    DomParserHelper.toXml(b, child, indent + 4);
                    child = child.getNextSibling();
                }
                DomParserHelper.createIndent(b, indent).append("</").append(node.getNodeName()).append(">\n");
            } else {
                b.append("/>\n");
            }
        } else if (node.getNodeType() == 3) {
            String trimmed = node.getNodeValue().trim();
            if (trimmed.length() > 0) {
                DomParserHelper.createIndent(b, indent).append(trimmed).append('\n');
            }
        } else if (node.getNodeType() == 4) {
            String trimmed = node.getNodeValue().trim();
            if (trimmed.length() > 0) {
                DomParserHelper.createIndent(b, indent).append("<![CDATA[\n");
                DomParserHelper.createIndent(b, indent + 4).append(trimmed).append("]]>\n");
            }
        } else {
            DomParserHelper.createIndent(b, indent).append("<!-- What to do with node type ").append(node.getNodeType()).append("? -->");
        }
        return b;
    }

    private static StringBuilder createIndent(StringBuilder b, int indent) {
        int i = indent;
        while (--i >= 0) {
            b.append(' ');
        }
        return b;
    }

    private static void parseTarget(Node parent, List<String> tags, List<ParseTarget<?>> parseTargetList) {
        Node child = parent.getFirstChild();
        while (child != null && !parseTargetList.isEmpty()) {
            if (child.getNodeType() == 1) {
                String name = child.getNodeName();
                int i = parseTargetList.size();
                while (--i >= 0) {
                    ParseTarget<?> parseTarget;
                    if (i >= parseTargetList.size() || !(parseTarget = parseTargetList.get(i)).match(tags, name)) continue;
                    if (parseTarget.getDepth() == tags.size() + 1) {
                        if (!parseTarget.isAllowed(child)) continue;
                        switch (parseTarget.getType()) {
                            case ATTRIBUTE: {
                                Node attribute;
                                NamedNodeMap attributeMap = child.getAttributes();
                                if (attributeMap == null || (attribute = attributeMap.getNamedItem(parseTarget.getLastTag())) == null) break;
                                parseTarget.addValue(attribute);
                                break;
                            }
                            case TEXT: {
                                parseTarget.addValue(child);
                                break;
                            }
                            default: {
                                throw new Error("implementation missing for ParseTargetType: " + (Object)((Object)parseTarget.getType()));
                            }
                        }
                        if (!parseTarget.isDone()) continue;
                        parseTargetList.remove(i);
                        continue;
                    }
                    tags.add(name);
                    DomParserHelper.parseTarget(child, tags, parseTargetList);
                    tags.remove(tags.size() - 1);
                }
            }
            child = child.getNextSibling();
        }
    }

    private DomParserHelper() {
    }

    public static final class AttributeRule
    extends ParseRule {
        private final String myAttribute;
        private final String myValue;

        public AttributeRule(String attribute, String value) {
            this.myAttribute = attribute;
            this.myValue = value;
        }

        @Override
        protected boolean isAccepted(Node node) {
            NamedNodeMap attributeMap = node.getAttributes();
            if (attributeMap != null) {
                Node attribute = attributeMap.getNamedItem(this.myAttribute);
                return attribute != null && attribute.getNodeValue().equals(this.myValue);
            }
            return false;
        }
    }

    public static final class BooleanTarget
    extends ParseTarget<Boolean> {
        public BooleanTarget(ParseRule rule, String ... tags) {
            super(rule, tags);
        }

        public BooleanTarget(ParseTargetType type, ParseRule rule, String ... tags) {
            super(type, rule, tags);
        }

        public BooleanTarget(ParseTargetType type, String ... tags) {
            super(type, tags);
        }

        public BooleanTarget(String ... tags) {
            super(tags);
        }

        @Override
        protected void addValue(Node node) {
            String nodeValue = DomParserHelper.extractFirstValue(node);
            this.addValueImpl(Boolean.parseBoolean(nodeValue));
        }
    }

    public static final class CharArrayTarget
    extends ParseTarget<char[]> {
        public CharArrayTarget(ParseRule rule, String ... tags) {
            super(rule, tags);
        }

        public CharArrayTarget(ParseTargetType type, ParseRule rule, String ... tags) {
            super(type, rule, tags);
        }

        public CharArrayTarget(ParseTargetType type, String ... tags) {
            super(type, tags);
        }

        public CharArrayTarget(String ... tags) {
            super(tags);
        }

        @Override
        protected void addValue(Node node) {
            String nodeValue = DomParserHelper.extractFirstValue(node);
            if (nodeValue != null) {
                this.addValueImpl(nodeValue.toCharArray());
            }
        }
    }

    public static final class IntegerTarget
    extends ParseTarget<Integer> {
        public IntegerTarget(ParseRule rule, String ... tags) {
            super(rule, tags);
        }

        public IntegerTarget(ParseTargetType type, ParseRule rule, String ... tags) {
            super(type, rule, tags);
        }

        public IntegerTarget(ParseTargetType type, String ... tags) {
            super(type, tags);
        }

        public IntegerTarget(String ... tags) {
            super(tags);
        }

        @Override
        protected void addValue(Node node) {
            String nodeValue = DomParserHelper.extractFirstValue(node);
            if (nodeValue != null) {
                this.addValueImpl(Integer.parseInt(nodeValue));
            }
        }
    }

    public static abstract class ParseRule {
        protected abstract boolean isAccepted(Node var1);
    }

    public static abstract class ParseTarget<T> {
        private int myMaxValues = 1;
        private ParseRule myRule;
        private String[] myTags;
        private final ParseTargetType myType;
        private int myValueCount;
        private final List<T> myValues = new ArrayList<T>(10);

        public ParseTarget(ParseRule rule, String ... tags) {
            this(ParseTargetType.TEXT, rule, tags);
        }

        public ParseTarget(ParseTargetType type, ParseRule rule, String ... tags) {
            this(type, tags);
            this.setRule(rule);
        }

        public ParseTarget(ParseTargetType type, String ... tags) {
            this.myTags = Arrays.copyOf(tags, tags.length);
            this.myType = type;
        }

        public ParseTarget(String ... tags) {
            this(ParseTargetType.TEXT, tags);
        }

        public String getLastTag() {
            return this.myTags[this.myTags.length - 1];
        }

        public final T getValue() {
            return this.myValues.isEmpty() ? null : (T)this.myValues.get(0);
        }

        public final List<T> getValues() {
            return this.myValues;
        }

        public final boolean isDone() {
            return this.myValueCount >= this.myMaxValues;
        }

        public final void setMultiplicity(int max) {
            this.myMaxValues = max;
        }

        public final void setRule(ParseRule rule) {
            this.myRule = rule;
        }

        protected abstract void addValue(Node var1);

        protected final void addValueImpl(T value) {
            this.myValues.add(value);
            ++this.myValueCount;
        }

        protected final ParseTargetType getType() {
            return this.myType;
        }

        protected final boolean isAllowed(Node node) {
            return this.myRule == null || this.myRule.isAccepted(node);
        }

        final int getDepth() {
            switch (this.myType) {
                case ATTRIBUTE: {
                    return this.myTags.length - 1;
                }
                case TEXT: {
                    return this.myTags.length;
                }
            }
            throw new Error("implementation missing for ParseTargetType: " + (Object)((Object)this.myType));
        }

        final boolean match(List<String> hierarchy, String next) {
            if (hierarchy.size() >= this.myTags.length || !this.myTags[hierarchy.size()].equals(next)) {
                return false;
            }
            int i = hierarchy.size();
            while (--i >= 0) {
                if (this.myTags[i].equals(hierarchy.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    public static enum ParseTargetType {
        ATTRIBUTE,
        TEXT;

    }

    public static final class StringTarget
    extends ParseTarget<String> {
        public StringTarget(ParseRule rule, String ... tags) {
            super(rule, tags);
        }

        public StringTarget(ParseTargetType type, ParseRule rule, String ... tags) {
            super(type, rule, tags);
        }

        public StringTarget(ParseTargetType type, String ... tags) {
            super(type, tags);
        }

        public StringTarget(String ... tags) {
            super(tags);
        }

        @Override
        protected void addValue(Node node) {
            String nodeValue = DomParserHelper.extractFirstValue(node);
            if (nodeValue != null) {
                this.addValueImpl(nodeValue);
            }
        }
    }

    public static final class Struct {
        private final String[][] myTags;
        private final String[] myValues;
        private final List<String> myNames;

        protected Struct(List<String> names, String[][] tags, List<StringTarget> values) {
            this.myNames = names;
            this.myTags = tags;
            int size = tags.length;
            this.myValues = new String[size];
            int i = size;
            while (--i >= 0) {
                this.myValues[i] = (String)values.get(i).getValue();
            }
        }

        public String get(String ... tags) {
            int i = this.myTags.length;
            while (--i >= 0) {
                if (!Arrays.equals(this.myTags[i], tags)) continue;
                return this.myValues[i];
            }
            if (tags.length == 1) {
                String name = tags[0];
                int i2 = this.myNames.size();
                while (--i2 >= 0) {
                    if (!name.equals(this.myNames.get(i2))) continue;
                    return this.myValues[i2];
                }
            }
            throw new IllegalArgumentException("DomParserHelper.Struct.getValue(String...) no such tag");
        }
    }

    public static final class StructTarget
    extends ParseTarget<Struct> {
        private final List<String[]> myTags = new ArrayList<String[]>(10);
        private final List<ParseRule> myRules = new ArrayList<ParseRule>(10);
        private final List<String> myNames = new ArrayList<String>(10);

        public StructTarget(ParseRule rule, String ... tags) {
            super(ParseTargetType.TEXT, rule, tags);
        }

        public StructTarget(String ... tags) {
            super(ParseTargetType.TEXT, tags);
        }

        public void add(String name, ParseRule rule, String ... tags) {
            this.myNames.add(name);
            this.myTags.add(tags);
            this.myRules.add(rule);
        }

        public void add(String ... tags) {
            this.add((String)null, (ParseRule)null, tags);
        }

        @Override
        protected void addValue(Node value) {
            int size = this.myTags.size();
            ArrayList<StringTarget> targets = new ArrayList<StringTarget>(size);
            String[][] tags = new String[size][];
            int i = 0;
            while (i < size) {
                String[] tag = this.myTags.get(i);
                tags[i] = tag;
                ParseRule rule = this.myRules.get(i);
                StringTarget target = rule == null ? new StringTarget(ParseTargetType.TEXT, tag) : new StringTarget(ParseTargetType.TEXT, rule, tag);
                targets.add(target);
                ++i;
            }
            DomParserHelper.parseTarget(value, new ArrayList(targets));
            this.addValueImpl(new Struct(new ArrayList<String>(this.myNames), tags, targets));
        }
    }
}

