/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.rp.master.tool;

import com.nokia.em.poseidon.util.file.IOUtils;
import com.nokia.em.poseidon.util.file.PFileOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.tukaani.xz.XZ;
import org.tukaani.xz.XZInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class Tools {
    private static final String ZIPTYPE_GZ = "gz";
    private static final String ZIPTYPE_XZ = "xz";
    private static Logger myLogger = Logger.getLogger(Tools.class);

    private Tools() {
    }

    public static final String xmlToString(Node node) {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource source = new DOMSource(node);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            return writer.toString();
        }
        catch (Exception e) {
            myLogger.error((Object)"Failed to transform node into xml string.", (Throwable)e);
            return "";
        }
    }

    public static final Element parseElementFromString(String nodeString) {
        return Tools.parseElementFromSource(new InputSource(new StringReader(nodeString)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Element parseElementFromFile(String fileName) {
        Element element;
        FileInputStream is = null;
        try {
            is = new FileInputStream(fileName);
            element = Tools.parseElementFromSource(new InputSource(is));
        }
        catch (Exception ex) {
            try {
                myLogger.error((Object)("Cannot parse to xml from file:" + fileName + "."), (Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)is);
            return null;
        }
        IOUtils.closeQuietly((Closeable)is);
        return element;
    }

    public static final Element parseElementFromSource(InputSource source) {
        Document doc = null;
        try {
            DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBF.newDocumentBuilder();
            doc = docBuilder.parse(source);
            doc.getDocumentElement().normalize();
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            myLogger.error((Object)"Cannot parse xml.", (Throwable)ex);
            return null;
        }
    }

    public static final Element parseElement(String fileName) {
        Document doc = null;
        try {
            DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBF.newDocumentBuilder();
            FileInputStream is = new FileInputStream(fileName);
            doc = docBuilder.parse(is);
            IOUtils.closeQuietly((Closeable)is);
            doc.getDocumentElement().normalize();
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            myLogger.error((Object)"Cannot parse xml.", (Throwable)ex);
            return null;
        }
    }

    public static File gunZip(File file) {
        return Tools.unZip(file, ZIPTYPE_GZ);
    }

    public static File xunZip(File file) {
        return Tools.unZip(file, ZIPTYPE_XZ);
    }

    private static File unZip(File sourceFile, String zipType) {
        File xmlFile = null;
        try {
            xmlFile = File.createTempFile("BtsMgr", ".tmp");
            xmlFile.deleteOnExit();
            return Tools.unZip(sourceFile, zipType, xmlFile);
        }
        catch (IOException ioe) {
            myLogger.error((Object)"IOE, temp file create failed.", (Throwable)ioe);
            return null;
        }
    }

    public static File unZip(File sourceFile, File targetFile) {
        try {
            if (Tools.isXZipFile(sourceFile)) {
                return Tools.unZip(sourceFile, ZIPTYPE_XZ, targetFile);
            }
            if (Tools.isGZipFile(sourceFile)) {
                return Tools.unZip(sourceFile, ZIPTYPE_GZ, targetFile);
            }
        }
        catch (IOException ioe) {
            myLogger.error((Object)"IOE, cannot unzip file.", (Throwable)ioe);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File unZip(File sourceFile, String zipType, File targetFile) {
        File file;
        byte[] buffer = new byte[4096];
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int length;
            bufferedInputStream = new BufferedInputStream(Tools.buildZipInputStream(sourceFile, zipType));
            bufferedOutputStream = new BufferedOutputStream((OutputStream)new PFileOutputStream(targetFile));
            while ((length = bufferedInputStream.read(buffer)) > 0) {
                bufferedOutputStream.write(buffer, 0, length);
            }
            file = targetFile;
        }
        catch (IOException ioe) {
            try {
                myLogger.error((Object)"IOE, cannot unzip file.", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedInputStream);
                IOUtils.closeQuietly(bufferedOutputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)bufferedInputStream);
            IOUtils.closeQuietly(bufferedOutputStream);
            return null;
        }
        IOUtils.closeQuietly((Closeable)bufferedInputStream);
        IOUtils.closeQuietly((Closeable)bufferedOutputStream);
        return file;
    }

    private static InputStream buildZipInputStream(File file, String zipType) throws IOException {
        InputStream inputStream = null;
        if (ZIPTYPE_GZ.equals(zipType)) {
            inputStream = new GZIPInputStream(new FileInputStream(file));
        } else if (ZIPTYPE_XZ.equals(zipType)) {
            inputStream = new XZInputStream(new FileInputStream(file));
        }
        return inputStream;
    }

    public static File gZip(File file) {
        return Tools.gZip(file, ".gz");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File gZip(File file, String extension) {
        File file2;
        if (file == null) {
            myLogger.error((Object)"Cannot gZip null file.");
            return null;
        }
        if (extension == null || extension.length() < 1 || extension.endsWith(".")) {
            myLogger.error((Object)("Invalid parameter as extension, " + extension));
            return null;
        }
        File gzFile = new File(String.valueOf(file.getAbsolutePath()) + extension);
        byte[] buffer = new byte[4096];
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int lenght;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bufferedOutputStream = new BufferedOutputStream(new GZIPOutputStream((OutputStream)new PFileOutputStream(gzFile)));
            while ((lenght = bufferedInputStream.read(buffer)) > 0) {
                bufferedOutputStream.write(buffer, 0, lenght);
            }
            file2 = gzFile;
        }
        catch (IOException ioe) {
            block7: {
                try {
                    myLogger.error((Object)"Cannot gZip file,", (Throwable)ioe);
                    if (gzFile.delete()) break block7;
                    gzFile.deleteOnExit();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bufferedInputStream);
                    IOUtils.closeQuietly(bufferedOutputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)bufferedInputStream);
            IOUtils.closeQuietly(bufferedOutputStream);
            return null;
        }
        IOUtils.closeQuietly((Closeable)bufferedInputStream);
        IOUtils.closeQuietly((Closeable)bufferedOutputStream);
        return file2;
    }

    public static boolean isZipFile(File file) throws IOException {
        if (file.isDirectory()) {
            return false;
        }
        if (!file.canRead()) {
            throw new IOException("Cannot read file " + file.getAbsolutePath());
        }
        if (file.length() < 4L) {
            return false;
        }
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        int magicNumber = in.readInt();
        in.close();
        return magicNumber == 1347093252;
    }

    public static boolean isGZipFile(File file) throws IOException {
        if (file.isDirectory()) {
            return false;
        }
        if (!file.canRead()) {
            throw new IOException("Cannot read file " + file.getAbsolutePath());
        }
        if (file.length() < 2L) {
            return false;
        }
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        byte[] bytes = new byte[]{in.readByte(), in.readByte()};
        in.close();
        int head = bytes[0] & 0xFF | bytes[1] << 8 & 0xFF00;
        return 35615 == head;
    }

    public static boolean isXZipFile(File file) throws IOException {
        if (file.isDirectory()) {
            return false;
        }
        if (!file.canRead()) {
            throw new IOException("Cannot read file " + file.getAbsolutePath());
        }
        if (file.length() < (long)XZ.HEADER_MAGIC.length) {
            return false;
        }
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        byte[] streamHeader = new byte[XZ.HEADER_MAGIC.length];
        in.readFully(streamHeader);
        in.close();
        return Arrays.equals(streamHeader, XZ.HEADER_MAGIC);
    }

    public static void deleteFile(File file) {
        if (file != null && !file.delete()) {
            file.deleteOnExit();
        }
    }
}

