/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset;

import com.nokia.em.bts.coreasset.ascu.AntennaConfigurationManager;
import com.nokia.em.bts.coreasset.ascu.AntennaConfigurationManagerImpl;
import com.nokia.em.bts.coreasset.commissioning.CommissioningManager;
import com.nokia.em.bts.coreasset.commissioning.CommissioningManagerImpl;
import com.nokia.em.bts.coreasset.configuration.BTSConfigurationManager;
import com.nokia.em.bts.coreasset.configuration.BTSConfigurationManagerImpl;
import com.nokia.em.bts.coreasset.message.BTSMessageFactory;
import com.nokia.em.bts.coreasset.scenario.ScenarioManager;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.rp.master.RPMaster;
import com.nokia.em.bts.rp.master.RadioAccessTechnologyType;
import com.nokia.em.bts.rp.master.alarm.AlarmManager;
import com.nokia.em.bts.rp.master.alarm.AlarmManagerImpl;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.connection.BTSConnectionImpl;
import com.nokia.em.bts.rp.master.connection.MessageFactory;
import com.nokia.em.bts.rp.master.connection.SnapshotBTSConnectionImpl;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.security.AuthenticationManager;
import com.nokia.em.bts.rp.master.security.AuthenticationManagerImpl;
import com.nokia.em.bts.rp.master.snapshot.SnapshotManager;
import com.nokia.em.bts.rp.master.snapshot.SnapshotSaver;
import com.nokia.em.bts.rp.master.time.TimeManager;
import com.nokia.em.bts.rp.master.time.TimeZoneChangeListener;
import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.comm.ftp.PortRange;
import com.nokia.em.poseidon.plugin.service.Service;
import com.nokia.em.poseidon.services.certificate.CertificateService;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;

public class CoreAsset {
    public static final int SMALL = 10;
    public static final int MEDIUM = 20;
    public static final int LARGE = 50;
    public static final int UNKNOWN_INT = -1;
    public static final String UNKNOWN_STRING = "Coreasset_Unknown";
    public static final String UNAUTHORIZED_STRING = "Unauthorized";
    public static final float UNKNOWN_FLOAT = -1.0f;
    public static final long UNKNOWN_LONG = -1L;
    public static final String IF_MAJOR_VERSION = "1";
    public static final String IF_MINOR_VERSION = "0";
    public static final String FILE_SEPARATOR = RPMaster.FILE_SEPARATOR;
    public static Map<RadioAccessTechnologyType, BTSConfigurationManager> configurationManagers = Collections.synchronizedMap(new HashMap());
    private static volatile ScenarioManagerImpl myScenarioManager;
    private static final Logger myLogger;

    static {
        myLogger = Logger.getLogger(CoreAsset.class);
    }

    private CoreAsset() {
    }

    public static void setNeedsQueryFileTransferProtocol(boolean needs) {
        RPMaster.setNeedsQueryFileTransferProtocol((boolean)needs);
    }

    public static boolean getNeedsQueryFileTransferProtocol() {
        return RPMaster.getNeedsQueryFileTransferProtocol();
    }

    public static void initSnapshotManager(SnapshotManager manager) {
        RPMaster.initSnapshotManager((SnapshotManager)manager);
    }

    public static AlarmManager startAlarmManager(BTSConnection connection) {
        myLogger.debug((Object)"Starting alarm manager with connection.");
        return new AlarmManagerImpl(connection);
    }

    public static AlarmManager startAlarmManager(BTSConnection connection, BTSMessage.Type type) {
        myLogger.debug((Object)"Starting alarm manager with connection.");
        return new AlarmManagerImpl(connection, type);
    }

    public static Set<AlarmManager> startAlarmManagers(BTSConnection connection) {
        myLogger.debug((Object)"Starting alarm managers with connection.");
        CopyOnWriteArraySet<AlarmManager> myAlarmManagerSet = new CopyOnWriteArraySet<AlarmManager>();
        BTSMessage.Type[] typeArray = BTSMessage.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BTSMessage.Type type = typeArray[n2];
            myAlarmManagerSet.add((AlarmManager)new AlarmManagerImpl(connection, type));
            ++n2;
        }
        return myAlarmManagerSet;
    }

    public static Set<ScenarioManager> startScenarioManagers(BTSConnection connection) {
        myLogger.debug((Object)"Starting scenario managers with connection.");
        CopyOnWriteArraySet<ScenarioManager> myScenarioManagerSet = new CopyOnWriteArraySet<ScenarioManager>();
        BTSMessage.Type[] typeArray = BTSMessage.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BTSMessage.Type type = typeArray[n2];
            myScenarioManagerSet.add(new ScenarioManagerImpl(connection, type));
            ++n2;
        }
        return myScenarioManagerSet;
    }

    public static AlarmManager startAlarmManager() {
        myLogger.debug((Object)"Starting alarm manager.");
        return new AlarmManagerImpl();
    }

    public static AuthenticationManager startAuthenticationManager(BTSConnection connection) {
        myLogger.debug((Object)"Starting authentication manager.");
        return new AuthenticationManagerImpl(connection);
    }

    public static BTSConfigurationManager startBTSConfigurationManager(BTSConnection connection, TimeZoneChangeListener listener) {
        myLogger.debug((Object)"Starting configuration manager.");
        return new BTSConfigurationManagerImpl(connection, listener);
    }

    public static BTSConfigurationManager getBTSConfigurationManager(BTSConnection connection, TimeZoneChangeListener listener, RadioAccessTechnologyType type) {
        myLogger.debug((Object)"Starting configuration manager.");
        if (configurationManagers.get(type) == null) {
            configurationManagers.put(type, new BTSConfigurationManagerImpl(connection, listener, type));
        }
        return configurationManagers.get(type);
    }

    public static TimeManager startTimeManager() {
        return RPMaster.startTimeManager();
    }

    public static ScenarioManager startScenarioManager(BTSConnection connection) {
        if (myScenarioManager == null) {
            myLogger.debug((Object)"Starting scenario manager.");
            myScenarioManager = new ScenarioManagerImpl(connection);
        } else {
            myLogger.debug((Object)"Starting scenario manager, but it already exist. Setting connection to previous scenario manager.");
            myScenarioManager.setConnection(connection);
        }
        return myScenarioManager;
    }

    public static ScenarioManager startScenarioManager(BTSConnection connection, BTSMessage.Type type) {
        if (myScenarioManager == null) {
            myLogger.debug((Object)"Starting scenario manager.");
            myScenarioManager = new ScenarioManagerImpl(connection, type);
        } else {
            myLogger.debug((Object)"Starting scenario manager, but it already exist. Setting connection to previous scenario manager.");
            myScenarioManager.setConnection(connection);
        }
        return myScenarioManager;
    }

    public static BTSConnection startBTSConnection() {
        BTSConnection connection = RPMaster.startBTSConnection((boolean)false);
        connection.addMessageFactory((MessageFactory)new BTSMessageFactory());
        return connection;
    }

    public static BTSConnection startBTSConnection(TimeZoneChangeListener listener) {
        return CoreAsset.startBTSConnection(listener, false);
    }

    public static BTSConnection startBTSConnection(TimeZoneChangeListener listener, boolean randomSeqnum) {
        if (CoreAsset.isSnapshotOpening()) {
            myLogger.debug((Object)"Starting BTS connection in snapshot open mode with timezone listener.");
            SnapshotBTSConnectionImpl snapshotConnection = new SnapshotBTSConnectionImpl(listener);
            snapshotConnection.start();
            return snapshotConnection;
        }
        myLogger.debug((Object)"Starting BTS connection with timezone listener.");
        BTSConnectionImpl connection = (BTSConnectionImpl)PoseidonRuntime.getRuntime().getService(BTSConnectionImpl.class);
        if (connection == null) {
            connection = new BTSConnectionImpl(listener, randomSeqnum);
            connection.addMessageFactory((MessageFactory)new BTSMessageFactory());
            PoseidonRuntime.getRuntime().addService((Service)connection, "BTSConnection", false);
        }
        connection.addTimeZoneChangeListener(listener);
        connection.start();
        return connection;
    }

    public static AntennaConfigurationManager startAntennaConfigurationManager() {
        myLogger.debug((Object)"Starting antenna configuration manager.");
        return new AntennaConfigurationManagerImpl();
    }

    public static CommissioningManager startCommissioningManager(BTSConnection connection) {
        myLogger.debug((Object)"Starting commissioning manager.");
        return new CommissioningManagerImpl(connection);
    }

    public static String getVersion() {
        try {
            Package pckg = CoreAsset.class.getPackage();
            String version = pckg.getImplementationVersion();
            if (version != null) {
                return version;
            }
        }
        catch (Exception e) {
            myLogger.error((Object)"Cannot get version, ", (Throwable)e);
        }
        return UNKNOWN_STRING;
    }

    public static PortRange getFTPServerPortRange() {
        return RPMaster.getFTPServerPortRange();
    }

    public static void setFTPServerPortRange(PortRange portRange) {
        RPMaster.setFTPServerPortRange((PortRange)portRange);
    }

    public static CertificateService getPoseidonCertificateService() {
        if (PoseidonRuntime.getRuntime().getParameters().isDefined("acceptAllCerts")) {
            return null;
        }
        return (CertificateService)PoseidonRuntime.getRuntime().getService(CertificateService.class);
    }

    public static void addSnapshotSaver(SnapshotSaver saver) {
        RPMaster.addSnapshotSaver((SnapshotSaver)saver);
    }

    public static void removeSnapshotSaver(SnapshotSaver saver) {
        RPMaster.removeSnapshotSaver((SnapshotSaver)saver);
    }

    public static void removeAllSnapshotSavers() {
        RPMaster.removeAllSnapshotSavers();
    }

    public static boolean isSnapshotOpening() {
        return RPMaster.isSnapshotOpening();
    }

    public static URL getSnapshotOpenLocation() {
        return RPMaster.getSnapshotOpenLocation();
    }
}

