/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.ascu;

import com.nokia.em.bts.coreasset.ascu.AntennaConfigurationManagerImpl;
import com.nokia.em.poseidon.util.concurrency.CachedThread;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

public class ASCUConnectionWatcher
extends CachedThread {
    private XmlRpcClient myASCU = null;
    private AntennaConfigurationManagerImpl myAntennaManager;
    private int myIntInterval = 10000;
    private boolean myBlnRun = false;
    private boolean myBlnDropped = false;
    private Logger myLogger = Logger.getLogger(((Object)((Object)this)).getClass());

    public ASCUConnectionWatcher(AntennaConfigurationManagerImpl antennaManager, XmlRpcClient ASCU, int intPollingInterval) {
        this.myAntennaManager = antennaManager;
        this.myASCU = ASCU;
        this.myIntInterval = intPollingInterval;
    }

    public void newConnection(AntennaConfigurationManagerImpl antennaManager, XmlRpcClient ASCU, int intPollingInterval) {
        this.myBlnDropped = false;
        this.myAntennaManager = antennaManager;
        this.myASCU = ASCU;
        this.myIntInterval = intPollingInterval;
    }

    public synchronized void safeStop() {
        this.myLogger.debug((Object)"Stop the poller");
        this.myBlnRun = false;
        ((Object)((Object)this)).notify();
    }

    public synchronized void setInterval(int intInterval) {
        this.myLogger.debug((Object)("Sets poller interval from " + this.myIntInterval + " to " + intInterval));
        this.myIntInterval = intInterval;
        ((Object)((Object)this)).notify();
    }

    public synchronized void run() {
        this.myLogger.debug((Object)"run started.");
        this.myBlnRun = true;
        while (this.myBlnRun) {
            try {
                ((Object)((Object)this)).wait(this.myIntInterval);
                if (this.myAntennaManager.isConnected()) {
                    Vector params = new Vector();
                    Object response = this.myASCU.execute("ascu.getInServiceTime", params);
                    this.myLogger.trace((Object)("Connection is OK with response: " + response));
                    this.connectionResumed();
                    continue;
                }
                this.myLogger.trace((Object)"Not connecting to RCU, skip query status");
            }
            catch (InterruptedException ie) {
                this.myLogger.error((Object)"run", (Throwable)ie);
                this.myBlnRun = false;
                break;
            }
            catch (XmlRpcException exception) {
                this.myLogger.error((Object)("run XML-RPC Fault #" + Integer.toString(exception.code) + ": "), (Throwable)exception);
                this.connectionLost();
            }
            catch (IOException exception) {
                this.myLogger.error((Object)"Oops.. something wrong in the communication", (Throwable)exception);
                this.connectionLost();
            }
        }
        this.myLogger.debug((Object)"run stopped.");
    }

    private void connectionResumed() {
        if (this.myBlnDropped) {
            this.myLogger.debug((Object)"Connection is resumed, notify listeners");
            this.myAntennaManager.ascuConnectionResumed();
            this.myBlnDropped = false;
        }
    }

    private void connectionLost() {
        if (!this.myBlnDropped) {
            this.myLogger.debug((Object)"Connection is lost, notify listeners");
            this.myAntennaManager.ascuConnectionDropped();
            this.myBlnDropped = true;
        }
    }
}

