/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.ascu;

import com.nokia.em.bts.coreasset.ascu.AntennaConfigListener;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.AsyncCallback;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;

public class AntennaCalibrationHandler
implements AsyncCallback {
    private String myStrAntennaID = "";
    private List myVecAntennaConfigListeners = new Vector();
    private XmlRpcHandler myXmlRpcClient = null;
    private static final int POLLING_DELAY = 2000;
    private Logger myLogger = Logger.getLogger(this.getClass());

    public AntennaCalibrationHandler(String strAntennaID, List vecAntennaConfigListeners, XmlRpcHandler XmlRpcClient2) {
        this.myStrAntennaID = strAntennaID;
        this.myVecAntennaConfigListeners = vecAntennaConfigListeners;
        this.myXmlRpcClient = XmlRpcClient2;
    }

    public void handleResult(Object result, URL url, String method) {
        String strStatusString = "Busy";
        String strOriginalResult = (String)result;
        if ("OK".equalsIgnoreCase(strOriginalResult)) {
            Vector<String> params = new Vector<String>();
            params.addElement(this.myStrAntennaID);
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                this.myLogger.error((Object)e);
            }
            while (!"OK".equalsIgnoreCase(strStatusString)) {
                block13: {
                    try {
                        Object response = this.myXmlRpcClient.execute("eta.getStatus", params);
                        this.myLogger.debug((Object)("in > " + response.toString()));
                        Hashtable hshtCurrentAntenna = this.getCurrentAntenna(response);
                        Vector currentStatus = (Vector)hshtCurrentAntenna.get("Status");
                        strStatusString = (String)currentStatus.elementAt(0);
                        if (!("OK".equalsIgnoreCase(strStatusString) || "Busy".equalsIgnoreCase(strStatusString) || "DEVICE_MOVING".equalsIgnoreCase(strStatusString) || "DEVICE_SCANNING".equalsIgnoreCase(strStatusString))) {
                            this.sendCalibrationFailed(strStatusString);
                            break;
                        }
                        if (!"OK".equalsIgnoreCase(strStatusString)) break block13;
                        this.sendCalibrationReady();
                        break;
                    }
                    catch (XmlRpcException exception) {
                        this.myLogger.error((Object)(" XML-RPC Fault #" + Integer.toString(exception.code) + ": "), (Throwable)exception);
                        this.sendEtaError(exception);
                    }
                    catch (Exception exception) {
                        this.myLogger.error((Object)exception);
                    }
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception e) {
                    this.myLogger.error((Object)"Sleep interrupted: ", (Throwable)e);
                }
            }
        } else {
            int i = 0;
            while (i < this.myVecAntennaConfigListeners.size()) {
                ((AntennaConfigListener)this.myVecAntennaConfigListeners.get(i)).etaError(-1, (String)result);
                ++i;
            }
        }
    }

    public void handleError(Exception exception, URL url, String method) {
        int i = 0;
        while (i < this.myVecAntennaConfigListeners.size()) {
            ((AntennaConfigListener)this.myVecAntennaConfigListeners.get(i)).calibrationFailed(this.myStrAntennaID, "-1", exception.toString());
            ++i;
        }
    }

    private Hashtable getCurrentAntenna(Object response) {
        Hashtable ht = null;
        Vector vecReturnValue = (Vector)response;
        int i = 0;
        while (i < vecReturnValue.size()) {
            ht = (Hashtable)vecReturnValue.elementAt(i);
            if (ht.containsValue(this.myStrAntennaID)) break;
            ++i;
        }
        return ht;
    }

    private void sendCalibrationFailed(String strStatusString) {
        int i = 0;
        while (i < this.myVecAntennaConfigListeners.size()) {
            ((AntennaConfigListener)this.myVecAntennaConfigListeners.get(i)).calibrationFailed(this.myStrAntennaID, strStatusString, "Calibration failed");
            ++i;
        }
    }

    private void sendCalibrationReady() {
        int i = 0;
        while (i < this.myVecAntennaConfigListeners.size()) {
            ((AntennaConfigListener)this.myVecAntennaConfigListeners.get(i)).calibrationReady(this.myStrAntennaID);
            ++i;
        }
    }

    private void sendEtaError(XmlRpcException exception) {
        int i = 0;
        while (i < this.myVecAntennaConfigListeners.size()) {
            ((AntennaConfigListener)this.myVecAntennaConfigListeners.get(i)).etaError(exception.code, exception.toString());
            ++i;
        }
    }
}

